/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.common.log;

import android.content.Context;
import android.util.Log;
import com.engagelab.privates.common.constants.MTCommonConstants;
import com.engagelab.privates.common.log.MTLogEntry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MTLogCache {
    private static final String TAG = MTCommonConstants.getLogTag() + "MTLogCache";
    private static final String PROCESS_TYPE_MAIN = "MAIN";
    private static final String PROCESS_TYPE_SUB = "SUB";
    private static final String PROCESS_TYPE_UNKNOWN = "UNKNOWN";
    private static final String FILE_STATUS_ACTIVE = "_ACTIVE";
    private static final String FILE_STATUS_CLOSED = "_CLOSED";
    private static final String LOG_DIR_PREFIX = "com_engagelab_l_r";
    private static final String LOG_DIR_NAME = "tmp_log";
    private static final String LOG_FILE_PREFIX = "log_";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String TIMESTAMP_FORMAT_PATTERN = "yyyyMMdd_HHmmss";
    private static final String FILE_ENCODING = "UTF-8";
    private static final String LINE_SEPARATOR_PROPERTY = "line.separator";
    private static volatile MTLogCache instance;
    private static final Object LOCK;
    private static final long MAX_FILE_SIZE = 0x100000L;
    private File logDirBasePath = null;
    private Context context;
    private File currentLogFile;
    private BufferedWriter currentWriter;
    private final ReadWriteLock fileLock;
    private volatile ExecutorService writeExecutor;
    private final SimpleDateFormat dateFormat;
    private volatile boolean isSetEnabled;
    private volatile boolean isEnabledAll;
    private volatile boolean isSetEnabledAll;
    private volatile boolean isEnabled;
    private volatile long maxTotalSize;
    private volatile boolean isReuseActiveFile;
    private volatile boolean isSetReuseActiveFile;
    private volatile String currentProcessType;
    private volatile boolean isProcessTypeSet;
    private final LinkedList<MTLogEntry> memoryCacheList;
    private final int MAX_MEMORY_CACHE_SIZE;
    private volatile long currentFileSize;
    private boolean isInitLogFile;

    private MTLogCache() {
        LinkedList linkedList;
        SimpleDateFormat simpleDateFormat;
        ReentrantReadWriteLock reentrantReadWriteLock;
        Object this_ = reentrantReadWriteLock;
        reentrantReadWriteLock = new ReentrantReadWriteLock();
        v1.fileLock = this_;
        this_ = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN, Locale.getDefault());
        v1.dateFormat = this_;
        v1.isSetEnabled = false;
        v1.isEnabledAll = false;
        v1.isSetEnabledAll = false;
        v1.isEnabled = false;
        v1.maxTotalSize = 0x500000L;
        v1.isReuseActiveFile = true;
        v1.isSetReuseActiveFile = false;
        v1.currentProcessType = PROCESS_TYPE_UNKNOWN;
        v1.isProcessTypeSet = false;
        this_ = linkedList;
        linkedList = new LinkedList();
        v1.memoryCacheList = this_;
        v1.MAX_MEMORY_CACHE_SIZE = 1000;
        v1.currentFileSize = 0L;
        v1.isInitLogFile = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MTLogCache getInstance() {
        block4: {
            if (instance != null) break block4;
            Object object = LOCK;
            synchronized (object) {
                if (instance != null) break block4;
                instance = new MTLogCache();
            }
        }
        return instance;
    }

    private String getCurrentProcessType() {
        return this.currentProcessType;
    }

    private synchronized ExecutorService getWriteExecutor() {
        if (this.writeExecutor == null) {
            this.writeExecutor = Executors.newSingleThreadExecutor();
        }
        return this.writeExecutor;
    }

    private void initImp() {
        if (!this.isOK()) {
            return;
        }
        this.getWriteExecutor().submit(new Runnable(){

            @Override
            public void run() {
                MTLogCache.this.initLogFile();
            }
        });
    }

    private boolean isOK() {
        if (this.context == null) {
            return false;
        }
        if (!this.isEnabled) {
            return false;
        }
        if (!this.isProcessTypeSet) {
            return false;
        }
        return this.isSetReuseActiveFile;
    }

    private long getCurrentTotalSize() {
        File file = ((MTLogCache)((Object)this_)).getLogPath();
        if (file != null && file.exists()) {
            List<File> list = ((MTLogCache)((Object)this_)).getAllLogFiles();
            long l2 = 0L;
            try {
                Iterator<File> this_ = list.iterator();
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)("getCurrentTotalSize failed: " + exception.getMessage()));
                return 0L;
            }
            while (true) {
                if (!this_.hasNext()) break;
                l2 += ((File)this_.next()).length();
                continue;
                break;
            }
            return l2;
        }
        return 0L;
    }

    private File getCurrentProcessActiveLogFile() {
        File[] fileArray = this.getLogPath();
        if (fileArray != null && fileArray.exists()) {
            if ((fileArray = fileArray.listFiles()) == null) {
                return null;
            }
            for (File file : fileArray) {
                if (!file.isFile() || !this.isCurrentProcessActiveLogFile(file)) continue;
                return file;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isCurrentProcessActiveLogFile(File file) {
        void var1_1;
        if (file != null && var1_1.exists()) {
            String string = var1_1.getName();
            return string.startsWith(LOG_FILE_PREFIX) && string.endsWith("_ACTIVE.log") && this.isCurrentProcessLogFile((File)var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void writeLog(String level, String tag, String message) {
        MTLogEntry mTLogEntry;
        void var3_3;
        void var2_2;
        String string;
        if (!((MTLogCache)((Object)this_)).isSetEnabled) {
            MTLogEntry mTLogEntry2;
            MTLogCache mTLogCache = this_;
            MTLogEntry mTLogEntry3 = mTLogEntry2;
            String this_ = ((MTLogCache)((Object)this_)).getCurrentProcessType();
            mTLogEntry2 = new MTLogEntry(string, (String)var2_2, (String)var3_3, this_);
            mTLogCache.addToMemoryCache(mTLogEntry3);
            return;
        }
        if (!((MTLogCache)((Object)this_)).isEnabled) {
            ((MTLogCache)((Object)this_)).clearMemoryCacheList();
            return;
        }
        final MTLogEntry mTLogEntry4 = mTLogEntry;
        void v3 = string;
        string = super.getCurrentProcessType();
        mTLogEntry = new MTLogEntry((String)v3, (String)var2_2, (String)var3_3, string);
        ((MTLogCache)((Object)this_)).getWriteExecutor().submit(new Runnable((String)var2_2, (String)var3_3){
            public final /* synthetic */ String b;
            public final /* synthetic */ String c;
            {
                this.b = string;
                this.c = string2;
            }

            @Override
            public void run() {
                if (!MTLogCache.this.isOK()) {
                    MTLogCache.access$300(MTLogCache.this, mTLogEntry4);
                    Log.d((String)TAG, (String)("Process type not set, log cached to memory: " + this.b + " - " + this.c));
                    return;
                }
                c c2 = this;
                c2.MTLogCache.this.initLogFile();
                c2.MTLogCache.this.flushMemoryCache();
                MTLogCache.access$600(c2.MTLogCache.this, mTLogEntry4);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean clearMemoryCacheList() {
        MTLogCache mTLogCache = this;
        LinkedList<MTLogEntry> linkedList = mTLogCache.memoryCacheList;
        synchronized (linkedList) {
            if (mTLogCache.memoryCacheList.isEmpty()) {
                return true;
            }
            this.memoryCacheList.clear();
            return false;
        }
    }

    private List<File> getAllLogFiles() {
        File object = this.getLogPath();
        if (object != null && object.exists()) {
            Comparator<File> comparator;
            ArrayList<File> arrayList;
            File[] fileArray = object.listFiles();
            if (fileArray == null) {
                return new ArrayList<File>();
            }
            ArrayList<File> arrayList2 = arrayList;
            arrayList = new ArrayList<File>();
            for (File file : fileArray) {
                if (!file.isFile() || !file.getName().endsWith(LOG_FILE_EXTENSION)) continue;
                arrayList2.add(file);
            }
            ArrayList<File> arrayList3 = arrayList2;
            Comparator<File> comparator2 = comparator;
            comparator = new Comparator<File>(this){

                public int a(File file, File file2) {
                    long l2 = file.lastModified() - file2.lastModified();
                    long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                    return l3 < 0 ? 1 : (l3 == false ? 0 : -1);
                }
            };
            Collections.sort(arrayList3, comparator2);
            return arrayList3;
        }
        return new ArrayList<File>();
    }

    private boolean isCurrentProcessLogFile(File file) {
        String string;
        if (file != null && ((File)((Object)string)).exists()) {
            if ((string = ((File)((Object)string)).getName()).startsWith(LOG_FILE_PREFIX) && string.endsWith(LOG_FILE_EXTENSION)) {
                block7: {
                    String string2 = string;
                    int n2 = 0;
                    String[] stringArray = string2.substring(n2, string2.lastIndexOf(LOG_FILE_EXTENSION)).split("_");
                    if (stringArray.length < 4) break block7;
                    String[] stringArray2 = stringArray;
                    int n3 = stringArray.length;
                    try {
                        return stringArray2[n3 - 2].equals(this.getCurrentProcessType());
                    }
                    catch (Exception exception) {
                        Log.w((String)TAG, (String)("Failed to parse process type from file name: " + string));
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initLogFile() {
        if (this.context == null) {
            return;
        }
        if (this.isInitLogFile) {
            return;
        }
        try {
            int n2;
            MTLogCache mTLogCache = this;
            mTLogCache.cleanupOldLogFiles();
            File file = mTLogCache.getCurrentProcessActiveLogFile();
            if (mTLogCache.isReuseActiveFile && file != null && file.exists()) {
                long l2 = file.length();
                if (l2 < 0x100000L) {
                    this.currentLogFile = file;
                    this.currentFileSize = l2;
                    this.createNewWriter();
                    n2 = Log.i((String)TAG, (String)("Reusing active file: " + file.getName() + " (size: " + l2 + " bytes)"));
                } else {
                    MTLogCache mTLogCache2 = this;
                    mTLogCache2.markFileAsClosed(file);
                    mTLogCache2.switchToNewLogFileSync();
                    n2 = Log.i((String)TAG, (String)("Active file size exceeds limit, creating new file: " + file.getName() + " (size: " + l2 + " bytes)"));
                }
            } else {
                if (file != null) {
                    this.markFileAsClosed(file);
                }
                this.switchToNewLogFileSync();
                n2 = Log.i((String)TAG, (String)"Creating new log file (reuse disabled or no active file found)");
            }
            this.flushMemoryCache();
            this.isInitLogFile = true;
            return;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("initLogDirectory failed: " + exception.getMessage()));
        }
    }

    private File getLogPath() {
        Object object = this.logDirBasePath;
        if (object == null) {
            File file;
            object = File.separator;
            object = LOG_DIR_PREFIX + (String)object + this.context.getPackageName() + (String)object + LOG_DIR_NAME;
            File file2 = file;
            if (!new File(this.context.getFilesDir(), (String)object).exists()) {
                file2.mkdirs();
            }
            this.logDirBasePath = file2;
        } else if (!((File)object).exists()) {
            this.logDirBasePath.mkdirs();
        }
        return this.logDirBasePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void addToMemoryCache(MTLogEntry entry) {
        MTLogCache mTLogCache = this;
        LinkedList<MTLogEntry> linkedList = mTLogCache.memoryCacheList;
        synchronized (linkedList) {
            block6: {
                void var1_1;
                mTLogCache.memoryCacheList.addLast((MTLogEntry)var1_1);
                if (mTLogCache.memoryCacheList.size() <= 1000) break block6;
                this.memoryCacheList.removeFirst();
                Log.w((String)TAG, (String)"Memory cache exceeded max size, removed oldest entry");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void flushMemoryCache() {
        MTLogCache mTLogCache = this;
        LinkedList<MTLogEntry> linkedList = mTLogCache.memoryCacheList;
        synchronized (linkedList) {
            if (mTLogCache.memoryCacheList.isEmpty()) {
                return;
            }
            MTLogCache mTLogCache2 = this;
            Log.i((String)TAG, (String)("Flushing " + this.memoryCacheList.size() + " cached entries to file"));
            {
                Iterator iterator = mTLogCache2.memoryCacheList.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.memoryCacheList.clear();
                        return;
                    }
                    this.writeLogSync((MTLogEntry)iterator.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void switchToNewLogFileSync() {
        Throwable throwable2;
        block9: {
            MTLogCache mTLogCache;
            block10: {
                MTLogCache mTLogCache2;
                MTLogCache mTLogCache3;
                String string;
                File file = this.getLogPath();
                if (file == null) {
                    Log.w((String)TAG, (String)"switchToNewLogFileSync: logDir not ready");
                    return;
                }
                MTLogCache mTLogCache4 = this;
                mTLogCache = mTLogCache4;
                mTLogCache4.fileLock.writeLock().lock();
                try {
                    string = TAG;
                }
                catch (Throwable throwable2) {
                    break block9;
                }
                catch (Exception exception) {
                    mTLogCache = this;
                    Log.e((String)TAG, (String)("switchToNewLogFileSync failed: " + exception.getMessage()));
                    break block10;
                }
                String string2 = string;
                {
                    MTLogCache mTLogCache5 = this;
                    mTLogCache3 = mTLogCache5;
                    mTLogCache2 = mTLogCache5;
                    MTLogCache mTLogCache6 = mTLogCache5;
                    MTLogCache mTLogCache7 = mTLogCache5;
                    Log.d((String)string2, (String)("currentLogFile : " + this.currentLogFile));
                }
                {
                    mTLogCache3.closeCurrentWriterAndMarkFile();
                }
                {
                    string2 = new SimpleDateFormat(TIMESTAMP_FORMAT_PATTERN, Locale.getDefault()).format(new Date());
                    string2 = LOG_FILE_PREFIX + string2 + "_" + mTLogCache2.getCurrentProcessType() + FILE_STATUS_ACTIVE + LOG_FILE_EXTENSION;
                    mTLogCache6.currentLogFile = new File(file, string2);
                    mTLogCache7.currentFileSize = 0L;
                    Log.d((String)string, (String)("currentLogFile 1: " + this.currentLogFile));
                }
                mTLogCache4.createNewWriter();
                mTLogCache4.cleanupOldLogFiles();
            }
            mTLogCache.fileLock.writeLock().unlock();
            return;
        }
        this.fileLock.writeLock().unlock();
        throw throwable2;
    }

    private void createNewWriter() {
        block5: {
            OutputStreamWriter outputStreamWriter;
            FileOutputStream fileOutputStream;
            if (((MTLogCache)((Object)this_)).currentLogFile == null) break block5;
            MTLogCache mTLogCache = this_;
            FileOutputStream fileOutputStream2 = fileOutputStream;
            fileOutputStream = new FileOutputStream(((MTLogCache)((Object)this_)).currentLogFile, true);
            OutputStreamWriter this_ = outputStreamWriter;
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream2, FILE_ENCODING);
                mTLogCache.currentWriter = new BufferedWriter(this_);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)("createNewWriter failed: " + exception.getMessage()));
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private void writeLogSync(MTLogEntry entry) {
        Throwable throwable2;
        block10: {
            MTLogCache mTLogCache;
            block9: {
                block8: {
                    block7: {
                        if (this.getLogPath() == null) {
                            Log.w((String)TAG, (String)"writeLogSync: logDir not ready, entry ignored");
                            return;
                        }
                        MTLogCache mTLogCache2 = this;
                        mTLogCache2.fileLock.readLock().lock();
                        if (mTLogCache2.currentWriter != null) break block7;
                        MTLogCache mTLogCache3 = this;
                        Log.w((String)TAG, (String)"writeLogSync: currentWriter is null");
                        mTLogCache3.fileLock.readLock().unlock();
                        return;
                    }
                    if (this.currentFileSize < 0x100000L) break block8;
                    MTLogCache mTLogCache4 = this;
                    mTLogCache4.fileLock.readLock().unlock();
                    mTLogCache4.switchToNewLogFileSync();
                    mTLogCache4.fileLock.readLock().lock();
                    if (mTLogCache4.currentWriter != null) break block8;
                    this.fileLock.readLock().unlock();
                    return;
                }
                try {
                    String string;
                    MTLogCache mTLogCache5 = this;
                    mTLogCache = mTLogCache5;
                    string = mTLogCache5.formatLogEntry((MTLogEntry)((Object)string));
                    mTLogCache5.currentWriter.write(string);
                    mTLogCache5.currentWriter.newLine();
                    mTLogCache5.currentWriter.flush();
                    mTLogCache5.currentFileSize += (long)(string.getBytes(FILE_ENCODING).length + System.getProperty(LINE_SEPARATOR_PROPERTY).getBytes(FILE_ENCODING).length);
                    break block9;
                    catch (Throwable throwable2) {
                        break block10;
                    }
                }
                catch (Exception exception) {
                    mTLogCache = this;
                    Log.e((String)TAG, (String)("writeLogSync failed: " + exception.getMessage()));
                }
            }
            mTLogCache.fileLock.readLock().unlock();
            return;
        }
        this.fileLock.readLock().unlock();
        throw throwable2;
    }

    /*
     * WARNING - void declaration
     */
    private String formatLogEntry(MTLogEntry entry) {
        void var1_1;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
        StringBuilder stringBuilder4 = stringBuilder2;
        StringBuilder stringBuilder5 = stringBuilder2;
        StringBuilder stringBuilder6 = stringBuilder2;
        StringBuilder stringBuilder7 = stringBuilder2;
        StringBuilder stringBuilder8 = stringBuilder2;
        stringBuilder2();
        stringBuilder8.append(this.dateFormat.format(new Date(var1_1.getTimestamp())));
        stringBuilder8.append(" ");
        stringBuilder7.append(var1_1.getProcessId());
        stringBuilder7.append(" ");
        stringBuilder6.append(var1_1.getThreadId());
        stringBuilder6.append(" ");
        stringBuilder5.append(var1_1.getProcessType());
        stringBuilder5.append(" ");
        stringBuilder4.append(var1_1.getLevel());
        stringBuilder4.append(" ");
        stringBuilder3.append(var1_1.getTag());
        stringBuilder3.append(": ");
        stringBuilder.append(var1_1.getMessage());
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanupOldLogFiles() {
        int n2;
        Object object = this.getLogPath();
        if (object == null) return;
        if (!((File)object).exists()) {
            return;
        }
        object = this.getAllLogFiles();
        long l2 = 0L;
        Iterator<File> iterator = object.iterator();
        while (iterator.hasNext()) {
            l2 += iterator.next().length();
        }
        if (l2 <= this.maxTotalSize) return;
        Object object2 = object;
        Log.i((String)TAG, (String)("Total log files size (" + l2 + " bytes) exceeds limit (" + this.maxTotalSize + " bytes), cleaning up..."));
        try {
            n2 = object2.size() - 1;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("cleanupOldLogFiles failed: " + exception.getMessage()));
        }
        while (n2 >= 0) {
            block11: {
                File file = (File)object.get(n2);
                long l3 = file.length();
                if (!file.exists() || !file.delete()) break block11;
                l2 -= l3;
                MTLogCache mTLogCache = this;
                Log.i((String)TAG, (String)("Deleted old log file: " + file.getName() + " (size: " + l3 + " bytes)"));
                if (l2 > mTLogCache.maxTotalSize) break block11;
                return;
            }
            --n2;
        }
        return;
    }

    private void closeCurrentWriter() {
        BufferedWriter bufferedWriter = this.currentWriter;
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Log.e((String)TAG, (String)("closeCurrentWriter failed: " + iOException.getMessage()));
            }
            this.currentWriter = null;
        }
    }

    private void closeCurrentWriterAndMarkFile() {
        MTLogCache mTLogCache = this;
        mTLogCache.closeCurrentWriter();
        File file = mTLogCache.currentLogFile;
        if (file != null && file.exists()) {
            MTLogCache mTLogCache2 = this;
            mTLogCache2.markFileAsClosed(mTLogCache2.currentLogFile);
            mTLogCache2.currentLogFile = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clearAllLogsSync() {
        block10: {
            v0 = this;
            v0.fileLock.writeLock().lock();
            v0.closeCurrentWriter();
            var1_1 = v0.getLogPath();
            if (var1_1 == null || !var1_1.exists() || (var1_1 = var1_1.listFiles()) == null) break block10;
            ** for (var4_5 : var1_1)
lbl-1000:
            // 1 sources

            {
                if (!var4_5.isFile()) continue;
                var4_5.delete();
                continue;
            }
        }
        v1 = this;
        this.currentLogFile = null;
        this.currentFileSize = 0L;
        v1.fileLock.writeLock().unlock();
        return;
        {
            catch (Throwable v2) {}
            catch (Exception var1_2) {}
            {
                v1 = this;
                Log.e((String)MTLogCache.TAG, (String)("clearAllLogsSync failed: " + var1_2.getMessage()));
            }
        }
        ** finally { 
lbl26:
        // 1 sources

        this.fileLock.writeLock().unlock();
        throw v2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void markFileAsClosed(File file) {
        int n2;
        block8: {
            void var1_2;
            if (file == null || !var1_2.exists()) return;
            String string = var1_2.getName();
            if (!string.contains(FILE_STATUS_ACTIVE)) return;
            void v02 = var1_2;
            String string2 = string.replace(FILE_STATUS_ACTIVE, FILE_STATUS_CLOSED);
            if (!v02.renameTo(new File(var1_2.getParent(), string2))) break block8;
            n2 = Log.i((String)TAG, (String)("Marked file as closed: " + (String)string + " -> " + string2));
            return;
        }
        try {
            n2 = Log.w((String)TAG, (String)("Failed to mark file as closed: " + (String)string));
            return;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("markFileAsClosed failed: " + exception.getMessage()));
        }
    }

    private List<File> getAllActiveLogFiles() {
        ArrayList<File> arrayList;
        ArrayList<File> arrayList2 = arrayList;
        arrayList = new ArrayList<File>();
        for (File file : this.getAllLogFiles()) {
            if (!this.isActiveLogFile(file)) continue;
            arrayList2.add(file);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isActiveLogFile(File file) {
        void var1_1;
        if (file != null && var1_1.exists()) {
            String string = var1_1.getName();
            return string.startsWith(LOG_FILE_PREFIX) && string.contains(FILE_STATUS_ACTIVE);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isClosedLogFile(File file) {
        void var1_1;
        if (file != null && var1_1.exists()) {
            String string = var1_1.getName();
            return string.startsWith(LOG_FILE_PREFIX) && string.contains(FILE_STATUS_CLOSED);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void access$300(MTLogCache x02, MTLogEntry x1) {
        void var1_1;
        x02.addToMemoryCache((MTLogEntry)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void access$600(MTLogCache x02, MTLogEntry x1) {
        void var1_1;
        x02.writeLogSync((MTLogEntry)var1_1);
    }

    static {
        LOCK = new Object();
    }

    public void setProcessType(boolean isMainProcess) {
        String string = isMainProcess ? PROCESS_TYPE_MAIN : PROCESS_TYPE_SUB;
        this.currentProcessType = string;
        this.isProcessTypeSet = true;
        Log.i((String)TAG, (String)("Process type set to: " + this.currentProcessType));
        this.initImp();
    }

    public boolean isProcessTypeSet() {
        return this.isProcessTypeSet;
    }

    /*
     * WARNING - void declaration
     */
    public void init(Context context) {
        void var1_1;
        this.context = var1_1.getApplicationContext();
        this.initImp();
    }

    /*
     * WARNING - void declaration
     */
    public void setEnabled(boolean enabled) {
        void var1_1;
        this.isEnabled = var1_1;
        this.isSetEnabled = true;
        this.initImp();
    }

    /*
     * WARNING - void declaration
     */
    public void setEnabledAll(boolean enabled) {
        void var1_1;
        MTLogCache mTLogCache = this;
        mTLogCache.isEnabledAll = var1_1;
        mTLogCache.isSetEnabledAll = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setReuseActiveFile(boolean reuseActiveFile) {
        void var1_1;
        MTLogCache mTLogCache = this;
        mTLogCache.isReuseActiveFile = var1_1;
        mTLogCache.isSetReuseActiveFile = true;
        Log.i((String)TAG, (String)("Reuse active file setting changed to: " + (boolean)var1_1));
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxTotalSize(long maxTotalSize) {
        if (maxTotalSize >= 1L) {
            void var1_1;
            this.maxTotalSize = var1_1 * 1024L * 1024L;
        }
    }

    public long getMaxTotalSize() {
        return this.maxTotalSize;
    }

    public void switchToNewLogFile() {
        if (!this.isOK()) {
            return;
        }
        this.getWriteExecutor().submit(new Runnable(){

            @Override
            public void run() {
                b b2 = this;
                b2.MTLogCache.this.initLogFile();
                b2.MTLogCache.this.switchToNewLogFileSync();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void debug(String tag, String message) {
        if (this.isEnabledAll) {
            void var2_2;
            void var1_1;
            this.writeLog("D", (String)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void d(String tag, String message) {
        void var2_2;
        void var1_1;
        this.writeLog("D", (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void i(String tag, String message) {
        void var2_2;
        void var1_1;
        this.writeLog("I", (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void w(String tag, String message) {
        void var2_2;
        void var1_1;
        this.writeLog("W", (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void e(String tag, String message) {
        void var2_2;
        void var1_1;
        this.writeLog("E", (String)var1_1, (String)var2_2);
    }

    public List<File> getAllClosedLogFiles() {
        ArrayList<File> arrayList;
        ArrayList<File> arrayList2 = arrayList;
        arrayList = new ArrayList<File>();
        for (File file : this.getAllLogFiles()) {
            if (!this.isClosedLogFile(file)) continue;
            arrayList2.add(file);
        }
        return arrayList2;
    }
}

