/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secure.android.common.webview;

import android.os.Build;
import android.webkit.WebSettings;
import android.webkit.WebView;

public class SafeWebSettings {
    public static void initWebviewAndSettings(WebView webView) {
        WebSettings webSettings = webView.getSettings();
        SafeWebSettings.disableFileCrossAccess(webSettings);
        SafeWebSettings.removeUnSafeJavascriptImpl(webView);
        SafeWebSettings.disablePasswordStorage(webSettings);
        SafeWebSettings.disableGeolocation(webSettings);
        SafeWebSettings.disableMixedContentMode(webSettings);
        SafeWebSettings.disableContentAccess(webSettings);
    }

    public static void disableFileCrossAccess(WebSettings webSettings) {
        webSettings.setAllowFileAccess(false);
        if (Build.VERSION.SDK_INT >= 16) {
            WebSettings webSettings2 = webSettings;
            webSettings2.setAllowFileAccessFromFileURLs(false);
            webSettings2.setAllowUniversalAccessFromFileURLs(false);
        }
    }

    public static void removeUnSafeJavascriptImpl(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            WebView webView2 = webView;
            webView2.removeJavascriptInterface("searchBoxJavaBridge_");
            webView2.removeJavascriptInterface("accessibility");
            webView2.removeJavascriptInterface("accessibilityTraversal");
        }
    }

    public static void disablePasswordStorage(WebSettings webSettings) {
        if (Build.VERSION.SDK_INT <= 18) {
            webSettings.setSavePassword(false);
        }
    }

    public static void disableGeolocation(WebSettings webSettings) {
        webSettings.setGeolocationEnabled(false);
    }

    public static void disableMixedContentMode(WebSettings webSettings) {
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(1);
        }
    }

    public static void disableContentAccess(WebSettings webSettings) {
        if (Build.VERSION.SDK_INT >= 11) {
            webSettings.setAllowContentAccess(false);
        }
    }
}

