/*
 * Decompiled with CFR 0.152.
 */
package cn.engagelab.uniplugin_mtpush;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import cn.engagelab.uniplugin_mtpush.common.MTLogger;
import cn.engagelab.uniplugin_mtpush.helper.MTPushHelper;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.engagelab.privates.common.global.MTGlobal;
import com.engagelab.privates.core.api.MTCorePrivatesApi;
import com.engagelab.privates.push.api.MTPushPrivatesApi;
import com.engagelab.privates.push.api.NotificationMessage;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.taobao.weex.bridge.JSCallback;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.common.UniDestroyableModule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class MTPushModule
extends UniDestroyableModule {
    public static boolean isAppForeground = false;
    public static Context uniContext = null;

    public void updatePluginStatu() {
        uniContext = this.mWXSDKInstance.getContext();
        MTPushHelper.IS_DESTROY = false;
    }

    @UniJSMethod(uiThread=true)
    public void setCountryCode(String countryCode) {
        this.updatePluginStatu();
        Context context = uniContext;
        if (context == null) {
            MTLogger.e("configGoogle context can't be null, please check it");
            return;
        }
        if (!MTGlobal.isMainProcess((Context)context.getApplicationContext()) && !MTGlobal.isRemoteProcess((Context)context.getApplicationContext())) {
            return;
        }
        MTGlobal.setCountryCode((String)countryCode);
    }

    @UniJSMethod(uiThread=true)
    public void setLoggerEnable(boolean enable) {
        this.updatePluginStatu();
        MTCorePrivatesApi.configDebugMode((Context)this.mWXSDKInstance.getContext(), (boolean)enable);
        MTLogger.setLoggerEnable(enable);
    }

    @UniJSMethod(uiThread=true)
    public void setTcpSSl(boolean enable) {
        MTLogger.w("setTcpSSl-----");
        this.updatePluginStatu();
        MTCorePrivatesApi.setTcpSSl((boolean)enable);
    }

    @UniJSMethod(uiThread=true)
    public void setEnableResetOnDeviceChange(boolean enable) {
        MTLogger.w("setEnableResetOnDeviceChange-----");
        this.updatePluginStatu();
        MTCorePrivatesApi.setEnableResetOnDeviceChange((Context)this.mWXSDKInstance.getContext(), (boolean)enable);
    }

    @UniJSMethod(uiThread=true)
    public void openSettingsForNotification(JSCallback callback) {
        this.updatePluginStatu();
        MTPushPrivatesApi.goToAppNotificationSettings((Context)this.mWXSDKInstance.getContext());
        if (callback == null) {
            MTLogger.w("callback cant be null");
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)0);
        callback.invoke((Object)jsonObject);
    }

    @UniJSMethod(uiThread=true)
    public void setSiteName(String siteName) {
        MTLogger.w("setSiteName-----");
        this.updatePluginStatu();
        MTCorePrivatesApi.configAppSiteName((Context)this.mWXSDKInstance.getContext(), (String)siteName);
    }

    @UniJSMethod(uiThread=true)
    public void initPushService() {
        MTLogger.w("initPushService-----");
        this.updatePluginStatu();
        MTPushPrivatesApi.init((Context)this.mWXSDKInstance.getContext());
        this.initFcm();
    }

    void initFcm() {
        try {
            Context context = this.mWXSDKInstance.getContext();
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            String google_api_key = appInfo.metaData.getString("google_api_key").substring(2);
            String google_app_id = appInfo.metaData.getString("google_app_id").substring(2);
            String gcm_defaultSenderId = appInfo.metaData.getString("gcm_defaultSenderId").substring(2);
            String project_id = appInfo.metaData.getString("project_id").substring(2);
            String google_storage_bucket = appInfo.metaData.getString("google_storage_bucket").substring(2);
            FirebaseOptions fireBaseOptions = new FirebaseOptions.Builder().setApiKey(google_api_key).setApplicationId(google_app_id).setGcmSenderId(gcm_defaultSenderId).setProjectId(project_id).setStorageBucket(google_storage_bucket).build();
            FirebaseApp.initializeApp((Context)context, (FirebaseOptions)fireBaseOptions);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @UniJSMethod(uiThread=true)
    public void stopPush() {
        this.updatePluginStatu();
        MTPushPrivatesApi.turnOffPush((Context)this.mWXSDKInstance.getContext());
    }

    @UniJSMethod(uiThread=true)
    public void resumePush() {
        this.updatePluginStatu();
        MTPushPrivatesApi.turnOnPush((Context)this.mWXSDKInstance.getContext());
    }

    @UniJSMethod(uiThread=true)
    public void setChannelAndSound(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        String channel = readableMap.getString("channel");
        String channelId = readableMap.getString("channel_id");
        String sound = readableMap.getString("sound");
        try {
            NotificationManager manager = (NotificationManager)uniContext.getSystemService("notification");
            if (Build.VERSION.SDK_INT < 26) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)channel) || TextUtils.isEmpty((CharSequence)channelId)) {
                MTLogger.w("params illegal,channel and channel id must config");
                return;
            }
            NotificationChannel channel1 = new NotificationChannel(channelId, (CharSequence)channel, 4);
            if (!TextUtils.isEmpty((CharSequence)sound)) {
                channel1.setSound(Uri.parse((String)("android.resource://" + uniContext.getPackageName() + "/raw/" + sound)), null);
            }
            manager.createNotificationChannel(channel1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @UniJSMethod(uiThread=true)
    public void setPushTime(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        JSONArray readableArray = readableMap.getJSONArray("pushTimeDays");
        int startHour = readableMap.getIntValue("pushTimeStartHour");
        int endHour = readableMap.getIntValue("pushTimeEndHour");
        if (readableArray == null || startHour < 0 || startHour > 23 || endHour < 0 || endHour > 23) {
            MTLogger.w("params cant be null");
            return;
        }
        HashSet<Integer> days = new HashSet<Integer>();
        for (int i = 0; i < readableArray.size(); ++i) {
            int day = readableArray.getIntValue(i);
            if (day > 6 || day < 0) {
                MTLogger.w("params cant be null");
                return;
            }
            days.add(day);
        }
        Context var10000 = this.mWXSDKInstance.getContext();
        int context1 = days.size();
        int[] var4 = new int[context1];
        Integer[] var10001 = new Integer[days.size()];
        days.toArray(var10001);
        System.arraycopy(var10001, 0, var4, 0, context1);
        MTPushPrivatesApi.setNotificationShowTime((Context)var10000.getApplicationContext(), (int)startHour, (int)endHour, (int[])var4);
    }

    @UniJSMethod(uiThread=true)
    public void setSilenceTime(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        int startHour = readableMap.getIntValue("silenceTimeStartHour");
        int startMinute = readableMap.getIntValue("silenceTimeStartMinute");
        int endHour = readableMap.getIntValue("silenceTimeEndHour");
        int endMinute = readableMap.getIntValue("silenceTimeEndMinute");
        if (startHour == 0 || startMinute == 0 || endHour == 0 || endMinute == 0) {
            MTLogger.w("params cant be null");
            return;
        }
        MTPushPrivatesApi.setNotificationSilenceTime((Context)this.mWXSDKInstance.getContext(), (int)startHour, (int)startMinute, (int)endHour, (int)endMinute);
    }

    @UniJSMethod(uiThread=true)
    public void clearAllNotifications() {
        this.updatePluginStatu();
        MTPushPrivatesApi.clearNotification((Context)this.mWXSDKInstance.getContext());
    }

    @UniJSMethod(uiThread=true)
    public void clearNotificationById(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        if (readableMap.containsKey((Object)"notificationId")) {
            Integer id = readableMap.getIntValue("notificationId");
            MTPushPrivatesApi.clearNotification((Context)this.mWXSDKInstance.getContext(), (int)id);
        } else {
            MTLogger.w("there are no geoFenceID");
        }
    }

    @UniJSMethod(uiThread=true)
    public void getRegistrationID(JSCallback callback) {
        this.updatePluginStatu();
        if (callback == null) {
            MTLogger.w("callback cant be null");
            return;
        }
        String registrationID = MTCorePrivatesApi.getRegistrationId((Context)this.mWXSDKInstance.getContext());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("registerID", (Object)registrationID);
        jsonObject.put("code", (Object)0);
        callback.invoke((Object)jsonObject);
    }

    @UniJSMethod(uiThread=true)
    public void addConnectEventListener(JSCallback callback) {
        this.updatePluginStatu();
        if (callback != null) {
            MTLogger.w("addConnectEventListener");
            MTPushHelper.eventCallback.put("ConnectEvent", callback);
        }
    }

    @UniJSMethod(uiThread=true)
    public void addNotificationListener(JSCallback callback) {
        this.updatePluginStatu();
        if (callback != null) {
            MTLogger.w("addNotificationListener");
            MTPushHelper.eventCallback.put("NotificationEvent", callback);
            MTPushHelper.sendCacheOpenNotifiToUser(0);
        }
    }

    @UniJSMethod(uiThread=true)
    public void addCustomMessageListener(JSCallback callback) {
        this.updatePluginStatu();
        if (callback != null) {
            MTLogger.w("addCustomMessageListener");
            MTPushHelper.eventCallback.put("CustomMessageEvent", callback);
        }
    }

    @UniJSMethod(uiThread=true)
    public void addInMessageListener(JSCallback callback) {
        this.updatePluginStatu();
        if (callback != null) {
            MTLogger.w("addInMessageListener");
            MTPushHelper.eventCallback.put("InappMessageEvent", callback);
        }
    }

    @UniJSMethod(uiThread=true)
    public void setBadge(int number) {
        this.updatePluginStatu();
        MTPushPrivatesApi.setNotificationBadge((Context)this.mWXSDKInstance.getContext(), (int)number);
    }

    @UniJSMethod(uiThread=true)
    public void addMobileNumberListener(JSCallback callback) {
        this.updatePluginStatu();
        if (callback != null) {
            MTLogger.w("addMobileNumberListener");
            MTPushHelper.eventCallback.put("MobileNumberEvent", callback);
        }
    }

    @UniJSMethod(uiThread=true)
    public void setMobileNumber(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getIntValue("sequence");
        String mobileNumber = readableMap.getString("mobileNumber");
        MTPushPrivatesApi.uploadMobileNumber((Context)this.mWXSDKInstance.getContext(), (int)sequence, (String)mobileNumber);
    }

    @UniJSMethod(uiThread=true)
    public void addTagAliasListener(JSCallback callback) {
        this.updatePluginStatu();
        if (callback != null) {
            MTLogger.w("addTagAliasListener");
            MTPushHelper.eventCallback.put("TagAliasEvent", callback);
        }
    }

    @UniJSMethod(uiThread=true)
    public void addTags(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        if (readableMap.containsKey((Object)"tags")) {
            JSONArray tags = readableMap.getJSONArray("tags");
            int sequence = readableMap.getIntValue("sequence");
            HashSet<String> tagSet = new HashSet<String>();
            for (int i = 0; i < tags.size(); ++i) {
                String tag = tags.getString(i);
                tagSet.add(tag);
            }
            String[] arr = tagSet.toArray(new String[0]);
            MTPushPrivatesApi.addTag((Context)this.mWXSDKInstance.getContext(), (int)sequence, (String[])arr);
        } else {
            MTLogger.w("there are no tags");
        }
    }

    @UniJSMethod(uiThread=true)
    public void updateTags(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        if (readableMap.containsKey((Object)"tags")) {
            JSONArray tags = readableMap.getJSONArray("tags");
            int sequence = readableMap.getIntValue("sequence");
            HashSet<String> tagSet = new HashSet<String>();
            for (int i = 0; i < tags.size(); ++i) {
                String tag = tags.getString(i);
                tagSet.add(tag);
            }
            String[] arr = tagSet.toArray(new String[0]);
            MTPushPrivatesApi.updateTag((Context)this.mWXSDKInstance.getContext(), (int)sequence, (String[])arr);
        } else {
            MTLogger.w("there are no tags");
        }
    }

    @UniJSMethod(uiThread=true)
    public void deleteTags(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        if (readableMap.containsKey((Object)"tags")) {
            JSONArray tags = readableMap.getJSONArray("tags");
            int sequence = readableMap.getIntValue("sequence");
            HashSet<String> tagSet = new HashSet<String>();
            for (int i = 0; i < tags.size(); ++i) {
                String tag = tags.getString(i);
                tagSet.add(tag);
            }
            String[] arr = tagSet.toArray(new String[0]);
            MTPushPrivatesApi.deleteTag((Context)this.mWXSDKInstance.getContext(), (int)sequence, (String[])arr);
        } else {
            MTLogger.w("there are no tags");
        }
    }

    @UniJSMethod(uiThread=true)
    public void cleanTags(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getIntValue("sequence");
        MTPushPrivatesApi.deleteAllTag((Context)this.mWXSDKInstance.getContext(), (int)sequence);
    }

    @UniJSMethod(uiThread=true)
    public void queryTag(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getIntValue("sequence");
        String tag = readableMap.getString("tag");
        MTPushPrivatesApi.queryTag((Context)this.mWXSDKInstance.getContext(), (int)sequence, (String)tag);
    }

    @UniJSMethod(uiThread=true)
    public void getAllTags(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getIntValue("sequence");
        MTPushPrivatesApi.queryAllTag((Context)this.mWXSDKInstance.getContext(), (int)sequence);
    }

    @UniJSMethod(uiThread=true)
    public void setAlias(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getIntValue("sequence");
        String alias = readableMap.getString("alias");
        MTPushPrivatesApi.setAlias((Context)this.mWXSDKInstance.getContext(), (int)sequence, (String)alias);
    }

    @UniJSMethod(uiThread=true)
    public void deleteAlias(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getIntValue("sequence");
        MTPushPrivatesApi.clearAlias((Context)this.mWXSDKInstance.getContext(), (int)sequence);
    }

    @UniJSMethod(uiThread=true)
    public void queryAlias(JSONObject readableMap) {
        this.updatePluginStatu();
        if (readableMap == null) {
            MTLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getIntValue("sequence");
        MTPushPrivatesApi.getAlias((Context)this.mWXSDKInstance.getContext(), (int)sequence);
    }

    @UniJSMethod(uiThread=true)
    public void addLocalNotification(JSONObject readableMap) {
        try {
            int notiId = readableMap.getIntValue("messageID");
            String title = readableMap.getString("title");
            String content = readableMap.getString("content");
            String category = readableMap.getString("category");
            int priority = readableMap.getIntValue("priority");
            JSONObject extras = readableMap.getJSONObject("extras");
            Context context = this.mWXSDKInstance.getContext();
            Bundle bundle = this.jsonObjectToBundle(extras);
            NotificationMessage notificationMessage = new NotificationMessage().setNotificationId(notiId).setTitle(title).setContent(content).setCategory(category).setExtras(bundle).setPriority(priority);
            MTPushPrivatesApi.showNotification((Context)context, (NotificationMessage)notificationMessage);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    Bundle jsonObjectToBundle(JSONObject jsonObject) {
        Bundle bundle = new Bundle();
        if (jsonObject != null) {
            Set keySet = jsonObject.keySet();
            for (String key : keySet) {
                Object value = jsonObject.get((Object)key);
                if (value instanceof String) {
                    bundle.putString(key, (String)value);
                    continue;
                }
                if (value instanceof Integer) {
                    bundle.putInt(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    bundle.putBoolean(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Long) {
                    bundle.putLong(key, ((Long)value).longValue());
                    continue;
                }
                if (!(value instanceof Double)) continue;
                bundle.putDouble(key, ((Double)value).doubleValue());
            }
        }
        return bundle;
    }

    public void destroy() {
        MTLogger.e("destroy");
        MTPushHelper.IS_DESTROY = true;
        MTPushHelper.eventCallback = new HashMap();
    }
}

