/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class NotificationStyle
implements Parcelable {
    public static final String TAG = "notification_style";
    public static final String NOTIFICATION_STYLE = "ns";
    public static final String BASE_STYLE = "bs";
    public static final String INNER_STYLE = "is";
    public static final String EXPANDABLE_TEXT = "et";
    public static final String EXPANDABLE_IMAGE_URL = "ei";
    public static final String BANNER_IMAGE_URL = "bi";
    public static final Parcelable.Creator<NotificationStyle> CREATOR = new Parcelable.Creator<NotificationStyle>(){

        public NotificationStyle a(Parcel parcel) {
            return new NotificationStyle(parcel);
        }

        public NotificationStyle[] a(int n2) {
            return new NotificationStyle[n2];
        }
    };
    private int baseStyle = 0;
    private int innerStyle = 0;
    private String expandableText;
    private String expandableImageUrl;
    private String bannerImageUrl;

    public NotificationStyle(Parcel parcel) {
        this.baseStyle = parcel.readInt();
        this.innerStyle = parcel.readInt();
        this.expandableText = parcel.readString();
        this.expandableImageUrl = parcel.readString();
        this.bannerImageUrl = parcel.readString();
    }

    public NotificationStyle() {
    }

    public static NotificationStyle parse(String string) {
        JSONObject jSONObject;
        block4: {
            JSONObject jSONObject2 = null;
            if (!TextUtils.isEmpty((CharSequence)string)) {
                JSONObject jSONObject3;
                jSONObject = jSONObject3;
                try {
                    jSONObject3 = new JSONObject(string);
                    break block4;
                }
                catch (JSONException jSONException) {
                    DebugLogger.e(TAG, "parse json string error " + jSONException.getMessage());
                }
            }
            jSONObject = jSONObject2;
        }
        return NotificationStyle.parse(jSONObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NotificationStyle parse(JSONObject jSONObject) {
        NotificationStyle notificationStyle;
        NotificationStyle notificationStyle2 = notificationStyle;
        notificationStyle = new NotificationStyle();
        if (jSONObject == null) {
            DebugLogger.e(TAG, "no such tag notification_style");
            return notificationStyle2;
        }
        try {
            if (!jSONObject.isNull(BASE_STYLE)) {
                notificationStyle2.setBaseStyle(jSONObject.getInt(BASE_STYLE));
            }
            if (!jSONObject.isNull(INNER_STYLE)) {
                notificationStyle2.setInnerStyle(jSONObject.getInt(INNER_STYLE));
            }
            if (!jSONObject.isNull(EXPANDABLE_TEXT)) {
                notificationStyle2.setExpandableText(jSONObject.getString(EXPANDABLE_TEXT));
            }
            if (!jSONObject.isNull(EXPANDABLE_IMAGE_URL)) {
                notificationStyle2.setExpandableImageUrl(jSONObject.getString(EXPANDABLE_IMAGE_URL));
            }
            if (jSONObject.isNull(BANNER_IMAGE_URL)) return notificationStyle2;
            notificationStyle2.setBannerImageUrl(jSONObject.getString(BANNER_IMAGE_URL));
            return notificationStyle2;
        }
        catch (JSONException jSONException) {
            DebugLogger.e(TAG, "parse json obj error " + jSONException.getMessage());
            return notificationStyle2;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.baseStyle);
        parcel.writeInt(this.innerStyle);
        parcel.writeString(this.expandableText);
        parcel.writeString(this.expandableImageUrl);
        parcel.writeString(this.bannerImageUrl);
    }

    public int getBaseStyle() {
        return this.baseStyle;
    }

    public void setBaseStyle(int n2) {
        this.baseStyle = n2;
    }

    public int getInnerStyle() {
        return this.innerStyle;
    }

    public void setInnerStyle(int n2) {
        this.innerStyle = n2;
    }

    public String getExpandableText() {
        return this.expandableText;
    }

    public void setExpandableText(String string) {
        this.expandableText = string;
    }

    public String getExpandableImageUrl() {
        return this.expandableImageUrl;
    }

    public void setExpandableImageUrl(String string) {
        this.expandableImageUrl = string;
    }

    public String getBannerImageUrl() {
        return this.bannerImageUrl;
    }

    public void setBannerImageUrl(String string) {
        this.bannerImageUrl = string;
    }

    public String toString() {
        return "NotificationStyle{baseStyle=" + this.baseStyle + ", innerStyle=" + this.innerStyle + ", expandableText='" + this.expandableText + '\'' + ", expandableImageUrl='" + this.expandableImageUrl + '\'' + ", bannerImageUrl='" + this.bannerImageUrl + '\'' + '}';
    }
}

