/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.api;

import android.os.RemoteException;
import android.text.TextUtils;
import com.huawei.hms.core.aidl.CodecLookup;
import com.huawei.hms.core.aidl.DataBuffer;
import com.huawei.hms.core.aidl.IAIDLCallback;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.core.aidl.MessageCodec;
import com.huawei.hms.core.aidl.ResponseHeader;
import com.huawei.hms.support.api.transport.DatagramTransport;
import com.huawei.hms.support.log.HMSLog;

public class IPCCallback
extends IAIDLCallback.Stub {
    private static final String TAG = "IPCCallback";
    private final Class<? extends IMessageEntity> mResponseClass;
    private final DatagramTransport.a mCallback;

    public IPCCallback(Class<? extends IMessageEntity> clazz, DatagramTransport.a a2) {
        this.mResponseClass = clazz;
        this.mCallback = a2;
    }

    @Override
    public void call(DataBuffer dataBuffer) throws RemoteException {
        if (dataBuffer != null && !TextUtils.isEmpty((CharSequence)dataBuffer.URI)) {
            DataBuffer dataBuffer2 = dataBuffer;
            MessageCodec messageCodec = CodecLookup.find(dataBuffer2.getProtocol());
            IMessageEntity iMessageEntity = null;
            if (dataBuffer2.getBodySize() > 0 && (iMessageEntity = ((IPCCallback)((Object)responseHeader2)).newResponseInstance()) != null) {
                messageCodec.decode(dataBuffer.getBody(), iMessageEntity);
            }
            if (dataBuffer.header != null) {
                ResponseHeader responseHeader;
                IPCCallback iPCCallback = responseHeader2;
                ResponseHeader responseHeader2 = responseHeader;
                responseHeader = new ResponseHeader();
                messageCodec.decode(dataBuffer.header, responseHeader2);
                iPCCallback.mCallback.a(responseHeader2.getStatusCode(), iMessageEntity);
            } else {
                ((IPCCallback)((Object)responseHeader2)).mCallback.a(0, iMessageEntity);
            }
            return;
        }
        HMSLog.e((String)TAG, (String)"In call, URI cannot be empty.");
        throw new RemoteException();
    }

    /*
     * WARNING - void declaration
     */
    protected IMessageEntity newResponseInstance() {
        Class<? extends IMessageEntity> clazz = ((IPCCallback)((Object)clazz)).mResponseClass;
        if (clazz != null) {
            void var0_3;
            try {
                return (IMessageEntity)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            HMSLog.e((String)TAG, (String)("In newResponseInstance, instancing exception." + var0_3.getMessage()));
        }
        return null;
    }
}

