/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.webserverpic;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.hms.common.internal.Preconditions;
import com.huawei.hms.common.internal.safeparcel.SafeParcelWriter;
import com.huawei.hms.common.webserverpic.WebServerPicCreator;
import java.util.Locale;

public class WebServerPic {
    public static final Parcelable.Creator<WebServerPic> CREATOR = new WebServerPicCreator();
    private final Uri url;
    private final int width;
    private final int height;

    public WebServerPic(Uri uri, int n, int n2) throws IllegalArgumentException {
        this.url = uri;
        this.width = n;
        this.height = n2;
        if (uri != null) {
            if (n >= 0 && n2 >= 0) {
                return;
            }
            throw new IllegalArgumentException("width and height should be positive or 0");
        }
        throw new IllegalArgumentException("url is not able to be null");
    }

    public WebServerPic(Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    public final Uri getUrl() {
        return this.url;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final String toString() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.width;
        objectArray2[1] = this.height;
        objectArray[2] = this.url.toString();
        return String.format(Locale.ENGLISH, "Image %dx%d %s", objectArray2);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Preconditions.checkNotNull((Object)parcel2);
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeParcelable(parcel, 1, (Parcelable)this.getUrl(), n, false);
        SafeParcelWriter.writeInt(parcel, 2, this.getWidth());
        SafeParcelWriter.writeInt(parcel, 3, this.getHeight());
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }
}

