/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common.check;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import com.huawei.hms.framework.common.ContextHolder;
import com.huawei.hms.framework.common.Logger;

public class ProviderCheckUtil {
    private static String TAG = "ProviderCheckUtil";

    public static boolean isValid(Uri uri) {
        boolean result = false;
        if (uri != null) {
            PackageManager packageManager = ContextHolder.getAppContext().getPackageManager();
            ProviderInfo providerInfo = packageManager.resolveContentProvider(uri.getAuthority(), 0);
            if (providerInfo != null) {
                ApplicationInfo applicationInfo = providerInfo.applicationInfo;
                if (applicationInfo != null) {
                    String packageName = applicationInfo.packageName;
                    Logger.v(TAG, "Target provider service's package name is : " + packageName);
                    if (packageName != null && packageManager.checkSignatures("com.huawei.hwid", packageName) == 0) {
                        result = true;
                    }
                }
            } else {
                Logger.w(TAG, "Invalid param");
            }
        }
        return result;
    }
}

