/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.text.TextUtils;
import com.huawei.hms.framework.common.Logger;
import java.lang.reflect.Method;

public class SystemPropUtils {
    private static final String TAG = SystemPropUtils.class.getSimpleName();

    public static String getProperty(String method, String key, String className, String defaultVal) {
        if (TextUtils.isEmpty((CharSequence)method) || TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)className)) {
            Logger.w(TAG, "reflect class for method has exception.");
            return defaultVal;
        }
        String value = defaultVal;
        try {
            Class<?> c = Class.forName(className);
            Method getMethod = c.getMethod(method, String.class, String.class);
            value = (String)getMethod.invoke(c, key, defaultVal);
        }
        catch (Exception e) {
            Logger.e(TAG, "getProperty catch exception: ", e);
            return value;
        }
        return value;
    }
}

