/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.proto;

import androidx.annotation.NonNull;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ValueEncoder;
import com.google.firebase.encoders.config.Configurator;
import com.google.firebase.encoders.config.EncoderConfig;
import com.google.firebase.encoders.proto.ProtobufDataEncoderContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class ProtobufEncoder {
    private final Map<Class<?>, ObjectEncoder<?>> objectEncoders;
    private final Map<Class<?>, ValueEncoder<?>> valueEncoders;
    private final ObjectEncoder<Object> fallbackEncoder;

    ProtobufEncoder(Map<Class<?>, ObjectEncoder<?>> objectEncoders, Map<Class<?>, ValueEncoder<?>> valueEncoders, ObjectEncoder<Object> fallbackEncoder) {
        this.objectEncoders = objectEncoders;
        this.valueEncoders = valueEncoders;
        this.fallbackEncoder = fallbackEncoder;
    }

    public void encode(@NonNull Object value, @NonNull OutputStream outputStream) throws IOException {
        ProtobufDataEncoderContext context = new ProtobufDataEncoderContext(outputStream, this.objectEncoders, this.valueEncoders, this.fallbackEncoder);
        context.encode(value);
    }

    @NonNull
    public byte[] encode(@NonNull Object value) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.encode(value, output);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return output.toByteArray();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements EncoderConfig<Builder> {
        private static final ObjectEncoder<Object> DEFAULT_FALLBACK_ENCODER = (o, ctx) -> {
            throw new EncodingException("Couldn't find encoder for type " + o.getClass().getCanonicalName());
        };
        private final Map<Class<?>, ObjectEncoder<?>> objectEncoders = new HashMap();
        private final Map<Class<?>, ValueEncoder<?>> valueEncoders = new HashMap();
        private ObjectEncoder<Object> fallbackEncoder = DEFAULT_FALLBACK_ENCODER;

        @NonNull
        public <U> Builder registerEncoder(@NonNull Class<U> type, @NonNull ObjectEncoder<? super U> encoder) {
            this.objectEncoders.put(type, encoder);
            this.valueEncoders.remove(type);
            return this;
        }

        @NonNull
        public <U> Builder registerEncoder(@NonNull Class<U> type, @NonNull ValueEncoder<? super U> encoder) {
            this.valueEncoders.put(type, encoder);
            this.objectEncoders.remove(type);
            return this;
        }

        @NonNull
        public Builder registerFallbackEncoder(@NonNull ObjectEncoder<Object> fallbackEncoder) {
            this.fallbackEncoder = fallbackEncoder;
            return this;
        }

        @NonNull
        public Builder configureWith(@NonNull Configurator config) {
            config.configure((EncoderConfig)this);
            return this;
        }

        public ProtobufEncoder build() {
            return new ProtobufEncoder(new HashMap(this.objectEncoders), new HashMap(this.valueEncoders), this.fallbackEncoder);
        }
    }
}

