/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.proto;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.FieldDescriptor;
import com.google.firebase.encoders.ValueEncoderContext;
import com.google.firebase.encoders.proto.ProtobufDataEncoderContext;
import java.io.IOException;

class ProtobufValueEncoderContext
implements ValueEncoderContext {
    private boolean encoded = false;
    private boolean skipDefault = false;
    private FieldDescriptor field;
    private final ProtobufDataEncoderContext objEncoderCtx;

    ProtobufValueEncoderContext(ProtobufDataEncoderContext objEncoderCtx) {
        this.objEncoderCtx = objEncoderCtx;
    }

    void resetContext(FieldDescriptor field, boolean skipDefault) {
        this.encoded = false;
        this.field = field;
        this.skipDefault = skipDefault;
    }

    private void checkNotUsed() {
        if (this.encoded) {
            throw new EncodingException("Cannot encode a second value in the ValueEncoderContext");
        }
        this.encoded = true;
    }

    @NonNull
    public ValueEncoderContext add(@Nullable String value) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, value, this.skipDefault);
        return this;
    }

    @NonNull
    public ValueEncoderContext add(float value) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, value, this.skipDefault);
        return this;
    }

    @NonNull
    public ValueEncoderContext add(double value) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, value, this.skipDefault);
        return this;
    }

    @NonNull
    public ValueEncoderContext add(int value) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, value, this.skipDefault);
        return this;
    }

    @NonNull
    public ValueEncoderContext add(long value) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, value, this.skipDefault);
        return this;
    }

    @NonNull
    public ValueEncoderContext add(boolean value) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, value, this.skipDefault);
        return this;
    }

    @NonNull
    public ValueEncoderContext add(@NonNull byte[] bytes) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, bytes, this.skipDefault);
        return this;
    }
}

