/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.platform.google.callback;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.engagelab.privates.common.api.MTCommonPrivatesApi;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.common.utils.SM4Util;
import com.engagelab.privates.push.api.CustomMessage;
import com.engagelab.privates.push.api.MTPushPrivatesApi;
import com.engagelab.privates.push.api.NotificationMessage;
import com.engagelab.privates.push.platform.google.business.MTGoogleBusiness;
import com.engagelab.privates.push.utils.NotificationUtil;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Map;
import org.json.JSONObject;

public class MTGoogleCallbackImp
extends FirebaseMessagingService {
    private static final String TAG = "MTGoogleCallbackImp";
    private Context mContext;

    public MTGoogleCallbackImp(Service service) {
        this.mContext = service.getApplicationContext();
    }

    public void onNewToken(String token) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            MTCommonLog.d((String)TAG, (String)"onTokenFailed:get token is empty");
            MTGoogleBusiness.getInstance().onNode(this.mContext, 3004, 0, 3900, 2);
            return;
        }
        MTCommonLog.d((String)TAG, (String)("onTokenSuccess:callback token is " + token));
        MTGoogleBusiness.getInstance().onToken(this.mContext, token, 2);
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        try {
            String intentUri;
            String platformMessageId = remoteMessage.getMessageId();
            Map data = remoteMessage.getData();
            Bundle messageBundle = new Bundle();
            for (Map.Entry entry : data.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                messageBundle.putString(key, value);
            }
            String message = null;
            message = data.containsKey("JMessageExtra") ? (String)data.get("JMessageExtra") : (String)data.get("MTMessageExtra");
            if (message == null) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)(message = SM4Util.decodeMessage((String)message)))) {
                return;
            }
            MTPushPrivatesApi.init((Context)this.mContext);
            JSONObject messageJson = new JSONObject(message);
            MTCommonLog.d((String)TAG, (String)("onMessage:" + MTCommonLog.toLogString((JSONObject)messageJson)));
            String messageId = NotificationUtil.getMessageId((JSONObject)messageJson);
            RemoteMessage.Notification notification = remoteMessage.getNotification();
            if (notification == null) {
                MTCommonLog.d((String)TAG, (String)"is data");
                String customTitle = messageJson.optString("title");
                String customContent = messageJson.optString("message");
                String customContentType = messageJson.optString("content_type");
                Bundle extras = NotificationUtil.convertJsonToBundle((JSONObject)messageJson.optJSONObject("extras"));
                CustomMessage customMessage = new CustomMessage().setMessageId(messageId).setPlatform((byte)8).setPlatformMessageId(platformMessageId).setTitle(customTitle).setContent(customContent).setContentType(customContentType).setExtras(extras);
                Bundle bundle = new Bundle();
                bundle.putParcelable("message", (Parcelable)customMessage);
                MTCommonPrivatesApi.sendMessageToMainProcess((Context)this.mContext, (int)3001, (Bundle)bundle);
                return;
            }
            MTCommonLog.d((String)TAG, (String)"is notification");
            int notificationId = NotificationUtil.getNotificationId((String)messageId);
            String title = notification.getTitle();
            String content = notification.getBody();
            Bundle extras = NotificationUtil.convertJsonToBundle((JSONObject)messageJson.optJSONObject("n_extras"));
            int defaults = messageJson.optInt("n_alert_type");
            int priority = NotificationUtil.getPriority((JSONObject)messageJson);
            int importance = NotificationUtil.getNotificationImportance((JSONObject)messageJson);
            String sound = messageJson.optString("n_sound");
            String category = messageJson.optString("n_category");
            String channelId = messageJson.optString("n_channel_id");
            String groupId = messageJson.optString("n_group_id");
            String displayForeground = messageJson.optString("n_display_foreground");
            String smallIcon = messageJson.optString("n_small_icon");
            String color = messageJson.optString("n_color");
            String largeIcon = messageJson.optString("n_large_icon");
            String bigText = messageJson.optString("n_big_text");
            String bigPicture = messageJson.optString("n_big_pic_path");
            String[] inbox = NotificationUtil.convertJsonToArray((String)messageJson.optString("n_inbox"));
            int style = messageJson.optInt("n_style");
            String intentSsl = null;
            if (MTPushPrivatesApi.SDK_VERSION_NAME.startsWith("3")) {
                String action = notification.getClickAction();
                if (!TextUtils.isEmpty((CharSequence)action)) {
                    Intent intent = new Intent();
                    intent.setAction(action);
                    intent.putExtras(messageBundle);
                    intent.setPackage(this.mContext.getPackageName());
                    intentUri = intent.toURI();
                } else {
                    intentUri = "";
                }
            } else {
                intentUri = messageJson.optString("n_intent_uri");
                intentSsl = messageJson.optString("n_intent_ssl");
            }
            NotificationMessage notificationMessage = new NotificationMessage().setMessageId(messageId).setPlatform((byte)8).setPlatformMessageId(platformMessageId).setDisplayForeground(displayForeground).setNotificationId(notificationId).setSmallIcon(smallIcon).setLargeIcon(largeIcon).setStyle(style).setBigText(bigText).setInbox(inbox).setBigPicture(bigPicture).setTitle(title).setContent(content).setColor(color).setExtras(extras).setDefaults(defaults).setPriority(priority).setImportance(importance).setCategory(category).setSound(sound).setChannelId(channelId).setGroupId(groupId).setIntentUri(intentUri).setIntentSsl(intentSsl);
            Bundle bundle = new Bundle();
            bundle.putParcelable("message", (Parcelable)notificationMessage);
            bundle.putBoolean("message_limit", true);
            MTCommonPrivatesApi.sendMessageToRemoteProcess((Context)this.mContext, (int)3895, (Bundle)bundle);
            MTCommonPrivatesApi.sendMessageToMainProcess((Context)this.mContext, (int)3002, (Bundle)bundle);
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("onMessage failed " + throwable.getMessage()));
        }
    }
}

