/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.oth.sound.util;

import android.content.Context;
import android.util.Pair;
import com.engagelab.privates.common.constants.MTCommonConstants;
import com.engagelab.privates.common.global.MTGlobal;
import com.engagelab.privates.common.https.HostVerifier;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.common.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;

public class HttpUtil {
    private static final String TAG = "HttpUtil";
    private static final SimpleDateFormat GMT_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Pair<Integer, String> post(Context context, String requestUrl, String authorization, byte[] params) {
        String responseMessage;
        int responseCode;
        block13: {
            responseCode = -1;
            responseMessage = "";
            InputStream inputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            OutputStream outputStream = null;
            HttpURLConnection connection = null;
            try {
                URL url = new URL(requestUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setConnectTimeout(6000);
                connection.setReadTimeout(6000);
                connection.setRequestProperty("Authorization", authorization);
                connection.setRequestProperty("Charset", MTCommonConstants.UTF_8);
                connection.setRequestProperty("Accept", "application/jason");
                connection.setRequestProperty("Accept-Encoding", "gzip");
                connection.setRequestProperty("content-type", "application/octet-stream");
                connection.setRequestProperty("Content-Length", String.valueOf(params.length));
                connection.setRequestProperty("X-App-Key", MTGlobal.getAppKey((Context)context));
                String encryptType = "SM4";
                connection.setRequestProperty("Encrypt-Type", encryptType);
                if (connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setHostnameVerifier((HostnameVerifier)new HostVerifier(connection.getURL().getHost()));
                }
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                outputStream = connection.getOutputStream();
                outputStream.write(params);
                outputStream.flush();
                connection.connect();
                responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    int length;
                    inputStream = connection.getInputStream();
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    while ((length = inputStream.read(buffer)) != -1) {
                        byteArrayOutputStream.write(buffer, 0, length);
                    }
                    byte[] bytes = byteArrayOutputStream.toByteArray();
                    responseMessage = new String(bytes, MTCommonConstants.UTF_8);
                }
                Utils.closeQuietly((Closeable)outputStream);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                MTCommonLog.w((String)TAG, (String)("post socketTimeoutException " + socketTimeoutException.getMessage()));
                break block13;
            }
            catch (Throwable throwable) {
                MTCommonLog.w((String)TAG, (String)("post failed " + throwable.getMessage()));
                {
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
                Utils.closeQuietly(outputStream);
                Utils.closeQuietly(byteArrayOutputStream);
                Utils.closeQuietly(inputStream);
                if (connection != null) {
                    connection.disconnect();
                }
                break block13;
            }
            finally {
                Utils.closeQuietly(outputStream);
                Utils.closeQuietly(byteArrayOutputStream);
                Utils.closeQuietly(inputStream);
                if (connection != null) {
                    connection.disconnect();
                }
            }
            Utils.closeQuietly(byteArrayOutputStream);
            Utils.closeQuietly((Closeable)inputStream);
            if (connection != null) {
                connection.disconnect();
            }
        }
        return new Pair((Object)responseCode, (Object)responseMessage);
    }

    public static String httpPost(String url, int timeout, String data) {
        try {
            HttpURLConnection con = HttpUtil.getHttpURLConnectionWithProxy(url);
            con.setRequestProperty("Content-Type", "application/json");
            con.setConnectTimeout(timeout);
            con.setReadTimeout(timeout);
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            byte[] paras = data.getBytes();
            con.getOutputStream().write(paras);
            int responseCode = con.getResponseCode();
            MTCommonLog.w((String)TAG, (String)("httpPost:" + url + " responseCode:" + responseCode));
            if (200 != responseCode) {
                return null;
            }
            String strResponse = null;
            byte[] bytes = HttpUtil.readInputStream(con.getInputStream());
            if (bytes != null) {
                strResponse = new String(bytes, MTCommonConstants.UTF_8);
            }
            return strResponse;
        }
        catch (Throwable e) {
            MTCommonLog.w((String)TAG, (String)("httpPost:" + url + " fail." + e));
            return null;
        }
    }

    public static File download(String url, int timeout, String destPath) {
        try {
            HttpURLConnection con = HttpUtil.getHttpURLConnectionWithProxy(url);
            con.setConnectTimeout(timeout);
            con.setReadTimeout(timeout);
            int responseCode = con.getResponseCode();
            MTCommonLog.w((String)TAG, (String)("download:" + url + " responseCode:" + responseCode));
            if (200 != responseCode) {
                return null;
            }
            File destFile = HttpUtil.saveFile(destPath, con.getInputStream());
            return destFile;
        }
        catch (Throwable e) {
            MTCommonLog.w((String)TAG, (String)("download:" + url + " fail." + e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File saveFile(String destPath, InputStream inputStream) throws FileNotFoundException, IOException {
        File destFile = new File(destPath);
        if (!destFile.getParentFile().exists()) {
            destFile.mkdirs();
        }
        if (destFile.exists()) {
            destFile.delete();
        }
        destFile.createNewFile();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            int len = 0;
            while ((len = inputStream.read(buffer)) > 0) {
                ((OutputStream)fos).write(buffer, 0, len);
            }
            fos.flush();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (fos != null) {
                ((OutputStream)fos).close();
            }
        }
        return destFile;
    }

    public static HttpURLConnection getHttpURLConnectionWithProxy(String url) throws IOException {
        URL mUrl = new URL(url);
        return (HttpURLConnection)mUrl.openConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = null;
        byte[] bytes = null;
        try {
            outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            outStream.flush();
            bytes = outStream.toByteArray();
        }
        catch (Throwable e) {
            MTCommonLog.w((String)TAG, (String)(" readInputStream failed , error is : " + e.getMessage()));
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        return bytes;
    }

    public static long parseGmtTime(String gmtTime) {
        try {
            return GMT_FORMAT.parse(gmtTime).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }
}

