/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.text.TextUtils;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.SecurityBase64Utils;
import com.huawei.secure.android.common.util.SafeString;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Locale;

public class StringUtils {
    private static final String SAFE_STRING_PATH = "com.huawei.secure.android.common.util.SafeString";
    private static boolean IS_AEGIS_STRING_LIBRARY_LOADED = false;
    private static final String TAG = "StringUtils";
    private static final int INIT_CAPACITY = 1024;

    public static boolean strEquals(String first, String second) {
        return first == second || first != null && first.equals(second);
    }

    public static String byte2Str(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.w("StringUtils.byte2str error: UnsupportedEncodingException", StringUtils.anonymizeMessage(e.getMessage()));
            return "";
        }
    }

    public static byte[] str2Byte(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return new byte[0];
        }
        try {
            return text.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.w("StringUtils.str2Byte error: UnsupportedEncodingException", StringUtils.anonymizeMessage(e.getMessage()));
            return new byte[0];
        }
    }

    public static String anonymizeMessage(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return message;
        }
        char[] messageChars = message.toCharArray();
        for (int i = 0; i < messageChars.length; ++i) {
            if (i % 2 == 0) continue;
            messageChars[i] = 42;
        }
        return new String(messageChars);
    }

    public static byte[] getBytes(long content) {
        return StringUtils.getBytes(String.valueOf(content));
    }

    public static byte[] getBytes(String content) {
        byte[] bytes = new byte[]{};
        if (content == null) {
            return bytes;
        }
        try {
            bytes = content.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.w(TAG, "the content has error while it is converted to bytes");
        }
        return bytes;
    }

    public static String format(String format, Object ... objects) {
        if (format == null) {
            return "";
        }
        return String.format(Locale.ROOT, format, objects);
    }

    public static String toLowerCase(String source) {
        if (source == null) {
            return "";
        }
        return source.toLowerCase(Locale.ROOT);
    }

    public static String getTraceInfo(Throwable e) {
        StackTraceElement[] stacks = e.getStackTrace();
        StringBuilder stackTrace = new StringBuilder(1024);
        for (StackTraceElement stackTraceElement : stacks) {
            stackTrace.append("at ").append(stackTraceElement.toString()).append(";");
        }
        return stackTrace.toString();
    }

    public static String substring(String content, int beginIndex) {
        if (StringUtils.checkCompatible(SAFE_STRING_PATH)) {
            try {
                return SafeString.substring((String)content, (int)beginIndex);
            }
            catch (Throwable ex) {
                Logger.w(TAG, "SafeString.substring error");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)content) && content.length() >= beginIndex && beginIndex >= 0) {
            try {
                return content.substring(beginIndex);
            }
            catch (Exception ex) {
                return "";
            }
        }
        return "";
    }

    public static String substring(String content, int beginIndex, int endIndex) {
        if (IS_AEGIS_STRING_LIBRARY_LOADED || StringUtils.checkCompatible(SAFE_STRING_PATH)) {
            try {
                return SafeString.substring((String)content, (int)beginIndex, (int)endIndex);
            }
            catch (Throwable throwable) {
                Logger.w(TAG, "SafeString.substring error");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)content) && beginIndex >= 0 && endIndex <= content.length() && endIndex >= beginIndex) {
            try {
                return content.substring(beginIndex, endIndex);
            }
            catch (Exception ex) {
                return "";
            }
        }
        return "";
    }

    public static String replace(String content, CharSequence target, CharSequence replacement) {
        if (IS_AEGIS_STRING_LIBRARY_LOADED || StringUtils.checkCompatible(SAFE_STRING_PATH)) {
            try {
                return SafeString.replace((String)content, (CharSequence)target, (CharSequence)replacement);
            }
            catch (Throwable throwable) {
                Logger.w(TAG, "SafeString.substring error");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)content) && !TextUtils.isEmpty((CharSequence)target)) {
            try {
                return content.replace(target, replacement);
            }
            catch (Exception ex) {
                return content;
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkCompatible(String className) {
        ClassLoader classLoader = SecurityBase64Utils.class.getClassLoader();
        if (null == classLoader) {
            return false;
        }
        try {
            classLoader.loadClass(className);
            Class<StringUtils> clazz = StringUtils.class;
            synchronized (StringUtils.class) {
                IS_AEGIS_STRING_LIBRARY_LOADED = true;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static long stringToLong(String value, long defaultValue) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        long num = defaultValue;
        try {
            num = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            Logger.w(TAG, "String to Long catch NumberFormatException." + StringUtils.anonymizeMessage(e.getMessage()));
        }
        return num;
    }

    public static int stringToInteger(String value, int defaultValue) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        int num = defaultValue;
        try {
            num = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Logger.w(TAG, "String to Integer catch NumberFormatException." + StringUtils.anonymizeMessage(e.getMessage()));
        }
        return num;
    }

    public static boolean stringToBoolean(String value, boolean defaultValue) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(value);
        }
        catch (NumberFormatException e) {
            Logger.w(TAG, "String to Integer catch NumberFormatException." + StringUtils.anonymizeMessage(e.getMessage()));
            return defaultValue;
        }
    }

    public static String collection2String(Collection<String> collection) {
        if (collection != null && !collection.isEmpty()) {
            StringBuilder ips = new StringBuilder();
            for (String ip : collection) {
                ips.append(ip).append(";");
            }
            return ips.toString().substring(0, ips.length() - 1);
        }
        return null;
    }
}

