/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@VisibleForTesting
@KeepForSdk
public final class JsonUtils {
    private static final Pattern zza = Pattern.compile("\\\\.");
    private static final Pattern zzb = Pattern.compile("[\\\\\"/\b\f\n\r\t]");

    @Nullable
    @KeepForSdk
    public static String escapeString(@Nullable String text) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)text)) {
            Matcher matcher = zzb.matcher(string2);
            StringBuffer stringBuffer = null;
            block10: while (matcher.find()) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                switch (matcher.group().charAt(0)) {
                    default: {
                        continue block10;
                    }
                    case '\\': {
                        matcher.appendReplacement(stringBuffer, "\\\\\\\\");
                        continue block10;
                    }
                    case '/': {
                        matcher.appendReplacement(stringBuffer, "\\\\/");
                        continue block10;
                    }
                    case '\"': {
                        matcher.appendReplacement(stringBuffer, "\\\\\\\"");
                        continue block10;
                    }
                    case '\r': {
                        matcher.appendReplacement(stringBuffer, "\\\\r");
                        continue block10;
                    }
                    case '\f': {
                        matcher.appendReplacement(stringBuffer, "\\\\f");
                        continue block10;
                    }
                    case '\n': {
                        matcher.appendReplacement(stringBuffer, "\\\\n");
                        continue block10;
                    }
                    case '\t': {
                        matcher.appendReplacement(stringBuffer, "\\\\t");
                        continue block10;
                    }
                    case '\b': 
                }
                matcher.appendReplacement(stringBuffer, "\\\\b");
            }
            if (stringBuffer == null) {
                return string2;
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return string2;
    }

    /*
     * Exception decompiling
     */
    @KeepForSdk
    @NonNull
    public static String unescapeString(@NonNull String text) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JsonUtils() {
    }

    /*
     * Loose catch block
     */
    @KeepForSdk
    public static boolean areJsonValuesEquivalent(@Nullable Object a, @Nullable Object b) {
        JSONObject jSONObject;
        if (a != null || jSONObject != null) {
            Object object;
            if (object == null || jSONObject == null) {
                return false;
            }
            if (object instanceof JSONObject && jSONObject instanceof JSONObject) {
                object = (JSONObject)object;
                jSONObject = jSONObject;
                if (object.length() != jSONObject.length()) {
                    return false;
                }
                Iterator iterator = object.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (!jSONObject.has(string2)) {
                        return false;
                    }
                    Preconditions.checkNotNull(string2);
                    boolean bl = JsonUtils.areJsonValuesEquivalent(object.get(string2), jSONObject.get(string2));
                    if (bl) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof JSONArray && jSONObject instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)object;
                jSONObject = (JSONArray)jSONObject;
                if (jSONArray.length() == jSONObject.length()) {
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        boolean bl = JsonUtils.areJsonValuesEquivalent(jSONArray.get(i), jSONObject.get(i));
                        if (bl) {
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return object.equals(jSONObject);
        }
        return true;
        catch (JSONException jSONException) {
            return false;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }
}

