/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.common.business.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.engagelab.privates.common.api.MTCommonPrivatesApi;
import com.engagelab.privates.common.business.network.MTNetworkListener;
import com.engagelab.privates.common.global.MTGlobal;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.common.utils.ReceiverUtils;

public class MTNetworkBusiness {
    private static final String TAG = "MTNetworkBusiness";
    public static final int STATE_NETWORK_CONNECTED = 1;
    public static final int STATE_NETWORK_DISCONNECTED = 0;
    private static volatile MTNetworkBusiness instance;
    private MTNetworkListener networkListener;
    private int networkState = 0;
    private boolean init = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MTNetworkBusiness getInstance() {
        if (instance == null) {
            Class<MTNetworkBusiness> clazz = MTNetworkBusiness.class;
            synchronized (MTNetworkBusiness.class) {
                instance = new MTNetworkBusiness();
            }
        }
        return instance;
    }

    public void init(Context context) {
        IntentFilter intentFilter;
        Object this_;
        IntentFilter intentFilter2;
        if (this_.init) {
            return;
        }
        this_.init = true;
        Object object = (ConnectivityManager)intentFilter2.getSystemService("connectivity");
        if (Build.VERSION.SDK_INT >= 26) {
            MTNetworkListener mTNetworkListener;
            ConnectivityManager connectivityManager = object;
            MTNetworkBusiness mTNetworkBusiness = this_;
            MTNetworkListener mTNetworkListener2 = mTNetworkListener;
            try {
                mTNetworkBusiness.networkListener = new MTNetworkListener((Context)intentFilter2);
                connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)mTNetworkListener2);
                return;
            }
            catch (Throwable throwable) {
                MTNetworkListener mTNetworkListener3;
                ConnectivityManager connectivityManager2;
                try {
                    connectivityManager2 = object;
                    MTNetworkBusiness mTNetworkBusiness2 = this_;
                    mTNetworkListener2 = new NetworkRequest.Builder().build();
                }
                catch (Throwable throwable2) {}
                MTNetworkListener mTNetworkListener4 = mTNetworkListener3;
                mTNetworkBusiness2.networkListener = new MTNetworkListener((Context)intentFilter2);
                connectivityManager2.registerNetworkCallback((NetworkRequest)mTNetworkListener2, (ConnectivityManager.NetworkCallback)mTNetworkListener4);
                return;
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            MTNetworkListener mTNetworkListener;
            ConnectivityManager connectivityManager;
            try {
                connectivityManager = object;
                MTNetworkBusiness mTNetworkBusiness = this_;
                this_ = new NetworkRequest.Builder().build();
            }
            catch (Throwable throwable) {}
            object = mTNetworkListener;
            mTNetworkBusiness.networkListener = new MTNetworkListener((Context)intentFilter2);
            connectivityManager.registerNetworkCallback((NetworkRequest)this_, (ConnectivityManager.NetworkCallback)object);
            return;
        }
        void v12 = intentFilter2;
        this_ = MTGlobal.getCommonReceiver((Context)v12);
        intentFilter2 = intentFilter;
        new IntentFilter().addAction("android.net.conn.CONNECTIVITY_CHANGE");
        ReceiverUtils.registerReceiver((Context)v12, (BroadcastReceiver)this_, intentFilter2);
    }

    /*
     * WARNING - void declaration
     */
    public void release(Context context) {
        void var1_1;
        this.networkState = 0;
        if (Build.VERSION.SDK_INT >= 23) {
            ((ConnectivityManager)var1_1.getSystemService("connectivity")).unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.networkListener);
            return;
        }
        void v02 = var1_1;
        v02.unregisterReceiver((BroadcastReceiver)MTGlobal.getCommonReceiver((Context)v02));
    }

    /*
     * WARNING - void declaration
     */
    public void onMainNetworkState(Context context, Bundle bundle) {
        String string;
        void var1_2;
        void var2_3;
        Bundle bundle2 = bundle;
        NetworkInfo networkInfo = (NetworkInfo)bundle2.getParcelable("networkInfo");
        boolean bl = bundle2.containsKey("state") ? var2_3.getBoolean("state") : networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED;
        networkInfo = this.onMainNetworkState((Context)var1_2, bl, networkInfo);
        if (bl && this.networkState == 1) {
            Bundle bundle3;
            string = bundle3;
            new Bundle().putBoolean("state", false);
            string.putInt("type", 0);
            string.putString("name", "unknown");
            string.putString("radio", "unknown");
            MTCommonLog.d(TAG, "onMainNetworkState network is connecting, new network connected");
            MTCommonPrivatesApi.sendMessageToMainProcess((Context)var1_2, 1004, (Bundle)string);
            if (MTGlobal.isNeedRemoteProcess) {
                MTCommonPrivatesApi.sendMessageToRemoteProcess((Context)var1_2, 1996, (Bundle)string);
            }
        }
        string = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("onMainNetworkState ");
        String string2 = bl ? "connected" : "disConnected";
        MTCommonLog.d(string, stringBuilder.append(string2).append(" currentNetwork:").append(MTGlobal.getNetworkName()).toString());
        this.networkState = bl ? 1 : 0;
        int n2 = bl ? 1003 : 1004;
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)var1_2, n2, (Bundle)networkInfo);
        if (MTGlobal.isNeedRemoteProcess) {
            n2 = bl ? 1997 : 1996;
            MTCommonPrivatesApi.sendMessageToRemoteProcess((Context)var1_2, n2, (Bundle)networkInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Bundle onMainNetworkState(Context context, boolean state, NetworkInfo networkInfo) {
        void var3_3;
        Bundle bundle;
        MTNetworkBusiness mTNetworkBusiness = bundle;
        bundle = new Bundle();
        if (!state) {
            MTNetworkBusiness mTNetworkBusiness2 = mTNetworkBusiness;
            MTGlobal.setNetworkState(false);
            MTGlobal.setNetworkType(0);
            MTGlobal.setNetworkName("unknown");
            MTGlobal.setNetworkRadio("unknown");
            mTNetworkBusiness2.putBoolean("state", false);
            mTNetworkBusiness2.putInt("type", 0);
            mTNetworkBusiness2.putString("name", "unknown");
            mTNetworkBusiness2.putString("radio", "unknown");
            return mTNetworkBusiness2;
        }
        MTGlobal.setNetworkState(true);
        mTNetworkBusiness.putBoolean("state", true);
        if (var3_3.getType() == 1) {
            MTNetworkBusiness mTNetworkBusiness3 = mTNetworkBusiness;
            MTGlobal.setNetworkType(1);
            MTGlobal.setNetworkName("wifi");
            MTGlobal.setNetworkRadio("wifi");
            mTNetworkBusiness3.putInt("type", 1);
            mTNetworkBusiness3.putString("name", "wifi");
            mTNetworkBusiness3.putString("radio", "wifi");
            return mTNetworkBusiness3;
        }
        switch (var3_3.getSubtype()) {
            default: {
                MTNetworkBusiness mTNetworkBusiness4 = mTNetworkBusiness;
                MTGlobal.setNetworkType(0);
                MTGlobal.setNetworkName("unknown");
                MTGlobal.setNetworkRadio("unknown");
                mTNetworkBusiness4.putInt("type", 0);
                mTNetworkBusiness4.putString("name", "unknown");
                mTNetworkBusiness4.putString("radio", "unknown");
                break;
            }
            case 20: {
                MTNetworkBusiness mTNetworkBusiness5 = mTNetworkBusiness;
                MTGlobal.setNetworkType(5);
                MTGlobal.setNetworkName("5g");
                MTGlobal.setNetworkRadio("nr");
                mTNetworkBusiness5.putInt("type", 5);
                mTNetworkBusiness5.putString("name", "5g");
                mTNetworkBusiness5.putString("radio", "nr");
                break;
            }
            case 13: 
            case 18: 
            case 19: {
                MTNetworkBusiness mTNetworkBusiness6 = mTNetworkBusiness;
                MTGlobal.setNetworkType(4);
                MTGlobal.setNetworkName("4g");
                MTGlobal.setNetworkRadio("lte");
                mTNetworkBusiness6.putInt("type", 4);
                mTNetworkBusiness6.putString("name", "4g");
                mTNetworkBusiness6.putString("radio", "lte");
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                MTNetworkBusiness mTNetworkBusiness7 = mTNetworkBusiness;
                MTGlobal.setNetworkType(3);
                MTGlobal.setNetworkName("3g");
                MTGlobal.setNetworkRadio("gsm");
                mTNetworkBusiness7.putInt("type", 3);
                mTNetworkBusiness7.putString("name", "3g");
                mTNetworkBusiness7.putString("radio", "gsm");
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                MTNetworkBusiness mTNetworkBusiness8 = mTNetworkBusiness;
                MTGlobal.setNetworkType(2);
                MTGlobal.setNetworkName("2g");
                MTGlobal.setNetworkRadio("cdma");
                mTNetworkBusiness8.putInt("type", 2);
                mTNetworkBusiness8.putString("name", "2g");
                mTNetworkBusiness8.putString("radio", "cdma");
            }
        }
        return mTNetworkBusiness;
    }

    public void onRemoteNetworkState(Context context, Bundle bundle) {
        String string;
        if (bundle == null) {
            return;
        }
        void v02 = string;
        boolean bl = v02.getBoolean("state");
        int n2 = v02.getInt("type");
        void v2 = string;
        CharSequence charSequence = v2.getString("name");
        string = v2.getString("radio");
        MTGlobal.setNetworkState(bl);
        MTGlobal.setNetworkType(n2);
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            charSequence = "unknown";
        }
        MTGlobal.setNetworkName((String)charSequence);
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "unknown";
        }
        MTGlobal.setNetworkRadio(string);
        String string2 = TAG;
        charSequence = new StringBuilder().append("onRemoteNetworkState ");
        string = bl ? "connected" : "disConnected";
        MTCommonLog.d(string2, ((StringBuilder)charSequence).append(string).append(" currentNetwork:").append(MTGlobal.getNetworkName()).toString());
    }
}

