/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.common.utils;

import android.util.Base64;
import com.engagelab.privates.common.constants.MTCommonConstants;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.common.utils.AESUtil;
import com.engagelab.privates.common.utils.Guard;
import java.util.Arrays;

public class SM4Util {
    private static final String TAG = "SM4";
    public static final String A = Guard.string(new byte[]{88});
    private static final int ROUND = 32;
    private static final int BLOCK = 16;
    private static byte[] Sbox = new byte[]{-42, -112, -23, -2, -52, -31, 61, -73, 22, -74, 20, -62, 40, -5, 44, 5, 43, 103, -102, 118, 42, -66, 4, -61, -86, 68, 19, 38, 73, -122, 6, -103, -100, 66, 80, -12, -111, -17, -104, 122, 51, 84, 11, 67, -19, -49, -84, 98, -28, -77, 28, -87, -55, 8, -24, -107, -128, -33, -108, -6, 117, -113, 63, -90, 71, 7, -89, -4, -13, 115, 23, -70, -125, 89, 60, 25, -26, -123, 79, -88, 104, 107, -127, -78, 113, 100, -38, -117, -8, -21, 15, 75, 112, 86, -99, 53, 30, 36, 14, 94, 99, 88, -47, -94, 37, 34, 124, 59, 1, 33, 120, -121, -44, 0, 70, 87, -97, -45, 39, 82, 76, 54, 2, -25, -96, -60, -56, -98, -22, -65, -118, -46, 64, -57, 56, -75, -93, -9, -14, -50, -7, 97, 21, -95, -32, -82, 93, -92, -101, 52, 26, 85, -83, -109, 50, 48, -11, -116, -79, -29, 29, -10, -30, 46, -126, 102, -54, 96, -64, 41, 35, -85, 13, 83, 78, 111, -43, -37, 55, 69, -34, -3, -114, 47, 3, -1, 106, 114, 109, 108, 91, 81, -115, 27, -81, -110, -69, -35, -68, 127, 17, -39, 92, 65, 31, 16, 90, -40, 10, -63, 49, -120, -91, -51, 123, -67, 45, 116, -48, 18, -72, -27, -76, -80, -119, 105, -105, 74, 12, -106, 119, 126, 101, -71, -15, 9, -59, 110, -58, -124, 24, -16, 125, -20, 58, -36, 77, 32, 121, -18, 95, 62, -41, -53, 57, 72};
    private static int[] CK = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};

    /*
     * WARNING - void declaration
     */
    private static int Rotl(int x2, int y2) {
        int n2;
        void var1_1;
        return x2 << var1_1 | n2 >>> 32 - var1_1;
    }

    private static int ByteSub(int A) {
        int n2;
        byte[] byArray = Sbox;
        return (Sbox[n2 >>> 24 & 0xFF] & 0xFF) << 24 | (byArray[n2 >>> 16 & 0xFF] & 0xFF) << 16 | (byArray[n2 >>> 8 & 0xFF] & 0xFF) << 8 | byArray[n2 & 0xFF] & 0xFF;
    }

    private static int L1(int B) {
        int n2;
        int n3 = B;
        return n3 ^ SM4Util.Rotl(n3, 2) ^ SM4Util.Rotl(n2, 10) ^ SM4Util.Rotl(n2, 18) ^ SM4Util.Rotl(n2, 24);
    }

    private static int L2(int B) {
        int n2;
        int n3 = B;
        return n3 ^ SM4Util.Rotl(n3, 13) ^ SM4Util.Rotl(n2, 23);
    }

    private static int[] L3(byte[] input) {
        int[] nArray = new int[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            byte[] byArray;
            int n2 = i2 * 4;
            nArray[i2] = (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public static void sm4Crypt(byte[] input, byte[] output, int[] rk) {
        int n2;
        Object[] objectArray = SM4Util.L3(input);
        for (n2 = 0; n2 < 32; n2 += 4) {
            void var2_2;
            Object[] objectArray2 = objectArray;
            objectArray2[0] = objectArray[0] ^ SM4Util.L1(SM4Util.ByteSub(objectArray[1] ^ objectArray[2] ^ objectArray[3] ^ var2_2[n2]));
            objectArray2[1] = objectArray[1] ^ SM4Util.L1(SM4Util.ByteSub(objectArray[2] ^ objectArray[3] ^ objectArray[0] ^ var2_2[n2 + 1]));
            objectArray2[2] = objectArray[2] ^ SM4Util.L1(SM4Util.ByteSub(objectArray[3] ^ objectArray[0] ^ objectArray[1] ^ var2_2[n2 + 2]));
            objectArray2[3] = objectArray[3] ^ SM4Util.L1(SM4Util.ByteSub(objectArray[0] ^ objectArray[1] ^ objectArray[2] ^ var2_2[n2 + 3]));
        }
        for (int i2 = 0; i2 < 16; i2 += 4) {
            n2 = 3 - i2 / 4;
            var1_1[i2] = (byte)(objectArray[n2] >>> 24 & 0xFF);
            int n3 = i2 + 1;
            var1_1[n3] = (byte)(objectArray[n2] >>> 16 & 0xFF);
            n3 = i2 + 2;
            var1_1[n3] = (byte)(objectArray[n2] >>> 8 & 0xFF);
            int n4 = n2;
            n2 = i2 + 3;
            var1_1[n2] = (byte)(objectArray[n4] & 0xFF);
        }
    }

    public static int[] sm4KeyExt(byte[] key, boolean isDecrypt) {
        int n2;
        int n3;
        int[] nArray = SM4Util.L3(key);
        Object[] objectArray = nArray;
        nArray[0] = nArray[0] ^ 0xA3B1BAC6;
        nArray[1] = nArray[1] ^ 0x56AA3350;
        nArray[2] = nArray[2] ^ 0x677D9197;
        nArray[3] = nArray[3] ^ 0xB27022DC;
        int[] nArray2 = new int[32];
        for (n3 = 0; n3 < 32; n3 += 4) {
            int n4;
            int n5;
            objectArray[0] = n5 = objectArray[0] ^ SM4Util.L2(SM4Util.ByteSub(objectArray[1] ^ objectArray[2] ^ objectArray[3] ^ CK[n3]));
            nArray2[n3] = n5;
            n5 = n3 + 1;
            objectArray[1] = n4 = objectArray[1] ^ SM4Util.L2(SM4Util.ByteSub(objectArray[2] ^ objectArray[3] ^ objectArray[0] ^ CK[n5]));
            nArray2[n5] = n4;
            n5 = n3 + 2;
            objectArray[2] = n4 = objectArray[2] ^ SM4Util.L2(SM4Util.ByteSub(objectArray[3] ^ objectArray[0] ^ objectArray[1] ^ CK[n5]));
            nArray2[n5] = n4;
            n5 = n3 + 3;
            objectArray[3] = n4 = objectArray[3] ^ SM4Util.L2(SM4Util.ByteSub(objectArray[0] ^ objectArray[1] ^ objectArray[2] ^ CK[n5]));
            nArray2[n5] = n4;
        }
        if (n2 != 0) {
            for (int i2 = 0; i2 < 16; ++i2) {
                int[] nArray3 = nArray2;
                int[] nArray4 = nArray2;
                n2 = nArray3[i2];
                n3 = 31 - i2;
                nArray3[i2] = nArray4[n3];
                nArray4[n3] = n2;
            }
        }
        return nArray2;
    }

    public static byte[] encode(byte[] plain, byte[] key, byte[] iv) throws Exception {
        byte[] byArray;
        if (plain != null && byArray.length != 0) {
            int[] nArray;
            if (nArray != null && nArray.length == 16) {
                int n2;
                byte[] byArray2;
                if (byArray2 != null && byArray2.length != 16) {
                    byArray2 = null;
                }
                byArray = SM4Util.pkcs7padding(byArray);
                nArray = SM4Util.sm4KeyExt((byte[])nArray, false);
                byte[] byArray3 = new byte[16];
                byte[] byArray4 = new byte[byArray.length];
                int n3 = 0;
                while ((n2 = n3 + 16) <= byArray.length) {
                    System.arraycopy(byArray, n3, byArray3, 0, 16);
                    if (byArray2 != null) {
                        SM4Util.cbcXor(byArray3, byArray2);
                    } else {
                        byArray2 = new byte[16];
                    }
                    SM4Util.sm4Crypt(byArray3, byArray2, nArray);
                    int n4 = byArray2.length;
                    System.arraycopy(byArray2, 0, byArray4, n3, n4);
                    n3 = n2;
                }
                return byArray4;
            }
            throw new IllegalArgumentException("key's length should be 16");
        }
        return byArray;
    }

    public static byte[] decode(byte[] cipher, byte[] key, byte[] iv) throws Exception {
        byte[] byArray;
        if (cipher != null && byArray.length != 0) {
            int[] nArray;
            if (nArray != null && nArray.length == 16) {
                int n2;
                byte[] byArray2;
                if (byArray2 != null && byArray2.length != 16) {
                    byArray2 = null;
                }
                nArray = SM4Util.sm4KeyExt((byte[])nArray, true);
                byte[] byArray3 = new byte[16];
                int n3 = 16;
                byte[] byArray4 = new byte[16];
                byte[] byArray5 = new byte[byArray.length];
                int n4 = 0;
                while ((n2 = n4 + 16) <= byArray.length) {
                    System.arraycopy(byArray, n4, byArray3, 0, 16);
                    SM4Util.sm4Crypt(byArray3, byArray4, nArray);
                    if (byArray2 != null) {
                        SM4Util.cbcXor(byArray4, byArray2);
                    } else {
                        byArray2 = new byte[16];
                    }
                    System.arraycopy(byArray, n4, byArray2, 0, 16);
                    System.arraycopy(byArray4, 0, byArray5, n4, n3);
                    n4 = n2;
                }
                return SM4Util.revertPkcs7Padding(byArray5);
            }
            throw new IllegalArgumentException("key's length should be 16");
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private static void cbcXor(byte[] bytes0, byte[] bytes1) {
        byte[] byArray;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            void var1_1;
            byArray[i2] = (byte)(byArray[i2] ^ var1_1[i2]);
        }
    }

    private static byte[] pkcs7padding(byte[] origin) {
        int n2 = 16 - origin.length % 16;
        byte[] byArray = Arrays.copyOf(origin, origin.length + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] byArray2;
            int n3 = byArray2.length + i2;
            byArray[n3] = (byte)n2;
        }
        return byArray;
    }

    private static byte[] revertPkcs7Padding(byte[] paddingBytes) {
        byte[] byArray;
        int n2 = paddingBytes[paddingBytes.length - 1];
        n2 = paddingBytes.length - n2;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encryptBytes(byte[] plain, String seed, String iv) throws Exception {
        void var2_2;
        void var1_1;
        byte[] byArray = SM4Util.hexStringToByte((String)var1_1);
        return SM4Util.encode(plain, byArray, var2_2.getBytes("utf-8"));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decryptBytes(byte[] encrypt, String seed) throws Exception {
        void var1_1;
        void v02 = var1_1;
        byte[] byArray = SM4Util.hexStringToByte((String)v02);
        return SM4Util.decode(encrypt, byArray, v02.substring(0, 16).getBytes("utf-8"));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decryptBytes(byte[] encrypt, String seed, String iv) throws Exception {
        void var2_2;
        void var1_1;
        byte[] byArray = SM4Util.hexStringToByte((String)var1_1);
        return SM4Util.decode(encrypt, byArray, var2_2.getBytes("utf-8"));
    }

    public static byte[] hexStringToByte(String hex) {
        String string = hex;
        int n2 = string.length() / 2;
        byte[] byArray = new byte[n2];
        char[] cArray = string.toLowerCase().toCharArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 * 2;
            byArray[i2] = (byte)(SM4Util.toByte(cArray[n3]) << 4 | SM4Util.toByte(cArray[n3 + 1]));
        }
        return byArray;
    }

    private static int toByte(char c2) {
        char c3;
        return (byte)"0123456789abcdef".indexOf(c3);
    }

    public static String toHexString(byte[] byteArray) {
        byte[] byArray;
        if (byteArray != null && byArray.length >= 1) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            int n2 = byArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = byArray[i2] & 0xFF;
                if (n3 < 16) {
                    stringBuilder2.append("0");
                }
                stringBuilder2.append(Integer.toHexString(n3));
            }
            return stringBuilder2.toString().toLowerCase();
        }
        throw new IllegalArgumentException("this byteArray must not be null or empty");
    }

    public static String decodeMessage(String jme) {
        int n2;
        int n3;
        String string;
        String string2;
        String string3;
        try {
            String string4 = jme;
            string3 = string4;
            string2 = string4;
            string = string4;
            n3 = string4.lastIndexOf(A);
            n2 = n3 + 1;
        }
        catch (Throwable throwable) {
            String string5;
            MTCommonLog.w(TAG, "dM e:" + throwable);
            MTCommonLog.w(TAG, "dM :" + string5);
            return null;
        }
        String string6 = string2.substring(n2, string3.length());
        String string7 = AESUtil.getMd5AesKey(Long.parseLong(string6));
        byte[] byArray = SM4Util.decryptBytes(Base64.decode((String)string.substring(0, n3), (int)2), string7, string7.substring(0, 16));
        return new String(byArray, MTCommonConstants.UTF_8);
    }
}

