/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.push;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import com.huawei.hmf.tasks.Task;
import com.huawei.hmf.tasks.TaskCompletionSource;
import com.huawei.hmf.tasks.Tasks;
import com.huawei.hms.aaid.constant.ErrorEnum;
import com.huawei.hms.aaid.encrypt.PushEncrypter;
import com.huawei.hms.aaid.init.AutoInitHelper;
import com.huawei.hms.aaid.plugin.ProxyCenter;
import com.huawei.hms.aaid.task.PushClientBuilder;
import com.huawei.hms.aaid.utils.BaseUtils;
import com.huawei.hms.aaid.utils.PushPreferences;
import com.huawei.hms.android.HwBuildEx;
import com.huawei.hms.api.Api;
import com.huawei.hms.common.ApiException;
import com.huawei.hms.common.HuaweiApi;
import com.huawei.hms.common.internal.AbstractClientBuilder;
import com.huawei.hms.common.internal.Preconditions;
import com.huawei.hms.common.internal.TaskApiCall;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.push.RemoteMessage;
import com.huawei.hms.push.d;
import com.huawei.hms.push.s;
import com.huawei.hms.push.task.BaseVoidTask;
import com.huawei.hms.push.task.IntentCallable;
import com.huawei.hms.push.task.SendUpStreamTask;
import com.huawei.hms.push.task.SubscribeTask;
import com.huawei.hms.push.utils.PushBiUtil;
import com.huawei.hms.support.api.entity.push.EnableNotifyReq;
import com.huawei.hms.support.api.entity.push.UpSendMsgReq;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.JsonUtil;
import com.huawei.hms.utils.NetWorkUtil;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

public class HmsMessaging {
    public static final String DEFAULT_TOKEN_SCOPE = "HCM";
    public static final Pattern a = Pattern.compile("[\\u4e00-\\u9fa5\\w-_.~%]{1,900}");
    public Context b;
    public HuaweiApi<Api.ApiOptions.NoOptions> c;

    public HmsMessaging(Context context) {
        HmsMessaging hmsMessaging;
        PushClientBuilder pushClientBuilder;
        Api api;
        Context context2 = context;
        Preconditions.checkNotNull((Object)context2);
        hmsMessaging2.b = context2;
        HmsMessaging hmsMessaging2 = api;
        api = new Api("HuaweiPush.API");
        HmsMessaging hmsMessaging3 = hmsMessaging2;
        hmsMessaging2 = pushClientBuilder;
        pushClientBuilder = new PushClientBuilder();
        hmsMessaging.c = new HuaweiApi(context, (Api)hmsMessaging3, null, (AbstractClientBuilder)hmsMessaging2);
        hmsMessaging.c.setKitSdkVersion(60500300);
    }

    public static synchronized HmsMessaging getInstance(Context context) {
        return new HmsMessaging(context);
    }

    public boolean isAutoInitEnabled() {
        return AutoInitHelper.isAutoInitEnabled((Context)this.b);
    }

    public void setAutoInitEnabled(boolean bl) {
        AutoInitHelper.setAutoInitEnabled((Context)this.b, (boolean)bl);
    }

    public Task<Void> subscribe(String string) {
        HMSLog.i((String)"HmsMessaging", (String)"invoke subscribe");
        return this.a(string, "Sub");
    }

    public Task<Void> unsubscribe(String string) {
        HMSLog.i((String)"HmsMessaging", (String)"invoke unsubscribe");
        return this.a(string, "UnSub");
    }

    public void send(RemoteMessage remoteMessage) {
        if (ProxyCenter.getProxy() == null) {
            HMSLog.i((String)"HmsMessaging", (String)"send upstream message");
            this.a(remoteMessage);
            return;
        }
        HMSLog.e((String)"HmsMessaging", (String)"Operation(send) unsupported");
        throw new UnsupportedOperationException("Operation(send) unsupported");
    }

    public Task<Void> turnOnPush() {
        if (ProxyCenter.getProxy() != null) {
            HMSLog.i((String)"HmsMessaging", (String)"turn on for proxy");
            return ProxyCenter.getProxy().turnOn(this.b, null);
        }
        HMSLog.i((String)"HmsMessaging", (String)"invoke turnOnPush");
        return this.a(true);
    }

    public Task<Void> turnOffPush() {
        if (ProxyCenter.getProxy() != null) {
            HMSLog.i((String)"HmsMessaging", (String)"turn off for proxy");
            return ProxyCenter.getProxy().turnOff(this.b, null);
        }
        HMSLog.i((String)"HmsMessaging", (String)"invoke turnOffPush");
        return this.a(false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final Task<Void> a(String var1_2, String var2_4) {
        block12: {
            block11: {
                var3_5 = PushBiUtil.reportEntry(this.b, "push.subscribe");
                if (var1_2 == null || !HmsMessaging.a.matcher(var1_2).matches()) break block12;
                if (ProxyCenter.getProxy() != null) {
                    HMSLog.i((String)"HmsMessaging", (String)"use proxy subscribe.");
                    return TextUtils.equals((CharSequence)var2_4, (CharSequence)"Sub") != false ? ProxyCenter.getProxy().subscribe(this.b, var1_2, var3_5) : ProxyCenter.getProxy().unsubscribe(this.b, var1_2, var3_5);
                }
                var4_6 /* !! */  = d.a(this.b);
                if (var4_6 /* !! */  != ErrorEnum.SUCCESS) ** GOTO lbl30
                if (NetWorkUtil.getNetworkType((Context)this.b) == 0) break block11;
                var4_6 /* !! */  = v0;
                v1 = var4_6 /* !! */ ;
                var4_6 /* !! */ (this.b, var2_4, var1_2);
                v2 = this.b;
                v1.setToken(BaseUtils.getLocalToken((Context)v2, null));
                if (!s.b()) ** GOTO lbl23
                v3 = this.c;
                return v3.doWrite((TaskApiCall)new BaseVoidTask("push.subscribe", JsonUtil.createJsonString((IMessageEntity)var4_6 /* !! */ ), var3_5));
lbl23:
                // 1 sources

                v4 = this.c;
                return v4.doWrite((TaskApiCall)new SubscribeTask("push.subscribe", JsonUtil.createJsonString((IMessageEntity)var4_6 /* !! */ ), var3_5));
            }
            try {
                HMSLog.e((String)"HmsMessaging", (String)"no network");
                throw ErrorEnum.ERROR_NO_NETWORK.toApiException();
lbl30:
                // 1 sources

                throw var4_6 /* !! */ .toApiException();
            }
            catch (Exception v5) {
                v6 = new TaskCompletionSource();
                v6.setException((Exception)ErrorEnum.ERROR_INTERNAL_ERROR.toApiException());
                this = ErrorEnum.ERROR_INTERNAL_ERROR;
                PushBiUtil.reportExit(this.b, "push.subscribe", var3_5, (ErrorEnum)this);
                return v6.getTask();
            }
            catch (ApiException var1_3) {
                var2_4 = v7;
                var2_4();
                var2_4.setException((Exception)var1_3);
                var0_1 = var1_3.getStatusCode();
                PushBiUtil.reportExit(this.b, "push.subscribe", var3_5, var0_1);
                return v7.getTask();
            }
        }
        this = ErrorEnum.ERROR_ARGUMENTS_INVALID;
        PushBiUtil.reportExit(this.b, "push.subscribe", var3_5, (ErrorEnum)this);
        HMSLog.e((String)"HmsMessaging", (String)"Invalid topic: topic should match the format:[\\u4e00-\\u9fa5\\w-_.~%]{1,900}");
        throw new IllegalArgumentException("Invalid topic: topic should match the format:[\\u4e00-\\u9fa5\\w-_.~%]{1,900}");
    }

    public final void a(RemoteMessage remoteMessage) {
        HmsMessaging hmsMessaging = hmsMessaging2;
        String string = PushBiUtil.reportEntry(hmsMessaging.b, "push.sendMessage");
        Object object = d.a(hmsMessaging.b);
        if (object == ErrorEnum.SUCCESS) {
            HmsMessaging hmsMessaging2;
            if (!TextUtils.isEmpty((CharSequence)remoteMessage.getTo())) {
                if (!TextUtils.isEmpty((CharSequence)remoteMessage.getMessageId())) {
                    if (!TextUtils.isEmpty((CharSequence)remoteMessage.getData())) {
                        UpSendMsgReq upSendMsgReq;
                        object = upSendMsgReq;
                        ((UpSendMsgReq)object)();
                        ((UpSendMsgReq)object).setPackageName(hmsMessaging2.b.getPackageName());
                        ((UpSendMsgReq)object).setMessageId(remoteMessage.getMessageId());
                        ((UpSendMsgReq)object).setTo(remoteMessage.getTo());
                        ((UpSendMsgReq)object).setData(remoteMessage.getData());
                        ((UpSendMsgReq)object).setMessageType(remoteMessage.getMessageType());
                        ((UpSendMsgReq)object).setTtl(remoteMessage.getTtl());
                        ((UpSendMsgReq)object).setCollapseKey(remoteMessage.getCollapseKey());
                        ((UpSendMsgReq)object).setSendMode(remoteMessage.getSendMode());
                        upSendMsgReq.setReceiptMode(remoteMessage.getReceiptMode());
                        if (s.b()) {
                            hmsMessaging2.c.doWrite((TaskApiCall)new BaseVoidTask("push.sendMessage", JsonUtil.createJsonString((IMessageEntity)object), string));
                        } else {
                            hmsMessaging2.a((UpSendMsgReq)object, string);
                        }
                        return;
                    }
                    HMSLog.e((String)"HmsMessaging", (String)"Mandatory parameter 'data' missing");
                    hmsMessaging2 = ErrorEnum.ERROR_ARGUMENTS_INVALID;
                    PushBiUtil.reportExit(hmsMessaging2.b, "push.sendMessage", string, (ErrorEnum)hmsMessaging2);
                    throw new IllegalArgumentException("Mandatory parameter 'data' missing");
                }
                HMSLog.e((String)"HmsMessaging", (String)"Mandatory parameter 'message_id' missing");
                hmsMessaging2 = ErrorEnum.ERROR_ARGUMENTS_INVALID;
                PushBiUtil.reportExit(hmsMessaging2.b, "push.sendMessage", string, (ErrorEnum)hmsMessaging2);
                throw new IllegalArgumentException("Mandatory parameter 'message_id' missing");
            }
            HMSLog.e((String)"HmsMessaging", (String)"Mandatory parameter 'to' missing");
            hmsMessaging2 = ErrorEnum.ERROR_ARGUMENTS_INVALID;
            PushBiUtil.reportExit(hmsMessaging2.b, "push.sendMessage", string, (ErrorEnum)hmsMessaging2);
            throw new IllegalArgumentException("Mandatory parameter 'to' missing");
        }
        HMSLog.e((String)"HmsMessaging", (String)("Message sent failed:" + object.getExternalCode() + ':' + object.getMessage()));
        PushBiUtil.reportExit(hmsMessaging2.b, "push.sendMessage", string, (ErrorEnum)object);
        throw new UnsupportedOperationException(object.getMessage());
    }

    public final Task<Void> a(boolean bl) {
        EnableNotifyReq enableNotifyReq;
        HmsMessaging hmsMessaging = hmsMessaging2;
        String string = PushBiUtil.reportEntry(hmsMessaging.b, "push.setNotifyFlag");
        if (s.d(hmsMessaging.b) && !s.b()) {
            Intent intent;
            Intent intent2;
            if (HwBuildEx.VERSION.EMUI_SDK_INT < 12) {
                HMSLog.e((String)"HmsMessaging", (String)"operation not available on Huawei device with EMUI lower than 5.1");
                TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
                taskCompletionSource.setException((Exception)((Object)ErrorEnum.ERROR_OPERATION_NOT_SUPPORTED.toApiException()));
                HmsMessaging hmsMessaging2 = ErrorEnum.ERROR_OPERATION_NOT_SUPPORTED;
                PushBiUtil.reportExit(hmsMessaging2.b, "push.setNotifyFlag", string, (ErrorEnum)hmsMessaging2);
                return taskCompletionSource.getTask();
            }
            if (s.b(hmsMessaging2.b) < 90101310L) {
                HMSLog.i((String)"HmsMessaging", (String)"turn on/off with broadcast v1");
                String string2 = PushEncrypter.encrypterOld((Context)hmsMessaging2.b, (String)(hmsMessaging2.b.getPackageName() + "#" + bl));
                string2 = new Intent("com.huawei.intent.action.SELF_SHOW_FLAG").putExtra("enalbeFlag", string2);
                string2.setPackage("android");
                return Tasks.callInBackground((Callable)new IntentCallable(hmsMessaging2.b, (Intent)string2, string));
            }
            HMSLog.i((String)"HmsMessaging", (String)"turn on/off with broadcast v2");
            new PushPreferences(hmsMessaging2.b, "push_notify_flag").saveBoolean("notify_msg_enable", bl ^ true);
            Uri uri = Uri.parse((String)("content://" + hmsMessaging2.b.getPackageName() + ".huawei.push.provider/" + "push_notify_flag" + ".xml"));
            Intent intent3 = intent2 = intent;
            intent3("com.huawei.android.push.intent.SDK_COMMAND");
            intent3.putExtra("type", "enalbeFlag");
            intent.putExtra("pkgName", hmsMessaging2.b.getPackageName());
            intent.putExtra("url", (Parcelable)uri);
            intent.setPackage("android");
            return Tasks.callInBackground((Callable)new IntentCallable(hmsMessaging2.b, intent2, string));
        }
        HMSLog.i((String)"HmsMessaging", (String)"turn on/off with AIDL");
        EnableNotifyReq enableNotifyReq2 = enableNotifyReq;
        enableNotifyReq2();
        enableNotifyReq2.setPackageName(hmsMessaging2.b.getPackageName());
        enableNotifyReq.setEnable(bl);
        return hmsMessaging2.c.doWrite((TaskApiCall)new BaseVoidTask("push.setNotifyFlag", JsonUtil.createJsonString((IMessageEntity)enableNotifyReq2), string));
    }

    public final void a(UpSendMsgReq upSendMsgReq, String string) {
        block4: {
            upSendMsgReq.setToken(BaseUtils.getLocalToken((Context)object.b, null));
            HuaweiApi<Api.ApiOptions.NoOptions> huaweiApi = object.c;
            try {
                huaweiApi.doWrite((TaskApiCall)new SendUpStreamTask("push.sendMessage", JsonUtil.createJsonString((IMessageEntity)upSendMsgReq), string, upSendMsgReq.getPackageName(), upSendMsgReq.getMessageId()));
            }
            catch (Exception exception) {
                Object object;
                if (exception.getCause() instanceof ApiException) {
                    HmsMessaging hmsMessaging = object;
                    object = (ApiException)exception.getCause();
                    int n2 = object.getStatusCode();
                    PushBiUtil.reportExit(hmsMessaging.b, "push.sendMessage", string, n2);
                    break block4;
                }
                object = ErrorEnum.ERROR_INTERNAL_ERROR;
                PushBiUtil.reportExit(object.b, "push.sendMessage", string, (ErrorEnum)object);
            }
        }
    }
}

