/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.persistence;

import com.google.android.datatransport.runtime.scheduling.persistence.EventStoreConfig;

final class AutoValue_EventStoreConfig
extends EventStoreConfig {
    private final long maxStorageSizeInBytes;
    private final int loadBatchSize;
    private final int criticalSectionEnterTimeoutMs;
    private final long eventCleanUpAge;
    private final int maxBlobByteSizePerRow;

    private AutoValue_EventStoreConfig(long maxStorageSizeInBytes, int loadBatchSize, int criticalSectionEnterTimeoutMs, long eventCleanUpAge, int maxBlobByteSizePerRow) {
        this.maxStorageSizeInBytes = maxStorageSizeInBytes;
        this.loadBatchSize = loadBatchSize;
        this.criticalSectionEnterTimeoutMs = criticalSectionEnterTimeoutMs;
        this.eventCleanUpAge = eventCleanUpAge;
        this.maxBlobByteSizePerRow = maxBlobByteSizePerRow;
    }

    @Override
    long getMaxStorageSizeInBytes() {
        return this.maxStorageSizeInBytes;
    }

    @Override
    int getLoadBatchSize() {
        return this.loadBatchSize;
    }

    @Override
    int getCriticalSectionEnterTimeoutMs() {
        return this.criticalSectionEnterTimeoutMs;
    }

    @Override
    long getEventCleanUpAge() {
        return this.eventCleanUpAge;
    }

    @Override
    int getMaxBlobByteSizePerRow() {
        return this.maxBlobByteSizePerRow;
    }

    public String toString() {
        return "EventStoreConfig{maxStorageSizeInBytes=" + this.maxStorageSizeInBytes + ", loadBatchSize=" + this.loadBatchSize + ", criticalSectionEnterTimeoutMs=" + this.criticalSectionEnterTimeoutMs + ", eventCleanUpAge=" + this.eventCleanUpAge + ", maxBlobByteSizePerRow=" + this.maxBlobByteSizePerRow + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EventStoreConfig) {
            EventStoreConfig that = (EventStoreConfig)o;
            return this.maxStorageSizeInBytes == that.getMaxStorageSizeInBytes() && this.loadBatchSize == that.getLoadBatchSize() && this.criticalSectionEnterTimeoutMs == that.getCriticalSectionEnterTimeoutMs() && this.eventCleanUpAge == that.getEventCleanUpAge() && this.maxBlobByteSizePerRow == that.getMaxBlobByteSizePerRow();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.maxStorageSizeInBytes >>> 32 ^ this.maxStorageSizeInBytes);
        h$ *= 1000003;
        h$ ^= this.loadBatchSize;
        h$ *= 1000003;
        h$ ^= this.criticalSectionEnterTimeoutMs;
        h$ *= 1000003;
        h$ ^= (int)(this.eventCleanUpAge >>> 32 ^ this.eventCleanUpAge);
        h$ *= 1000003;
        return h$ ^= this.maxBlobByteSizePerRow;
    }

    static final class Builder
    extends EventStoreConfig.Builder {
        private Long maxStorageSizeInBytes;
        private Integer loadBatchSize;
        private Integer criticalSectionEnterTimeoutMs;
        private Long eventCleanUpAge;
        private Integer maxBlobByteSizePerRow;

        Builder() {
        }

        @Override
        EventStoreConfig.Builder setMaxStorageSizeInBytes(long maxStorageSizeInBytes) {
            this.maxStorageSizeInBytes = maxStorageSizeInBytes;
            return this;
        }

        @Override
        EventStoreConfig.Builder setLoadBatchSize(int loadBatchSize) {
            this.loadBatchSize = loadBatchSize;
            return this;
        }

        @Override
        EventStoreConfig.Builder setCriticalSectionEnterTimeoutMs(int criticalSectionEnterTimeoutMs) {
            this.criticalSectionEnterTimeoutMs = criticalSectionEnterTimeoutMs;
            return this;
        }

        @Override
        EventStoreConfig.Builder setEventCleanUpAge(long eventCleanUpAge) {
            this.eventCleanUpAge = eventCleanUpAge;
            return this;
        }

        @Override
        EventStoreConfig.Builder setMaxBlobByteSizePerRow(int maxBlobByteSizePerRow) {
            this.maxBlobByteSizePerRow = maxBlobByteSizePerRow;
            return this;
        }

        @Override
        EventStoreConfig build() {
            String missing = "";
            if (this.maxStorageSizeInBytes == null) {
                missing = missing + " maxStorageSizeInBytes";
            }
            if (this.loadBatchSize == null) {
                missing = missing + " loadBatchSize";
            }
            if (this.criticalSectionEnterTimeoutMs == null) {
                missing = missing + " criticalSectionEnterTimeoutMs";
            }
            if (this.eventCleanUpAge == null) {
                missing = missing + " eventCleanUpAge";
            }
            if (this.maxBlobByteSizePerRow == null) {
                missing = missing + " maxBlobByteSizePerRow";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_EventStoreConfig(this.maxStorageSizeInBytes, this.loadBatchSize, this.criticalSectionEnterTimeoutMs, this.eventCleanUpAge, this.maxBlobByteSizePerRow);
        }
    }
}

