/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.platform.huawei.callback;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.engagelab.privates.common.api.MTCommonPrivatesApi;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.common.utils.SM4Util;
import com.engagelab.privates.push.api.CustomMessage;
import com.engagelab.privates.push.api.MTPushPrivatesApi;
import com.engagelab.privates.push.api.NotificationMessage;
import com.engagelab.privates.push.platform.huawei.business.MTHuaweiBusiness;
import com.engagelab.privates.push.utils.NotificationUtil;
import com.huawei.hms.push.HmsMessageService;
import com.huawei.hms.push.RemoteMessage;
import org.json.JSONObject;

public class MTHuaweiCallbackImp
extends HmsMessageService {
    private static final String TAG = "MTHuaweiCallbackImp";
    private Context mContext;

    public MTHuaweiCallbackImp(Service service) {
        this.mContext = service.getApplicationContext();
    }

    public void onNewToken(String token) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            MTCommonLog.d((String)TAG, (String)"onTokenFailed:onNewToken token is empty");
            MTHuaweiBusiness.getInstance().onNode(this.mContext, 3004, 0, 3900, 2);
            return;
        }
        MTCommonLog.d((String)TAG, (String)("onTokenSuccess:onNewToken token is " + token));
        MTHuaweiBusiness.getInstance().onToken(this.mContext, token, 2);
    }

    public void onNewToken(String token, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            MTCommonLog.d((String)TAG, (String)"onTokenFailed:onNewToken token is empty");
            MTHuaweiBusiness.getInstance().onNode(this.mContext, 3004, 0, 3900, 2);
            return;
        }
        MTCommonLog.d((String)TAG, (String)("onTokenSuccess:onNewToken token is " + token));
        MTHuaweiBusiness.getInstance().onToken(this.mContext, token, 2);
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        try {
            MTCommonLog.d((String)TAG, (String)("onMessageReceived - " + remoteMessage));
            this.onCustomMessageArrived(remoteMessage);
            this.onMessageForegroundUnShow(remoteMessage);
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("onMessage failed " + throwable.getMessage()));
        }
    }

    private void onCustomMessageArrived(RemoteMessage remoteMessage) {
        try {
            String data = remoteMessage.getData();
            String platformMessageId = remoteMessage.getMessageId();
            if (data == null) {
                return;
            }
            JSONObject jsonObject = new JSONObject(data);
            String message = null;
            message = jsonObject.has("JMessageExtra") ? jsonObject.getString("JMessageExtra") : jsonObject.getString("MTMessageExtra");
            if (message == null) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)(message = SM4Util.decodeMessage((String)message)))) {
                return;
            }
            MTPushPrivatesApi.init((Context)this.mContext);
            JSONObject messageJson = new JSONObject(message);
            MTCommonLog.d((String)TAG, (String)("onMessage:" + MTCommonLog.toLogString((JSONObject)messageJson)));
            String messageId = NotificationUtil.getMessageId((JSONObject)messageJson);
            String customTitle = messageJson.optString("title");
            String customContent = messageJson.optString("message");
            String customContentType = messageJson.optString("content_type");
            Bundle extras = NotificationUtil.convertJsonToBundle((JSONObject)messageJson.optJSONObject("extras"));
            CustomMessage customMessage = new CustomMessage().setMessageId(messageId).setPlatform((byte)2).setPlatformMessageId(platformMessageId).setTitle(customTitle).setContent(customContent).setContentType(customContentType).setExtras(extras);
            Bundle bundle = new Bundle();
            bundle.putParcelable("message", (Parcelable)customMessage);
            MTCommonPrivatesApi.sendMessageToMainProcess((Context)this.mContext, (int)3001, (Bundle)bundle);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void onMessageForegroundUnShow(RemoteMessage remoteMessage) {
        RemoteMessage.Notification notification = remoteMessage.getNotification();
        if (notification == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)notification.getIntentUri())) {
            return;
        }
        try {
            String intentUri = notification.getIntentUri();
            MTCommonLog.d((String)TAG, (String)("onMessageForegroundUnShow intentUri " + intentUri));
            Intent uriIntent = Intent.parseUri((String)intentUri, (int)0);
            Intent intent = new Intent(uriIntent);
            uriIntent.addCategory("android.intent.category.BROWSABLE");
            uriIntent.setComponent(null);
            if (Build.VERSION.SDK_INT >= 15) {
                uriIntent.setSelector(null);
            }
            String string = intent.getDataString();
            MTCommonLog.d((String)TAG, (String)("onMessageForegroundUnShow content " + string));
            if (TextUtils.isEmpty((CharSequence)string)) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)(string = SM4Util.decodeMessage((String)string)))) {
                return;
            }
            JSONObject object = new JSONObject(string);
            MTCommonLog.d((String)TAG, (String)("onMessageForegroundUnShow object " + object));
            String title = object.optString("n_title");
            String content = object.optString("n_content");
            Bundle extras = NotificationUtil.convertJsonToBundle((JSONObject)object.optJSONObject("n_extras"));
            String messageId = NotificationUtil.getMessageId((JSONObject)object);
            NotificationMessage notificationMessage = new NotificationMessage().setMessageId(messageId).setPlatform((byte)2).setPlatformMessageId(remoteMessage.getMessageId()).setNotificationId(notification.getNotifyId()).setDisplayForeground("0").setTitle(title).setContent(content).setExtras(extras);
            Bundle bundle = new Bundle();
            bundle.putParcelable("message", (Parcelable)notificationMessage);
            MTCommonLog.d((String)TAG, (String)("onMessageForegroundUnShow bundle " + bundle));
            MTPushPrivatesApi.init((Context)this.mContext);
            MTCommonPrivatesApi.sendMessageToMainProcess((Context)this.mContext, (int)3303, (Bundle)bundle);
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("onMessageForegroundUnShow throwable " + throwable));
        }
    }
}

