/*
 * Decompiled with CFR 0.152.
 */
package cn.engagelab.uniplugin_mtpush.receiver;

import android.content.Context;
import cn.engagelab.uniplugin_mtpush.MTPushModule;
import cn.engagelab.uniplugin_mtpush.common.MTLogger;
import cn.engagelab.uniplugin_mtpush.helper.MTPushHelper;
import com.alibaba.fastjson.JSONObject;
import com.engagelab.privates.common.component.MTCommonReceiver;
import com.engagelab.privates.core.api.WakeMessage;
import com.engagelab.privates.push.api.AliasMessage;
import com.engagelab.privates.push.api.CustomMessage;
import com.engagelab.privates.push.api.InAppMessage;
import com.engagelab.privates.push.api.MobileNumberMessage;
import com.engagelab.privates.push.api.NotificationMessage;
import com.engagelab.privates.push.api.PlatformTokenMessage;
import com.engagelab.privates.push.api.TagMessage;

public class MTPushModuleReceiver
extends MTCommonReceiver {
    public void onNotificationStatus(Context context, boolean enable) {
        MTLogger.d("onNotificationStatus:" + enable);
    }

    public void onConnectStatus(Context context, boolean state) {
        MTLogger.d("onConnectStatus state:" + state);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("connectEnable", (Object)state);
        MTPushHelper.sendEvent("ConnectEvent", jsonObject);
    }

    public void onNotificationArrived(Context context, NotificationMessage notificationMessage) {
        MTLogger.d("onNotificationArrived:" + notificationMessage.toString());
        JSONObject jsonObject = MTPushHelper.convertNotificationToMap("notificationArrived", notificationMessage);
        MTPushHelper.sendNotifactionEvent(jsonObject, 0);
    }

    public void onNotificationClicked(Context context, NotificationMessage notificationMessage) {
        MTLogger.d("onNotificationClicked:" + notificationMessage.toString());
        if (!MTPushModule.isAppForeground) {
            MTPushHelper.launchApp(context);
        }
        JSONObject jsonObject = MTPushHelper.convertNotificationToMap("notificationOpened", notificationMessage);
        MTPushHelper.sendNotifactionEvent(jsonObject, 0);
        MTPushHelper.saveOpenNotifiData(jsonObject, 0);
    }

    public void onNotificationDeleted(Context context, NotificationMessage notificationMessage) {
        MTLogger.d("onNotificationDeleted:");
    }

    public void onCustomMessage(Context context, CustomMessage customMessage) {
        MTLogger.d("onCustomMessage:" + customMessage.toString());
        JSONObject jsonObject = MTPushHelper.convertCustomMessage(customMessage);
        MTPushHelper.sendEvent("CustomMessageEvent", jsonObject);
    }

    public void onInAppMessageShow(Context context, InAppMessage inAppMessage) {
        MTLogger.d("onInAppMessageShow:" + inAppMessage.toString());
        JSONObject jsonObject = MTPushHelper.convertInappMessage("show", inAppMessage);
        MTPushHelper.sendEvent("InappMessageEvent", jsonObject);
    }

    public void onInAppMessageClick(Context context, InAppMessage inAppMessage) {
        MTLogger.d("onInAppMessageClick:" + inAppMessage.toString());
        JSONObject jsonObject = MTPushHelper.convertInappMessage("click", inAppMessage);
        MTPushHelper.sendEvent("InappMessageEvent", jsonObject);
    }

    public void onPlatformToken(Context context, PlatformTokenMessage platformMessage) {
        MTLogger.d("onPlatformToken:" + platformMessage.toString());
    }

    public void onTagMessage(Context context, TagMessage tagMessage) {
        MTLogger.d("onTagMessage:" + tagMessage.toString());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)tagMessage.getCode());
        jsonObject.put("tag", (Object)tagMessage.getTags());
        jsonObject.put("sequence", (Object)tagMessage.getSequence());
        MTPushHelper.sendEvent("TagAliasEvent", jsonObject);
    }

    public void onAliasMessage(Context context, AliasMessage aliasMessage) {
        MTLogger.d("onAliasMessage:" + aliasMessage.toString());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)aliasMessage.getCode());
        jsonObject.put("alias", (Object)aliasMessage.getAlias());
        jsonObject.put("sequence", (Object)aliasMessage.getSequence());
        MTPushHelper.sendEvent("TagAliasEvent", jsonObject);
    }

    public void onMobileNumber(Context context, MobileNumberMessage mobileNumberMessage) {
        MTLogger.d("onMobileNumber:" + mobileNumberMessage.toString());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)mobileNumberMessage.getCode());
        jsonObject.put("sequence", (Object)mobileNumberMessage.getSequence());
        MTPushHelper.sendEvent("MobileNumberEvent", jsonObject);
    }

    public void onWake(Context context, WakeMessage wakeMessage) {
        MTLogger.d("onWake:" + wakeMessage.toString());
    }
}

