/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.proto;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.FieldDescriptor;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.ValueEncoder;
import com.google.firebase.encoders.proto.AtProtobuf;
import com.google.firebase.encoders.proto.LengthCountingOutputStream;
import com.google.firebase.encoders.proto.ProtoEnum;
import com.google.firebase.encoders.proto.Protobuf;
import com.google.firebase.encoders.proto.ProtobufValueEncoderContext;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;

final class ProtobufDataEncoderContext
implements ObjectEncoderContext {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private OutputStream output;
    private final Map<Class<?>, ObjectEncoder<?>> objectEncoders;
    private final Map<Class<?>, ValueEncoder<?>> valueEncoders;
    private final ObjectEncoder<Object> fallbackEncoder;
    private final ProtobufValueEncoderContext valueEncoderContext = new ProtobufValueEncoderContext(this);
    private static final FieldDescriptor MAP_KEY_DESC = FieldDescriptor.builder((String)"key").withProperty((Annotation)AtProtobuf.builder().tag(1).build()).build();
    private static final FieldDescriptor MAP_VALUE_DESC = FieldDescriptor.builder((String)"value").withProperty((Annotation)AtProtobuf.builder().tag(2).build()).build();
    private static final ObjectEncoder<Map.Entry<Object, Object>> DEFAULT_MAP_ENCODER = (o, ctx) -> {
        ctx.add(MAP_KEY_DESC, o.getKey());
        ctx.add(MAP_VALUE_DESC, o.getValue());
    };

    ProtobufDataEncoderContext(OutputStream output, Map<Class<?>, ObjectEncoder<?>> objectEncoders, Map<Class<?>, ValueEncoder<?>> valueEncoders, ObjectEncoder<Object> fallbackEncoder) {
        this.output = output;
        this.objectEncoders = objectEncoders;
        this.valueEncoders = valueEncoders;
        this.fallbackEncoder = fallbackEncoder;
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull String name, @Nullable Object obj) throws IOException {
        return this.add(FieldDescriptor.of((String)name), obj);
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull String name, double value) throws IOException {
        return this.add(FieldDescriptor.of((String)name), value);
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull String name, int value) throws IOException {
        return this.add(FieldDescriptor.of((String)name), value);
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull String name, long value) throws IOException {
        return this.add(FieldDescriptor.of((String)name), value);
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull String name, boolean value) throws IOException {
        return this.add(FieldDescriptor.of((String)name), value);
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull FieldDescriptor field, @Nullable Object obj) throws IOException {
        return this.add(field, obj, true);
    }

    ObjectEncoderContext add(@NonNull FieldDescriptor field, @Nullable Object obj, boolean skipDefault) throws IOException {
        if (obj == null) {
            return this;
        }
        if (obj instanceof CharSequence) {
            CharSequence seq = (CharSequence)obj;
            if (skipDefault && seq.length() == 0) {
                return this;
            }
            int tag = ProtobufDataEncoderContext.getTag(field);
            int wire = 2;
            this.writeVarInt32(tag << 3 | wire);
            byte[] bytes = seq.toString().getBytes(UTF_8);
            this.writeVarInt32(bytes.length);
            this.output.write(bytes);
            return this;
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            for (Object value : collection) {
                this.add(field, value, false);
            }
            return this;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                this.doEncode(DEFAULT_MAP_ENCODER, field, entry, false);
            }
            return this;
        }
        if (obj instanceof Double) {
            return this.add(field, (Double)obj, skipDefault);
        }
        if (obj instanceof Float) {
            return this.add(field, ((Float)obj).floatValue(), skipDefault);
        }
        if (obj instanceof Number) {
            return this.add(field, ((Number)obj).longValue(), skipDefault);
        }
        if (obj instanceof Boolean) {
            return this.add(field, (Boolean)obj, skipDefault);
        }
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            if (skipDefault && bytes.length == 0) {
                return this;
            }
            int tag = ProtobufDataEncoderContext.getTag(field);
            int wire = 2;
            this.writeVarInt32(tag << 3 | wire);
            this.writeVarInt32(bytes.length);
            this.output.write(bytes);
            return this;
        }
        ObjectEncoder<?> objectEncoder = this.objectEncoders.get(obj.getClass());
        if (objectEncoder != null) {
            return this.doEncode(objectEncoder, field, obj, skipDefault);
        }
        ValueEncoder<?> valueEncoder = this.valueEncoders.get(obj.getClass());
        if (valueEncoder != null) {
            return this.doEncode(valueEncoder, field, obj, skipDefault);
        }
        if (obj instanceof ProtoEnum) {
            return this.add(field, ((ProtoEnum)obj).getNumber());
        }
        if (obj instanceof Enum) {
            return this.add(field, ((Enum)obj).ordinal());
        }
        return this.doEncode(this.fallbackEncoder, field, obj, skipDefault);
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull FieldDescriptor field, double value) throws IOException {
        return this.add(field, value, true);
    }

    ObjectEncoderContext add(@NonNull FieldDescriptor field, double value, boolean skipDefault) throws IOException {
        if (skipDefault && value == 0.0) {
            return this;
        }
        int tag = ProtobufDataEncoderContext.getTag(field);
        int wire = 1;
        this.writeVarInt32(tag << 3 | wire);
        this.output.write(ProtobufDataEncoderContext.allocateBuffer(8).putDouble(value).array());
        return this;
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull FieldDescriptor field, float value) throws IOException {
        return this.add(field, value, true);
    }

    ObjectEncoderContext add(@NonNull FieldDescriptor field, float value, boolean skipDefault) throws IOException {
        if (skipDefault && value == 0.0f) {
            return this;
        }
        int tag = ProtobufDataEncoderContext.getTag(field);
        int wire = 5;
        this.writeVarInt32(tag << 3 | wire);
        this.output.write(ProtobufDataEncoderContext.allocateBuffer(4).putFloat(value).array());
        return this;
    }

    @NonNull
    public ProtobufDataEncoderContext add(@NonNull FieldDescriptor field, int value) throws IOException {
        return this.add(field, value, true);
    }

    ProtobufDataEncoderContext add(@NonNull FieldDescriptor field, int value, boolean skipDefault) throws IOException {
        if (skipDefault && value == 0) {
            return this;
        }
        Protobuf protobuf = ProtobufDataEncoderContext.getProtobuf(field);
        switch (protobuf.intEncoding()) {
            case DEFAULT: {
                this.writeVarInt32(protobuf.tag() << 3);
                this.writeVarInt32(value);
                break;
            }
            case SIGNED: {
                this.writeVarInt32(protobuf.tag() << 3);
                this.writeVarInt32(value << 1 ^ value >> 31);
                break;
            }
            case FIXED: {
                this.writeVarInt32(protobuf.tag() << 3 | 5);
                this.output.write(ProtobufDataEncoderContext.allocateBuffer(4).putInt(value).array());
            }
        }
        return this;
    }

    @NonNull
    public ProtobufDataEncoderContext add(@NonNull FieldDescriptor field, long value) throws IOException {
        return this.add(field, value, true);
    }

    ProtobufDataEncoderContext add(@NonNull FieldDescriptor field, long value, boolean skipDefault) throws IOException {
        if (skipDefault && value == 0L) {
            return this;
        }
        Protobuf protobuf = ProtobufDataEncoderContext.getProtobuf(field);
        switch (protobuf.intEncoding()) {
            case DEFAULT: {
                this.writeVarInt32(protobuf.tag() << 3);
                this.writeVarInt64(value);
                break;
            }
            case SIGNED: {
                this.writeVarInt32(protobuf.tag() << 3);
                this.writeVarInt64(value << 1 ^ value >> 63);
                break;
            }
            case FIXED: {
                this.writeVarInt32(protobuf.tag() << 3 | 1);
                this.output.write(ProtobufDataEncoderContext.allocateBuffer(8).putLong(value).array());
            }
        }
        return this;
    }

    @NonNull
    public ProtobufDataEncoderContext add(@NonNull FieldDescriptor field, boolean value) throws IOException {
        return this.add(field, value, true);
    }

    ProtobufDataEncoderContext add(@NonNull FieldDescriptor field, boolean value, boolean skipDefault) throws IOException {
        return this.add(field, value ? 1 : 0, skipDefault);
    }

    @NonNull
    public ObjectEncoderContext inline(@Nullable Object value) throws IOException {
        return this.encode(value);
    }

    ProtobufDataEncoderContext encode(@Nullable Object value) throws IOException {
        if (value == null) {
            return this;
        }
        ObjectEncoder<?> objectEncoder = this.objectEncoders.get(value.getClass());
        if (objectEncoder != null) {
            objectEncoder.encode(value, (Object)this);
            return this;
        }
        throw new EncodingException("No encoder for " + value.getClass());
    }

    @NonNull
    public ObjectEncoderContext nested(@NonNull String name) throws IOException {
        return this.nested(FieldDescriptor.of((String)name));
    }

    @NonNull
    public ObjectEncoderContext nested(@NonNull FieldDescriptor field) throws IOException {
        throw new EncodingException("nested() is not implemented for protobuf encoding.");
    }

    private <T> ProtobufDataEncoderContext doEncode(ObjectEncoder<T> encoder, FieldDescriptor field, T obj, boolean skipDefault) throws IOException {
        long size = this.determineSize(encoder, obj);
        if (skipDefault && size == 0L) {
            return this;
        }
        int tag = ProtobufDataEncoderContext.getTag(field);
        int wire = 2;
        this.writeVarInt32(tag << 3 | wire);
        this.writeVarInt64(size);
        encoder.encode(obj, (Object)this);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> long determineSize(ObjectEncoder<T> encoder, T obj) throws IOException {
        try (LengthCountingOutputStream out = new LengthCountingOutputStream();){
            OutputStream originalStream = this.output;
            this.output = out;
            try {
                encoder.encode(obj, (Object)this);
            }
            finally {
                this.output = originalStream;
            }
            long l = out.getLength();
            return l;
        }
    }

    private <T> ProtobufDataEncoderContext doEncode(ValueEncoder<T> encoder, FieldDescriptor field, T obj, boolean skipDefault) throws IOException {
        this.valueEncoderContext.resetContext(field, skipDefault);
        encoder.encode(obj, (Object)this.valueEncoderContext);
        return this;
    }

    private static ByteBuffer allocateBuffer(int length) {
        return ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN);
    }

    private static int getTag(FieldDescriptor field) {
        Protobuf protobuf = (Protobuf)field.getProperty(Protobuf.class);
        if (protobuf == null) {
            throw new EncodingException("Field has no @Protobuf config");
        }
        return protobuf.tag();
    }

    private static Protobuf getProtobuf(FieldDescriptor field) {
        Protobuf protobuf = (Protobuf)field.getProperty(Protobuf.class);
        if (protobuf == null) {
            throw new EncodingException("Field has no @Protobuf config");
        }
        return protobuf;
    }

    private void writeVarInt32(int value) throws IOException {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            this.output.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.output.write(value & 0x7F);
    }

    private void writeVarInt64(long value) throws IOException {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.output.write((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.output.write((int)value & 0x7F);
    }
}

