/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.oth.sound.business;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.push.oth.sound.business.SoundJson;
import com.engagelab.privates.push.oth.sound.business.SoundMessageJson;
import com.engagelab.privates.push.oth.sound.cache.OTHSoundConfig;
import com.engagelab.privates.push.oth.sound.util.SoundPlayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

public class OTHPlayBusiness {
    private static final String TAG = "OTHPlayBusiness";

    public static void onMessage(Context context, Bundle bundle) {
        block12: {
            try {
                boolean enableSound = OTHSoundConfig.getEnablePushTextToSpeech(context);
                if (!enableSound) {
                    MTCommonLog.d((String)TAG, (String)("enableSound:" + enableSound));
                    return;
                }
                String message = bundle.getString("message");
                if (TextUtils.isEmpty((CharSequence)message)) {
                    return;
                }
                MTCommonLog.debugOnly((String)TAG, (String)("onMessage message:" + message));
                try {
                    SoundMessageJson soundMessageJson = SoundMessageJson.fromJson(message);
                    if (soundMessageJson == null) {
                        MTCommonLog.debugOnly((String)TAG, (String)("onMessage failed, message:" + message));
                        return;
                    }
                    MTCommonLog.debugOnly((String)TAG, (String)("onMessage soundMessageJson:" + soundMessageJson));
                    if (!soundMessageJson.valid()) break block12;
                    ArrayList<String> soundFiles = new ArrayList<String>();
                    String lan = soundMessageJson.getnLan();
                    List<String> soundFileNames = soundMessageJson.getnSpeechOrder();
                    String responseBody = OTHSoundConfig.getResponseBody(context, lan);
                    try {
                        SoundJson soundJson = SoundJson.fromJson(responseBody);
                        if (soundJson.valid()) {
                            String pathUnZip = soundJson.getContent().getPathUnZip(context);
                            for (int i = 0; i < soundFileNames.size(); ++i) {
                                File file = new File(pathUnZip, soundFileNames.get(i));
                                if (!file.exists() || !file.isFile()) {
                                    MTCommonLog.d((String)TAG, (String)("soundFile no has:" + file.getAbsolutePath()));
                                    return;
                                }
                                soundFiles.add(file.getAbsolutePath());
                            }
                            SoundPlayUtil.startPlay(soundFiles);
                        }
                    }
                    catch (JSONException e) {
                        MTCommonLog.d((String)TAG, (String)("responseBody:" + responseBody + ",e:" + (Object)((Object)e)));
                    }
                }
                catch (JSONException e) {
                    MTCommonLog.d((String)TAG, (String)("message:" + message + ",e:" + (Object)((Object)e)));
                }
            }
            catch (Exception e) {
                MTCommonLog.d((String)TAG, (String)("onMessage: fail:,e:" + e));
            }
        }
    }
}

