/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import com.huawei.hms.framework.common.ThreadPoolExcutorEnhance;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ExecutorsEnhance {
    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExcutorEnhance(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory));
    }

    private static class DelegatedExecutorService
    extends AbstractExecutorService {
        private final ExecutorService executorService;

        DelegatedExecutorService(ExecutorService executor) {
            this.executorService = executor;
        }

        @Override
        public void execute(Runnable command) {
            this.executorService.execute(command);
        }

        @Override
        public void shutdown() {
            this.executorService.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.executorService.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.executorService.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.executorService.isTerminated();
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.executorService.submit(task, result);
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.executorService.awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.executorService.submit(task);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.executorService.submit(task);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.executorService.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.executorService.invokeAll(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.executorService.invokeAny(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.executorService.invokeAny(tasks);
        }
    }

    private static class FinalizableDelegatedExecutorService
    extends DelegatedExecutorService {
        FinalizableDelegatedExecutorService(ExecutorService executor) {
            super(executor);
        }

        protected void finalize() {
            super.shutdown();
        }
    }
}

