/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.UserManager;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthNr;
import android.telephony.CellSignalStrengthTdscdma;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.HwTelephonyManager;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.huawei.android.os.BuildEx;
import com.huawei.android.telephony.ServiceStateEx;
import com.huawei.hms.framework.common.ActivityUtil;
import com.huawei.hms.framework.common.ContextCompat;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NetworkUtil {
    private static final String TAG = NetworkUtil.class.getSimpleName();
    private static final int TYPE_WIFI_P2P = 13;
    private static final int INVALID_RSSI = -127;
    private static final String STR_NSA = "5G_NSA";
    private static final String STR_SA = "5G_SA";
    public static final int UNAVAILABLE = Integer.MAX_VALUE;

    @SuppressLint(value={"MissingPermission"})
    public static NetworkInfo getNetworkInfo(Context context) {
        if (ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo netInfo = null;
            ConnectivityManager manager = (ConnectivityManager)ContextCompat.getSystemService(context, "connectivity");
            if (null != manager) {
                try {
                    netInfo = manager.getActiveNetworkInfo();
                }
                catch (RuntimeException e) {
                    Logger.i((String)TAG, (Object)("getActiveNetworkInfo failed, exception:" + e.getClass().getSimpleName() + e.getMessage()));
                }
            }
            return netInfo;
        }
        return null;
    }

    public static boolean isNetworkAvailable(Context context) {
        if (ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo info = NetworkUtil.getNetworkInfo(context);
            return info != null && info.isConnected();
        }
        return true;
    }

    public static int netWork(Context context) {
        int newWorkType = NetworkUtil.getNetworkType(context);
        Logger.v((String)TAG, (Object)("newWorkType " + newWorkType));
        if (newWorkType == 4) {
            if (TextUtils.equals((CharSequence)STR_NSA, (CharSequence)NetworkUtil.getNetWorkNSAorSA())) {
                return 7;
            }
            return newWorkType;
        }
        if (newWorkType == 5) {
            if (TextUtils.equals((CharSequence)STR_SA, (CharSequence)NetworkUtil.getNetWorkNSAorSA())) {
                return 8;
            }
            return newWorkType;
        }
        return newWorkType;
    }

    public static String getNetWorkNSAorSA() {
        String netType = null;
        try {
            HwTelephonyManager hwTelephonyManager = HwTelephonyManager.getDefault();
            int phoneId = hwTelephonyManager.getDefault4GSlotId();
            Logger.v((String)TAG, (Object)("phoneId " + phoneId));
            boolean isNsa = hwTelephonyManager.isNsaState(phoneId);
            Logger.v((String)TAG, (Object)("isNsa " + isNsa));
            netType = isNsa ? STR_NSA : STR_SA;
        }
        catch (Throwable e) {
            Logger.v((String)TAG, (Object)"isNsaState error");
        }
        return netType;
    }

    public static int getNetworkType(Context context) {
        int psType = 0;
        if (context != null) {
            NetworkInfo netInfo = NetworkUtil.getNetworkInfo(context);
            psType = NetworkUtil.getNetworkType(netInfo, context);
        }
        return psType;
    }

    @SuppressLint(value={"MissingPermission", "NewApi"})
    private static int getHwNetworkType(Context context) {
        TelephonyManager telephonyManager;
        int networkType = 0;
        if (!ReflectionUtils.checkCompatible((String)"com.huawei.android.os.BuildEx$VERSION")) {
            return networkType;
        }
        if (context != null && (telephonyManager = (TelephonyManager)ContextCompat.getSystemService(context, "phone")) != null) {
            try {
                ServiceState serviceState;
                if (BuildEx.VERSION.EMUI_SDK_INT >= 21 && (serviceState = telephonyManager.getServiceState()) != null) {
                    networkType = ServiceStateEx.getConfigRadioTechnology((ServiceState)serviceState);
                }
            }
            catch (SecurityException e) {
                Logger.w((String)TAG, (Object)"requires permission maybe missing.");
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Logger.w((String)TAG, (Object)"NoSuchMethodError occur in method getHwNetworkType.");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Logger.w((String)TAG, (Object)"NoClassDefFoundError occur in method getHwNetworkType.");
            }
        }
        return networkType;
    }

    public static int getNetworkType(NetworkInfo netInfo, Context context) {
        int psType = -1;
        if (netInfo != null && netInfo.isConnected()) {
            int type = netInfo.getType();
            if (1 == type || 13 == type) {
                psType = 1;
            } else if (0 == type) {
                int subtype = NetworkUtil.getHwNetworkType(context);
                Logger.v((String)TAG, (Object)("getHwNetworkType return is: " + subtype));
                if (subtype == 0) {
                    subtype = netInfo.getSubtype();
                }
                switch (subtype) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        psType = 2;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        psType = 3;
                        break;
                    }
                    case 13: {
                        psType = 4;
                        break;
                    }
                    case 20: {
                        psType = 5;
                        break;
                    }
                    default: {
                        psType = 0;
                    }
                }
                if (psType == 0 && Build.VERSION.SDK_INT >= 25) {
                    switch (subtype) {
                        case 16: {
                            psType = 2;
                            break;
                        }
                        case 17: {
                            psType = 3;
                            break;
                        }
                        default: {
                            psType = 0;
                        }
                    }
                }
            } else {
                psType = 0;
            }
        }
        return psType;
    }

    public static int getNetworkType(NetworkInfo netInfo) {
        return NetworkUtil.getNetworkType(netInfo, null);
    }

    @SuppressLint(value={"MissingPermission"})
    private static String[] getDnsServerIpsFromConnectionManager(Context context) {
        ConnectivityManager connectivityManager;
        LinkedList<String> dnsServers = new LinkedList<String>();
        if (Build.VERSION.SDK_INT >= 21 && context != null && (connectivityManager = (ConnectivityManager)ContextCompat.getSystemService(context, "connectivity")) != null) {
            try {
                NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
                if (activeNetworkInfo != null) {
                    Network[] networks;
                    for (Network network : networks = connectivityManager.getAllNetworks()) {
                        LinkProperties linkProperties;
                        if (network == null) continue;
                        NetworkInfo networkInfo = null;
                        networkInfo = connectivityManager.getNetworkInfo(network);
                        if (networkInfo == null || networkInfo.getType() != activeNetworkInfo.getType() || (linkProperties = connectivityManager.getLinkProperties(network)) == null) continue;
                        for (InetAddress addr : linkProperties.getDnsServers()) {
                            dnsServers.add(addr.getHostAddress());
                        }
                    }
                }
            }
            catch (SecurityException se) {
                Logger.i((String)TAG, (Object)("getActiveNetworkInfo failed, exception:" + se.getClass().getSimpleName()));
            }
            catch (RuntimeException re) {
                Logger.i((String)TAG, (Object)("getActiveNetworkInfo failed, exception:" + re.getClass().getSimpleName()));
            }
        }
        return dnsServers.isEmpty() ? new String[]{} : dnsServers.toArray(new String[dnsServers.size()]);
    }

    public static String getDnsServerIps(Context context) {
        Object[] dnsServers = NetworkUtil.getDnsServerIpsFromConnectionManager(context);
        return Arrays.toString(dnsServers);
    }

    public static int getMobileRsrp(Context context) {
        int rsrp = Integer.MAX_VALUE;
        SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
        if (signalStrength == null) {
            return rsrp;
        }
        try {
            if (Build.VERSION.SDK_INT > 28) {
                return NetworkUtil.getMobileSingalStrengthUpPPlatfrom(context);
            }
            return NetworkUtil.getInfoWithReflect(signalStrength, "getDbm");
        }
        catch (Throwable throwable) {
            Logger.i((String)TAG, (Object)("getDbm: throwable:" + throwable.getClass()));
            return rsrp;
        }
    }

    public static int getLteRsrq(Context context) {
        int rsrq;
        block5: {
            rsrq = Integer.MAX_VALUE;
            SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
            if (signalStrength == null) {
                return rsrq;
            }
            try {
                if (Build.VERSION.SDK_INT > 28) {
                    List cellSignalStrengthLtes = signalStrength.getCellSignalStrengths(CellSignalStrengthLte.class);
                    if (cellSignalStrengthLtes.size() > 0) {
                        return ((CellSignalStrengthLte)cellSignalStrengthLtes.get(0)).getRsrq();
                    }
                    break block5;
                }
                return NetworkUtil.getInfoWithReflect(signalStrength, "getLteRsrq");
            }
            catch (Throwable throwable) {
                Logger.i((String)TAG, (Object)("getLteRsrq: throwable:" + throwable.getClass()));
            }
        }
        return rsrq;
    }

    public static int getLteRssnr(Context context) {
        int rssnr;
        block5: {
            rssnr = Integer.MAX_VALUE;
            SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
            if (signalStrength == null) {
                return rssnr;
            }
            try {
                if (Build.VERSION.SDK_INT > 28) {
                    List cellSignalStrengthLtes = signalStrength.getCellSignalStrengths(CellSignalStrengthLte.class);
                    if (cellSignalStrengthLtes.size() > 0) {
                        return ((CellSignalStrengthLte)cellSignalStrengthLtes.get(0)).getRssnr();
                    }
                    break block5;
                }
                return NetworkUtil.getInfoWithReflect(signalStrength, "getLteRssnr");
            }
            catch (Throwable throwable) {
                Logger.i((String)TAG, (Object)("getLteRssnr: throwable:" + throwable.getClass()));
            }
        }
        return rssnr;
    }

    public static int getLteRsrp(Context context) {
        int rsrp;
        block5: {
            rsrp = Integer.MAX_VALUE;
            SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
            if (signalStrength == null) {
                return rsrp;
            }
            try {
                if (Build.VERSION.SDK_INT > 28) {
                    List cellSignalStrengthLtes = signalStrength.getCellSignalStrengths(CellSignalStrengthLte.class);
                    if (cellSignalStrengthLtes.size() > 0) {
                        return ((CellSignalStrengthLte)cellSignalStrengthLtes.get(0)).getRsrp();
                    }
                    break block5;
                }
                return NetworkUtil.getInfoWithReflect(signalStrength, "getLteRsrp");
            }
            catch (Throwable throwable) {
                Logger.i((String)TAG, (Object)("getLteRsrp: throwable:" + throwable.getClass()));
            }
        }
        return rsrp;
    }

    public static int getLteCqi(Context context) {
        int cqi;
        block5: {
            cqi = Integer.MAX_VALUE;
            SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
            if (signalStrength == null) {
                return cqi;
            }
            try {
                if (Build.VERSION.SDK_INT > 28) {
                    List cellSignalStrengthLtes = signalStrength.getCellSignalStrengths(CellSignalStrengthLte.class);
                    if (cellSignalStrengthLtes.size() > 0) {
                        return ((CellSignalStrengthLte)cellSignalStrengthLtes.get(0)).getCqi();
                    }
                    break block5;
                }
                return NetworkUtil.getInfoWithReflect(signalStrength, "getLteCqi");
            }
            catch (Throwable throwable) {
                Logger.i((String)TAG, (Object)("getLteCqi: throwable:" + throwable.getClass()));
            }
        }
        return cqi;
    }

    public static int getLteRssi(Context context) {
        int rssi = Integer.MAX_VALUE;
        SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
        if (signalStrength == null) {
            return rssi;
        }
        try {
            List cellSignalStrengthLtes;
            if (Build.VERSION.SDK_INT > 28 && (cellSignalStrengthLtes = signalStrength.getCellSignalStrengths(CellSignalStrengthLte.class)).size() > 0) {
                return ((CellSignalStrengthLte)cellSignalStrengthLtes.get(0)).getRssi();
            }
        }
        catch (Throwable throwable) {
            Logger.i((String)TAG, (Object)("getLteRssi: throwable:" + throwable.getClass()));
        }
        return rssi;
    }

    public static int getInfoWithReflect(SignalStrength signalStrength, String name) {
        try {
            if (Build.VERSION.SDK_INT <= 28) {
                final Method method = SignalStrength.class.getDeclaredMethod(name, new Class[0]);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        method.setAccessible(true);
                        return null;
                    }
                });
                return (Integer)method.invoke((Object)signalStrength, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
            Logger.i((String)TAG, (Object)(name + " : function not found"));
        }
        catch (IllegalAccessException e) {
            Logger.i((String)TAG, (Object)(name + " : cannot access"));
        }
        catch (InvocationTargetException e) {
            Logger.i((String)TAG, (Object)(name + " : InvocationTargetException"));
        }
        catch (Throwable e) {
            Logger.i((String)TAG, (Object)(name + " : throwable:" + e.getClass()));
        }
        return Integer.MAX_VALUE;
    }

    public static Map<String, Integer> getLteSignalInfo(Context context) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
        if (signalStrength == null) {
            return map;
        }
        try {
            if (Build.VERSION.SDK_INT > 28) {
                List cellSignalStrengthLtes = signalStrength.getCellSignalStrengths(CellSignalStrengthLte.class);
                if (cellSignalStrengthLtes.size() > 0) {
                    map.put("lteDbm", ((CellSignalStrengthLte)cellSignalStrengthLtes.get(0)).getDbm());
                    map.put("lteRsrp", ((CellSignalStrengthLte)cellSignalStrengthLtes.get(0)).getRsrp());
                    map.put("lteRsrq", ((CellSignalStrengthLte)cellSignalStrengthLtes.get(0)).getRsrq());
                    map.put("lteRssnr", ((CellSignalStrengthLte)cellSignalStrengthLtes.get(0)).getRssnr());
                    map.put("lteCqi", ((CellSignalStrengthLte)cellSignalStrengthLtes.get(0)).getCqi());
                    map.put("lteRssi", ((CellSignalStrengthLte)cellSignalStrengthLtes.get(0)).getRssi());
                }
            } else {
                map.put("lteDbm", NetworkUtil.getInfoWithReflect(signalStrength, "getDbm"));
                map.put("lteRsrp", NetworkUtil.getInfoWithReflect(signalStrength, "getLteRsrp"));
                map.put("lteRsrq", NetworkUtil.getInfoWithReflect(signalStrength, "getLteRsrq"));
                map.put("lteRssnr", NetworkUtil.getInfoWithReflect(signalStrength, "getLteRssnr"));
                map.put("lteCqi", NetworkUtil.getInfoWithReflect(signalStrength, "getLteCqi"));
            }
        }
        catch (Throwable throwable) {
            Logger.i((String)TAG, (Object)("getLteRssi: throwable:" + throwable.getClass()));
        }
        return map;
    }

    public static Map<String, Integer> getNrSignalInfo(Context context) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
        if (signalStrength == null) {
            return map;
        }
        try {
            List cellSignalStrengthNrs;
            if (Build.VERSION.SDK_INT > 28 && (cellSignalStrengthNrs = signalStrength.getCellSignalStrengths(CellSignalStrengthNr.class)).size() > 0) {
                map.put("nrDbm", ((CellSignalStrengthNr)cellSignalStrengthNrs.get(0)).getDbm());
                map.put("nrCSIRsrp", ((CellSignalStrengthNr)cellSignalStrengthNrs.get(0)).getCsiRsrp());
                map.put("nrCSIRsrq", ((CellSignalStrengthNr)cellSignalStrengthNrs.get(0)).getCsiRsrq());
                map.put("nrCSISinr", ((CellSignalStrengthNr)cellSignalStrengthNrs.get(0)).getCsiSinr());
                map.put("nrSSRsrp", ((CellSignalStrengthNr)cellSignalStrengthNrs.get(0)).getSsRsrp());
                map.put("nrSSRsrq", ((CellSignalStrengthNr)cellSignalStrengthNrs.get(0)).getSsRsrq());
                map.put("nrSSSinr", ((CellSignalStrengthNr)cellSignalStrengthNrs.get(0)).getSsSinr());
            }
        }
        catch (Throwable throwable) {
            Logger.i((String)TAG, (Object)("getLteRssi: throwable:" + throwable.getClass()));
        }
        return map;
    }

    public static int getNrSsRsrp(Context context) {
        int ssRsrp = Integer.MAX_VALUE;
        try {
            if (Build.VERSION.SDK_INT > 28) {
                SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
                if (signalStrength == null) {
                    return ssRsrp;
                }
                List cellSignalStrengthLtes = signalStrength.getCellSignalStrengths(CellSignalStrengthNr.class);
                if (cellSignalStrengthLtes.size() > 0) {
                    return ((CellSignalStrengthNr)cellSignalStrengthLtes.get(0)).getSsRsrp();
                }
            }
        }
        catch (Throwable throwable) {
            Logger.i((String)TAG, (Object)("getNrSsRsrp: throwable:" + throwable.getClass()));
        }
        return ssRsrp;
    }

    public static int getNrCsiRsrp(Context context) {
        int csiRsrp = Integer.MAX_VALUE;
        try {
            if (Build.VERSION.SDK_INT > 28) {
                SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
                if (signalStrength == null) {
                    return csiRsrp;
                }
                List cellSignalStrengthLtes = signalStrength.getCellSignalStrengths(CellSignalStrengthNr.class);
                if (cellSignalStrengthLtes.size() > 0) {
                    return ((CellSignalStrengthNr)cellSignalStrengthLtes.get(0)).getCsiRsrp();
                }
            }
        }
        catch (Throwable throwable) {
            Logger.i((String)TAG, (Object)("getNrCsiRsrp: throwable:" + throwable.getClass()));
        }
        return csiRsrp;
    }

    public static int getNrSsRsrq(Context context) {
        int ssRsrq = Integer.MAX_VALUE;
        try {
            if (Build.VERSION.SDK_INT > 28) {
                SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
                if (signalStrength == null) {
                    return ssRsrq;
                }
                List cellSignalStrengthLtes = signalStrength.getCellSignalStrengths(CellSignalStrengthNr.class);
                if (cellSignalStrengthLtes.size() > 0) {
                    return ((CellSignalStrengthNr)cellSignalStrengthLtes.get(0)).getSsRsrq();
                }
            }
        }
        catch (Throwable throwable) {
            Logger.i((String)TAG, (Object)("getNrSsRsrq: throwable:" + throwable.getClass()));
        }
        return ssRsrq;
    }

    public static int getNrCsiRsrq(Context context) {
        int csiRsrq = Integer.MAX_VALUE;
        try {
            if (Build.VERSION.SDK_INT > 28) {
                SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
                if (signalStrength == null) {
                    return csiRsrq;
                }
                List cellSignalStrengthLtes = signalStrength.getCellSignalStrengths(CellSignalStrengthNr.class);
                if (cellSignalStrengthLtes.size() > 0) {
                    return ((CellSignalStrengthNr)cellSignalStrengthLtes.get(0)).getCsiRsrq();
                }
            }
        }
        catch (Throwable throwable) {
            Logger.i((String)TAG, (Object)("getNrCsiRsrq: throwable:" + throwable.getClass()));
        }
        return csiRsrq;
    }

    public static int getNrSsSinr(Context context) {
        int ssSinr = Integer.MAX_VALUE;
        try {
            if (Build.VERSION.SDK_INT > 28) {
                SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
                if (signalStrength == null) {
                    return ssSinr;
                }
                List cellSignalStrengthLtes = signalStrength.getCellSignalStrengths(CellSignalStrengthNr.class);
                if (cellSignalStrengthLtes.size() > 0) {
                    return ((CellSignalStrengthNr)cellSignalStrengthLtes.get(0)).getSsSinr();
                }
            }
        }
        catch (Throwable throwable) {
            Logger.i((String)TAG, (Object)("getNrSsSinr: throwable:" + throwable.getClass()));
        }
        return ssSinr;
    }

    public static int getNrCsiSinr(Context context) {
        int csiSinr = Integer.MAX_VALUE;
        try {
            if (Build.VERSION.SDK_INT > 28) {
                SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
                if (signalStrength == null) {
                    return csiSinr;
                }
                List cellSignalStrengthLtes = signalStrength.getCellSignalStrengths(CellSignalStrengthNr.class);
                if (cellSignalStrengthLtes.size() > 0) {
                    return ((CellSignalStrengthNr)cellSignalStrengthLtes.get(0)).getCsiSinr();
                }
            }
        }
        catch (Throwable throwable) {
            Logger.i((String)TAG, (Object)("getNrCsiSinr: throwable:" + throwable.getClass()));
        }
        return csiSinr;
    }

    private static SignalStrength getSignalStrength(Context context) {
        Object object;
        if (context != null && Build.VERSION.SDK_INT >= 28 && (object = ContextCompat.getSystemService(context, "phone")) instanceof TelephonyManager) {
            TelephonyManager telephonyManager = (TelephonyManager)object;
            telephonyManager = telephonyManager.createForSubscriptionId(SubscriptionManager.getDefaultDataSubscriptionId());
            return telephonyManager.getSignalStrength();
        }
        return null;
    }

    public static int getWifiRssi(Context context) {
        Object object;
        int rssi = -127;
        if (context != null && (object = ContextCompat.getSystemService(context.getApplicationContext(), "wifi")) instanceof WifiManager) {
            WifiManager wifiManager = (WifiManager)object;
            try {
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                if (wifiInfo != null && wifiInfo.getBSSID() != null) {
                    rssi = wifiInfo.getRssi();
                }
            }
            catch (RuntimeException e) {
                Logger.i((String)TAG, (Object)("getWifiRssiLevel did not has permission!" + e.getClass().getSimpleName() + e.getMessage()));
            }
        }
        return rssi;
    }

    public static int getWifiRssiLevel(Context context) {
        return WifiManager.calculateSignalLevel((int)NetworkUtil.getWifiRssi(context), (int)5);
    }

    public static String getWifiGatewayIp(Context context) {
        Object object;
        String wifiGatewayIp = " ";
        if (context != null && (object = ContextCompat.getSystemService(context.getApplicationContext(), "wifi")) instanceof WifiManager) {
            WifiManager wifiManager = (WifiManager)object;
            try {
                DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
                int dhcpGateway = dhcpInfo.gateway;
                byte[] byteaddr = new byte[]{(byte)(dhcpGateway & 0xFF), (byte)(dhcpGateway >> 8 & 0xFF), (byte)(dhcpGateway >> 16 & 0xFF), (byte)(dhcpGateway >> 24 & 0xFF)};
                InetAddress gatewatAddr = InetAddress.getByAddress(byteaddr);
                wifiGatewayIp = gatewatAddr.getHostAddress();
            }
            catch (RuntimeException | UnknownHostException e) {
                Logger.i((String)TAG, (Object)("getWifiGatewayIp error!" + e.getClass().getSimpleName() + e.getMessage()));
                return wifiGatewayIp;
            }
        }
        return wifiGatewayIp;
    }

    @SuppressLint(value={"MissingPermission"})
    public static NetworkInfo.DetailedState getNetworkStatus(Context context) {
        NetworkInfo.DetailedState networkStatus;
        block7: {
            networkStatus = NetworkInfo.DetailedState.IDLE;
            if (context != null) {
                Object object = ContextCompat.getSystemService(context, "connectivity");
                if (object instanceof ConnectivityManager) {
                    try {
                        if (!ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                            return networkStatus;
                        }
                        NetworkInfo netInfo = ((ConnectivityManager)object).getActiveNetworkInfo();
                        if (netInfo != null) {
                            networkStatus = netInfo.getDetailedState();
                            break block7;
                        }
                        Logger.i((String)TAG, (Object)"getNetworkStatus networkIsConnected netInfo is null!");
                    }
                    catch (RuntimeException e) {
                        Logger.i((String)TAG, (Object)("getNetworkStatus exception" + e.getClass().getSimpleName() + e.getMessage()));
                    }
                } else {
                    Logger.i((String)TAG, (Object)"getNetworkStatus ConnectivityManager is null!");
                }
            }
        }
        return networkStatus;
    }

    @SuppressLint(value={"MissingPermission"})
    public static int readDataSaverMode(Context context) {
        Object object;
        int dateSaverMode = 0;
        if (context != null && Build.VERSION.SDK_INT >= 24 && ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (object = ContextCompat.getSystemService(context, "connectivity")) instanceof ConnectivityManager) {
            ConnectivityManager manager = (ConnectivityManager)object;
            try {
                if (manager.isActiveNetworkMetered()) {
                    dateSaverMode = manager.getRestrictBackgroundStatus();
                } else {
                    Logger.v((String)TAG, (Object)"ConnectType is not Mobile Network!");
                }
            }
            catch (RuntimeException e) {
                Logger.e((String)TAG, (String)"SystemServer error:", (Throwable)e);
            }
        }
        return dateSaverMode;
    }

    public static boolean isSimReady(Context context) {
        TelephonyManager tm = null;
        Object object = ContextCompat.getSystemService(context, "phone");
        if (object instanceof TelephonyManager) {
            tm = (TelephonyManager)object;
        }
        return tm != null && tm.getSimState() == 5;
    }

    public static String getMNC(Context context) {
        String opeType = "unknown";
        if (context == null) {
            return opeType;
        }
        if (!NetworkUtil.isSimReady(context)) {
            return opeType;
        }
        TelephonyManager tm = null;
        Object object = ContextCompat.getSystemService(context, "phone");
        if (object instanceof TelephonyManager) {
            tm = (TelephonyManager)object;
        }
        if (tm == null) {
            Logger.e((String)TAG, (Object)"getSubscriptionOperatorType: other error!");
            return opeType;
        }
        String operator = tm.getNetworkOperator();
        opeType = "46001".equals(operator) || "46006".equals(operator) || "46009".equals(operator) ? "China_Unicom" : ("46000".equals(operator) || "46002".equals(operator) || "46004".equals(operator) || "46007".equals(operator) ? "China_Mobile" : ("46003".equals(operator) || "46005".equals(operator) || "46011".equals(operator) ? "China_Telecom" : "other"));
        return opeType;
    }

    public static String getHost(String url) {
        URI uri;
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            Logger.w((String)TAG, (Object)e.getClass().getSimpleName());
            return "";
        }
        return uri.getHost();
    }

    public static boolean isUserUnlocked(Context context) {
        UserManager userManager;
        if (Build.VERSION.SDK_INT >= 24 && (userManager = (UserManager)ContextCompat.getSystemService(context, "user")) != null) {
            try {
                return userManager.isUserUnlocked();
            }
            catch (RuntimeException e) {
                Logger.e((String)TAG, (String)"dealType rethrowFromSystemServer:", (Throwable)e);
            }
        }
        return true;
    }

    @Deprecated
    public static boolean isForeground(Context context) {
        return ActivityUtil.isForeground(context);
    }

    @Deprecated
    public static NetworkInfo.DetailedState networkStatus(Context context) {
        return NetworkUtil.getNetworkStatus(context);
    }

    public static boolean isConnectTypeChange(NetworkInfo before, NetworkInfo now) {
        if (before != null && before.isConnected() && now.isConnected() && NetworkUtil.getPrimaryNetworkType(before) != NetworkUtil.getPrimaryNetworkType(now)) {
            Logger.v((String)TAG, (Object)"Find activity network changed");
            return true;
        }
        return false;
    }

    public static boolean isChangeToConnected(NetworkInfo before, NetworkInfo now) {
        if ((before == null || !before.isConnected()) && now.isConnected()) {
            Logger.v((String)TAG, (Object)"Find network state changed to connected");
            return true;
        }
        return false;
    }

    public static int getPrimaryNetworkType(Context context) {
        NetworkInfo netInfo = NetworkUtil.getNetworkInfo(context);
        int netType = NetworkUtil.getNetworkType(netInfo, context);
        return NetworkUtil.groupNetworkType(netType);
    }

    public static int getPrimaryNetworkType(NetworkInfo networkInfo) {
        int netType = NetworkUtil.getNetworkType(networkInfo);
        return NetworkUtil.groupNetworkType(netType);
    }

    private static int groupNetworkType(int netType) {
        int coarseGrainedType;
        switch (netType) {
            case 1: {
                coarseGrainedType = 1;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                coarseGrainedType = 6;
                break;
            }
            case -1: {
                coarseGrainedType = -1;
                break;
            }
            default: {
                coarseGrainedType = 0;
            }
        }
        return coarseGrainedType;
    }

    private static int getMobileSingalStrengthUpPPlatfrom(Context context) {
        if (Build.VERSION.SDK_INT <= 28) {
            return Integer.MAX_VALUE;
        }
        SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
        if (signalStrength == null) {
            return Integer.MAX_VALUE;
        }
        int networkType = NetworkUtil.getNetworkType(context);
        int rsrp = Integer.MAX_VALUE;
        try {
            switch (networkType) {
                case 3: {
                    List cellSignalStrengthCdma = signalStrength.getCellSignalStrengths(CellSignalStrengthCdma.class);
                    if (cellSignalStrengthCdma.size() > 0) {
                        rsrp = ((CellSignalStrengthCdma)cellSignalStrengthCdma.get(0)).getDbm();
                        break;
                    }
                    List cellSignalStrengthTdscdma = signalStrength.getCellSignalStrengths(CellSignalStrengthTdscdma.class);
                    if (cellSignalStrengthTdscdma.size() > 0) {
                        rsrp = ((CellSignalStrengthTdscdma)cellSignalStrengthTdscdma.get(0)).getDbm();
                        break;
                    }
                    List cellSignalStrengthWcdma = signalStrength.getCellSignalStrengths(CellSignalStrengthWcdma.class);
                    if (cellSignalStrengthWcdma.size() <= 0) break;
                    rsrp = ((CellSignalStrengthWcdma)cellSignalStrengthWcdma.get(0)).getDbm();
                    break;
                }
                case 4: {
                    List cellSignalStrengthLtes = signalStrength.getCellSignalStrengths(CellSignalStrengthLte.class);
                    if (cellSignalStrengthLtes.size() <= 0) break;
                    rsrp = ((CellSignalStrengthLte)cellSignalStrengthLtes.get(0)).getDbm();
                    break;
                }
                case 5: {
                    List cellSignalStrengthNrs = signalStrength.getCellSignalStrengths(CellSignalStrengthNr.class);
                    if (cellSignalStrengthNrs.size() <= 0) break;
                    rsrp = ((CellSignalStrengthNr)cellSignalStrengthNrs.get(0)).getDbm();
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Logger.i((String)TAG, (Object)("getMobileSingalStrength: throwable:" + throwable.getClass()));
        }
        return rsrp;
    }

    public static final class SignalType {
        public static final String LTE_RSRP = "lteRsrp";
        public static final String LTE_RSRQ = "lteRsrq";
        public static final String LTE_RSSI = "lteRssi";
        public static final String LTE_RSSNR = "lteRssnr";
        public static final String LTE_DBM = "lteDbm";
        public static final String LTE_CQI = "lteCqi";
        public static final String NR_DBM = "nrDbm";
        public static final String NR_SSRSRP = "nrSSRsrp";
        public static final String NR_CSIRSRP = "nrCSIRsrp";
        public static final String NR_SSRSRQ = "nrSSRsrq";
        public static final String NR_CSIRSRQ = "nrCSIRsrq";
        public static final String NR_SSSINR = "nrSSSinr";
        public static final String NR_CSISINR = "nrCSISinr";
    }

    public static final class NetType {
        public static final int TYPE_NO_NETWORK = -1;
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WIFI = 1;
        public static final int TYPE_2G = 2;
        public static final int TYPE_3G = 3;
        public static final int TYPE_4G = 4;
        public static final int TYPE_4G_NSA = 7;
        public static final int TYPE_5G = 5;
        public static final int TYPE_5G_SA = 8;
        public static final int TYPE_MOBILE = 6;
    }
}

