/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secure.android.common.encrypt.keystore.rsa;

import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.huawei.secure.android.common.encrypt.utils.b;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;

public abstract class RSASignKS {
    private static final String a = "RSASignKS";
    private static final String b = "AndroidKeyStore";
    private static final String c = "SHA256withRSA/PSS";
    private static final String d = "";
    private static final int e = 2048;
    private static final int f = 3072;

    @Deprecated
    public static String sign(String string, String string2) {
        try {
            return Base64.encodeToString((byte[])RSASignKS.sign(string, string2.getBytes("UTF-8")), (int)0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)a, (String)("sign UnsupportedEncodingException : " + unsupportedEncodingException.getMessage()));
            return d;
        }
    }

    @Deprecated
    public static boolean verifySign(String string, String string2, String string3) {
        try {
            return RSASignKS.verifySign(string, string2.getBytes("UTF-8"), Base64.decode((String)string3, (int)0));
        }
        catch (Exception exception) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "base64 decode Exception" + exception.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)a, (String)("verifySign UnsupportedEncodingException: " + unsupportedEncodingException.getMessage()));
        }
        return false;
    }

    public static String signNew(String string, String string2) {
        try {
            return Base64.encodeToString((byte[])RSASignKS.signNew(string, string2.getBytes("UTF-8")), (int)0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)a, (String)("sign UnsupportedEncodingException : " + unsupportedEncodingException.getMessage()));
            return d;
        }
    }

    public static boolean verifySignNew(String string, String string2, String string3) {
        try {
            return RSASignKS.verifySignNew(string, string2.getBytes("UTF-8"), Base64.decode((String)string3, (int)0));
        }
        catch (Exception exception) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "base64 decode Exception" + exception.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)a, (String)("verifySign UnsupportedEncodingException: " + unsupportedEncodingException.getMessage()));
        }
        return false;
    }

    @Deprecated
    public static byte[] sign(String string, byte[] byArray) {
        return RSASignKS.a(string, byArray, false);
    }

    @Deprecated
    public static boolean verifySign(String string, byte[] byArray, byte[] byArray2) {
        return RSASignKS.a(string, byArray, byArray2, false);
    }

    public static byte[] signNew(String string, byte[] byArray) {
        return RSASignKS.a(string, byArray, true);
    }

    public static boolean verifySignNew(String string, byte[] byArray, byte[] byArray2) {
        return RSASignKS.a(string, byArray, byArray2, true);
    }

    private static byte[] a(String object, byte[] byArray, boolean bl) {
        byte[] byArray2 = new byte[]{};
        if (!TextUtils.isEmpty((CharSequence)object) && byArray != null) {
            if (!RSASignKS.isBuildVersionHigherThan22()) {
                com.huawei.secure.android.common.encrypt.utils.b.b(a, "sdk version is too low");
                return byArray2;
            }
            if (!((object = RSASignKS.b((String)object, bl)) instanceof KeyStore.PrivateKeyEntry)) {
                com.huawei.secure.android.common.encrypt.utils.b.b(a, "Not an instance of a PrivateKeyEntry");
                return byArray2;
            }
            Signature signature = Signature.getInstance(c);
            try {
                signature.initSign(((KeyStore.PrivateKeyEntry)object).getPrivateKey());
                signature.update(byArray);
                return signature.sign();
            }
            catch (Exception exception) {
                com.huawei.secure.android.common.encrypt.utils.b.b(a, "Exception: " + exception.getMessage());
            }
            catch (InvalidKeyException invalidKeyException) {
                com.huawei.secure.android.common.encrypt.utils.b.b(a, "InvalidKeyException: " + invalidKeyException.getMessage());
            }
            catch (SignatureException signatureException) {
                com.huawei.secure.android.common.encrypt.utils.b.b(a, "SignatureException: " + signatureException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                com.huawei.secure.android.common.encrypt.utils.b.b(a, "NoSuchAlgorithmException: " + noSuchAlgorithmException.getMessage());
            }
            return byArray2;
        }
        com.huawei.secure.android.common.encrypt.utils.b.b(a, "alias or content is null");
        return byArray2;
    }

    private static boolean a(String object, byte[] byArray, byte[] byArray2, boolean bl) {
        if (!TextUtils.isEmpty((CharSequence)object) && byArray != null && byArray2 != null) {
            boolean bl2 = false;
            if (!RSASignKS.isBuildVersionHigherThan22()) {
                com.huawei.secure.android.common.encrypt.utils.b.b(a, "sdk version is too low");
                return false;
            }
            if (!((object = RSASignKS.b((String)object, bl)) instanceof KeyStore.PrivateKeyEntry)) {
                com.huawei.secure.android.common.encrypt.utils.b.b(a, "Not an instance of a PrivateKeyEntry");
                return false;
            }
            Signature signature = Signature.getInstance(c);
            try {
                signature.initVerify(((KeyStore.PrivateKeyEntry)object).getCertificate());
                signature.update(byArray);
                bl2 = signature.verify(byArray2);
            }
            catch (Exception exception) {
                com.huawei.secure.android.common.encrypt.utils.b.b(a, "Exception: " + exception.getMessage());
            }
            catch (InvalidKeyException invalidKeyException) {
                com.huawei.secure.android.common.encrypt.utils.b.b(a, "InvalidKeyException: " + invalidKeyException.getMessage());
            }
            catch (SignatureException signatureException) {
                com.huawei.secure.android.common.encrypt.utils.b.b(a, "SignatureException: " + signatureException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                com.huawei.secure.android.common.encrypt.utils.b.b(a, "NoSuchAlgorithmException: " + noSuchAlgorithmException.getMessage());
            }
            return bl2;
        }
        com.huawei.secure.android.common.encrypt.utils.b.b(a, "alias or content or sign value is null");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized KeyPair a(String string, boolean bl) {
        if (RSASignKS.a(string)) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "Key pair exits");
            return null;
        }
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", b);
            if (!bl) {
                keyPairGenerator.initialize((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(string, 12).setDigests(new String[]{"SHA-256", "SHA-512"}).setSignaturePaddings(new String[]{"PSS"}).setKeySize(2048).build());
                return keyPairGenerator.generateKeyPair();
            } else {
                keyPairGenerator.initialize((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(string, 12).setDigests(new String[]{"SHA-256", "SHA-512"}).setSignaturePaddings(new String[]{"PSS"}).setKeySize(3072).build());
            }
            return keyPairGenerator.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "InvalidAlgorithmParameterException: " + invalidAlgorithmParameterException.getMessage());
            return keyPair;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "NoSuchProviderException: " + noSuchProviderException.getMessage());
            return keyPair;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "NoSuchAlgorithmException: " + noSuchAlgorithmException.getMessage());
        }
        return keyPair;
    }

    private static KeyStore.Entry b(String string, boolean bl) {
        if (!RSASignKS.a(string)) {
            RSASignKS.a(string, bl);
        }
        KeyStore.Entry entry = null;
        KeyStore keyStore = KeyStore.getInstance(b);
        try {
            keyStore.load(null);
            entry = keyStore.getEntry(string, null);
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "UnrecoverableEntryException: " + unrecoverableEntryException.getMessage());
        }
        catch (IOException iOException) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "IOException: " + iOException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "NoSuchAlgorithmException: " + noSuchAlgorithmException.getMessage());
        }
        catch (CertificateException certificateException) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "CertificateException: " + certificateException.getMessage());
        }
        catch (KeyStoreException keyStoreException) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "KeyStoreException: " + keyStoreException.getMessage());
        }
        return entry;
    }

    public static boolean isBuildVersionHigherThan22() {
        return Build.VERSION.SDK_INT >= 23;
    }

    private static boolean a(String string) {
        KeyStore keyStore = KeyStore.getInstance(b);
        try {
            keyStore.load(null);
            return keyStore.getKey(string, null) != null;
        }
        catch (IOException iOException) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "IOException: " + iOException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "NoSuchAlgorithmException: " + noSuchAlgorithmException.getMessage());
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "UnrecoverableKeyException: " + unrecoverableKeyException.getMessage());
        }
        catch (CertificateException certificateException) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "CertificateException: " + certificateException.getMessage());
        }
        catch (KeyStoreException keyStoreException) {
            com.huawei.secure.android.common.encrypt.utils.b.b(a, "KeyStoreException: " + keyStoreException.getMessage());
        }
        return false;
    }
}

