/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.common.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.engagelab.privates.common.log.MTCommonLog;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.json.JSONArray;

public class Utils {
    private static final String TAG = "Utils";
    private static final Object dateLock = new Object();
    private static ConcurrentHashMap<String, ThreadLocal<SimpleDateFormat>> sdfMap = new ConcurrentHashMap();
    private static HashMap<Integer, WeakReference<WindowManager>> windowManagerMap = new HashMap();
    private static LinkedHashMap<String, String> cacheCurrentType = new LinkedHashMap();
    private static List<String> supportImageType = new ArrayList<String>();
    private static final String regEx = "[^0-9]";

    public static ArrayList<String> jsonArray2StringList(JSONArray array) {
        JSONArray jSONArray;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        if (array != null && jSONArray.length() != 0) {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                String string = jSONArray.optString(i2);
                if (TextUtils.isEmpty((CharSequence)string)) continue;
                arrayList2.add(string);
            }
            return arrayList2;
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public static String listToString(Collection<String> collection, String split) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            void var1_1;
            stringBuilder2.append(iterator.next()).append((String)var1_1);
        }
        if (stringBuilder2.length() > 0) {
            Object object = stringBuilder2;
            ((StringBuilder)object).deleteCharAt(((StringBuilder)object).length() - 1);
        }
        return stringBuilder2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static double getDistance(double longitude1, double latitude1, double longitude2, double latitude2) {
        double d2;
        void var2_1;
        void var4_2;
        void v02 = var4_2;
        double d3 = var2_1 * (Math.PI / 360);
        var2_1 = d2 * (Math.PI / 360);
        var4_2 = d3 - var2_1;
        d2 = (longitude1 - v02) * (Math.PI / 360);
        return Math.round(Math.asin(Math.sqrt(Math.pow(Math.sin((double)var4_2), 2.0) + Math.cos(d3 * 2.0) * Math.cos((double)(var2_1 * 2.0)) * Math.pow(Math.sin(d2), 2.0))) * 1.2756274E7 * 10000.0) / 10000L;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                Closeable closeable2;
                closeable2.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] readAvailable(InputStream input) throws IOException {
        if (input != null) {
            InputStream inputStream;
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            return byArray;
        }
        throw new IOException("InputStream is null");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] read1024(InputStream input) throws IOException {
        Throwable throwable2;
        ByteArrayOutputStream byteArrayOutputStream;
        block8: {
            byte[] byArray;
            ByteArrayOutputStream byteArrayOutputStream2;
            if (input == null) {
                throw new IOException("InputStream is null");
            }
            byte[] byArray2 = null;
            byteArrayOutputStream = byteArrayOutputStream2;
            byteArrayOutputStream2 = new ByteArrayOutputStream();
            {
                catch (Throwable throwable2) {
                    byteArrayOutputStream = byArray2;
                    break block8;
                }
            }
            try {
                InputStream inputStream;
                int n2;
                byArray2 = new byte[1024];
                while ((n2 = inputStream.read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n2);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable2) {}
            Utils.closeQuietly(byteArrayOutputStream);
            return byArray;
        }
        Utils.closeQuietly(byteArrayOutputStream);
        throw throwable2;
    }

    /*
     * WARNING - void declaration
     */
    public static int dpToPx(Context context, int dp) {
        Context context2;
        void var1_2;
        if (context == null) {
            return (int)var1_2;
        }
        float f2 = (float)var1_2;
        DisplayMetrics displayMetrics = context2.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)displayMetrics);
    }

    /*
     * WARNING - void declaration
     */
    public static ViewGroup.LayoutParams setViewMargin(Context context, View view, boolean isDp, int left, int top, int right, int bottom) {
        void var1_2;
        if (context != null && var1_2 != null) {
            int n2;
            int n3;
            int n4;
            int n5;
            void var2_3;
            ViewGroup.MarginLayoutParams marginLayoutParams;
            block14: {
                ViewGroup.MarginLayoutParams marginLayoutParams2;
                ViewGroup.LayoutParams layoutParams;
                block13: {
                    layoutParams = var1_2.getLayoutParams();
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break block13;
                    layoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
                    marginLayoutParams = layoutParams;
                    break block14;
                }
                marginLayoutParams = marginLayoutParams2;
                marginLayoutParams2 = new ViewGroup.MarginLayoutParams(layoutParams);
            }
            if (var2_3 != false) {
                Context context2;
                Context context3 = context2;
                void v2 = n5;
                Context context4 = context2;
                void v4 = n4;
                Context context5 = context2;
                void v6 = n3;
                n2 = Utils.dpToPx(context2, n2);
                n3 = Utils.dpToPx(context5, (int)v6);
                n4 = Utils.dpToPx(context4, (int)v4);
                n5 = Utils.dpToPx(context3, (int)v2);
            }
            try {
                ViewGroup.MarginLayoutParams marginLayoutParams3 = marginLayoutParams;
                marginLayoutParams3.setMargins(n2, n4, n3, n5);
                var1_2.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams3);
                return marginLayoutParams;
            }
            catch (Throwable throwable) {
                MTCommonLog.w(TAG, "[setViewMargin] failed. err: " + throwable.getMessage());
            }
        }
        return null;
    }

    public static DisplayMetrics providesDisplayMetrics(Context context) {
        Context context2;
        DisplayMetrics displayMetrics;
        DisplayMetrics displayMetrics2 = displayMetrics;
        displayMetrics = new DisplayMetrics();
        if (context != null && (context2 = (WindowManager)context2.getSystemService("window")) != null) {
            if (Build.VERSION.SDK_INT >= 17) {
                context2.getDefaultDisplay().getRealMetrics(displayMetrics2);
            } else {
                context2.getDefaultDisplay().getMetrics(displayMetrics2);
            }
        }
        return displayMetrics2;
    }

    /*
     * WARNING - void declaration
     */
    public static void setWindowManager(String className, WindowManager windowManager) {
        void var1_2;
        int n2 = className.hashCode();
        Iterator<Map.Entry<Integer, WeakReference<WindowManager>>> iterator = windowManagerMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, WeakReference<WindowManager>> entry = iterator.next();
            Object object = entry;
            object = object.getValue();
            if (entry.getKey() == n2) continue;
            if (object != null) {
                ((Reference)object).clear();
            }
            iterator.remove();
        }
        windowManagerMap.put(n2, new WeakReference<void>(var1_2));
    }

    public static WindowManager getWindowManagerForActivity(String className) {
        WeakReference<WindowManager> weakReference = windowManagerMap.get(className.hashCode());
        if (weakReference != null) {
            return (WindowManager)weakReference.get();
        }
        return null;
    }

    public static void clearWindowManagerForActivity(String className) {
        windowManagerMap.remove(className.hashCode());
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkValidImageUrl(String url, boolean isNeedSaveType) {
        HttpURLConnection httpURLConnection;
        block14: {
            block15: {
                URL uRL;
                String string;
                block13: {
                    boolean bl;
                    String string2;
                    URL uRL2;
                    if (TextUtils.isEmpty((CharSequence)url)) {
                        return false;
                    }
                    httpURLConnection = null;
                    string = null;
                    uRL = uRL2;
                    uRL2 = new URL(string2);
                    try {
                        void var1_2;
                        httpURLConnection = (HttpURLConnection)uRL2.openConnection();
                        string = httpURLConnection.getContentType();
                        if (!Utils.isSupportType(string)) break block13;
                        if (var1_2 != false) {
                            Utils.saveCurrentType(string2, string);
                        }
                        bl = true;
                        if (httpURLConnection == null) return bl;
                    }
                    catch (Throwable throwable) {}
                    try {
                        httpURLConnection.disconnect();
                        return bl;
                    }
                    catch (Throwable throwable) {}
                    return bl;
                }
                if (httpURLConnection == null) return false;
                break block14;
                break block15;
                catch (Throwable throwable) {
                    uRL = string;
                }
            }
            if (httpURLConnection == null) return false;
        }
        try {
            httpURLConnection.disconnect();
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isSupportType(String type) {
        try {
            String string;
            return supportImageType.contains(string);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void saveCurrentType(String url, String type) {
        void var1_1;
        String string;
        try {
            if (cacheCurrentType.containsKey(string)) return;
        }
        catch (Throwable throwable) {}
        cacheCurrentType.put(string, (String)var1_1);
        return;
    }

    public static String getTypeFromUrl(String url) {
        String string;
        try {
            String string2;
            string = cacheCurrentType.get(string2);
            cacheCurrentType.remove(string2);
        }
        catch (Throwable throwable) {
            return "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static int getWidth(Context context, int viewWidth) {
        Context context2;
        void var1_1;
        return (int)((float)Utils.providesDisplayMetrics((Context)context).widthPixels * ((float)var1_1 / Utils.getBasicWidth(context2)));
    }

    /*
     * WARNING - void declaration
     */
    public static int getHeight(Context context, int viewHeight) {
        Context context2;
        void var1_1;
        return (int)((float)Utils.providesDisplayMetrics((Context)context).heightPixels * ((float)var1_1 / Utils.getBasicHeight(context2)));
    }

    private static float getBasicHeight(Context context) {
        if (context.getResources().getConfiguration().orientation == 2) {
            return 375.0f;
        }
        return 667.0f;
    }

    private static float getBasicWidth(Context context) {
        if (context.getResources().getConfiguration().orientation == 2) {
            return 667.0f;
        }
        return 375.0f;
    }

    public static int getNumber(String string) {
        try {
            String string2;
            return Integer.valueOf(Pattern.compile(regEx).matcher(string2).replaceAll("").trim());
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethod(Object owner, String methodName, Class[] argClasses, Object[] args) throws Exception {
        void var2_2;
        int n2;
        Object var3_4;
        int n3 = args != null ? ((void)var3_4).length : 0;
        if (n3 == (n2 = var2_2 != null ? ((void)var2_2).length : 0)) {
            Method method;
            Object object;
            method = object.getClass().getMethod((String)((Object)method), (Class<?>)var2_2);
            boolean bl = method.isAccessible();
            if (!bl) {
                method.setAccessible(true);
            }
            Object object2 = object;
            void v1 = var3_4;
            object = null;
            var3_4 = null;
            try {
                object = method.invoke(object2, (Object[])v1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                method.setAccessible(false);
            }
            if (var3_4 == null) {
                return object;
            }
            throw var3_4;
        }
        throw new IllegalArgumentException("argClasses' size is not equal to args' size");
    }

    static {
        supportImageType.add("image/png");
        supportImageType.add("image/jpg");
        supportImageType.add("image/jpeg");
    }
}

