/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secure.android.common.ssl;

import android.os.Build;
import com.huawei.secure.android.common.ssl.util.g;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;

public abstract class SSLUtil {
    private static final String a = "SSLUtil";
    private static final String b = "TLSv1.3";
    private static final String c = "TLSv1.2";
    private static final String d = "TLS";
    private static final String e = "TLSv1";
    private static final String[] f = new String[]{"TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"};
    private static final String[] g = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384"};
    private static final String[] h = new String[]{"TLS_RSA", "CBC", "TEA", "SHA0", "MD2", "MD4", "RIPEMD", "NULL", "RC4", "DES", "DESX", "DES40", "RC2", "MD5", "ANON", "TLS_EMPTY_RENEGOTIATION_INFO_SCSV"};

    public static SSLContext setSSLContext() throws NoSuchAlgorithmException {
        int n = Build.VERSION.SDK_INT;
        return n >= 29 ? SSLContext.getInstance(b) : (n >= 16 ? SSLContext.getInstance(c) : SSLContext.getInstance(d));
    }

    public static void setEnableSafeCipherSuites(SSLSocket sSLSocket) {
        if (sSLSocket == null) {
            return;
        }
        if (!SSLUtil.setWhiteListCipherSuites(sSLSocket)) {
            SSLUtil.setBlackListCipherSuites(sSLSocket);
        }
    }

    public static boolean setWhiteListCipherSuites(SSLSocket sSLSocket) {
        if (sSLSocket == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT > 19) {
            return SSLUtil.setWhiteListCipherSuites(sSLSocket, g);
        }
        return SSLUtil.setWhiteListCipherSuites(sSLSocket, f);
    }

    public static boolean setWhiteListCipherSuites(SSLSocket sSLSocket, String[] object) {
        ArrayList arrayList;
        if (sSLSocket == null) {
            return false;
        }
        String[] stringArray = sSLSocket.getEnabledCipherSuites();
        String[] stringArray2 = object;
        object = arrayList;
        arrayList = new ArrayList();
        List<String> list = Arrays.asList(stringArray2);
        for (String string : stringArray) {
            if (!list.contains(string.toUpperCase(Locale.ENGLISH))) continue;
            object.add(string);
        }
        if (!object.isEmpty()) {
            Object object2 = object;
            sSLSocket.setEnabledCipherSuites(object2.toArray(new String[object2.size()]));
            return true;
        }
        return false;
    }

    public static boolean setBlackListCipherSuites(SSLSocket sSLSocket) {
        if (sSLSocket == null) {
            return false;
        }
        return SSLUtil.setBlackListCipherSuites(sSLSocket, h);
    }

    public static boolean setBlackListCipherSuites(SSLSocket sSLSocket, String[] stringArray) {
        ArrayList<String> arrayList;
        if (sSLSocket == null) {
            return false;
        }
        String[] stringArray2 = sSLSocket.getEnabledCipherSuites();
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        for (String string : stringArray2) {
            boolean bl = false;
            String string2 = string.toUpperCase(Locale.ENGLISH);
            int n = stringArray.length;
            for (int k = 0; k < n; ++k) {
                if (!string2.contains(stringArray[k].toUpperCase(Locale.ENGLISH))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList2.add(string);
        }
        if (!arrayList2.isEmpty()) {
            ArrayList<String> arrayList3 = arrayList2;
            sSLSocket.setEnabledCipherSuites(arrayList3.toArray(new String[arrayList3.size()]));
            return true;
        }
        return false;
    }

    public static void setEnabledProtocols(SSLSocket sSLSocket) {
        int n;
        if (sSLSocket == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            sSLSocket.setEnabledProtocols(new String[]{b, c});
        }
        if ((n = Build.VERSION.SDK_INT) >= 16 && n < 29) {
            sSLSocket.setEnabledProtocols(new String[]{c});
        } else if (Build.VERSION.SDK_INT < 16) {
            sSLSocket.setEnabledProtocols(new String[]{e});
        }
    }

    public static boolean setEnabledProtocols(SSLSocket sSLSocket, String[] stringArray) {
        if (sSLSocket != null && stringArray != null) {
            try {
                sSLSocket.setEnabledProtocols(stringArray);
                return true;
            }
            catch (Exception exception) {
                com.huawei.secure.android.common.ssl.util.g.b(a, "setEnabledProtocols: exception : " + exception.getMessage());
                return false;
            }
        }
        return false;
    }

    public static void setSSLSocketOptions(SSLSocket sSLSocket) {
        if (sSLSocket == null) {
            return;
        }
        SSLSocket sSLSocket2 = sSLSocket;
        SSLUtil.setEnabledProtocols(sSLSocket2);
        SSLUtil.setEnableSafeCipherSuites(sSLSocket2);
    }

    public static void printTLSAndCipher(SSLSocket stringArray) {
        String[] stringArray2 = stringArray.getEnabledProtocols();
        int n = stringArray2.length;
        for (int k = 0; k < n; ++k) {
            com.huawei.secure.android.common.ssl.util.g.c(a, "new enable protocols is : " + stringArray2[k]);
        }
        stringArray = stringArray.getEnabledCipherSuites();
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            com.huawei.secure.android.common.ssl.util.g.c(a, "new cipher suites is : " + stringArray[n]);
        }
    }

    public static String[] getEnabledProtocols(SSLSocket sSLSocket) {
        return sSLSocket.getEnabledProtocols();
    }

    public static String[] getEnabledCipherSuites(SSLSocket sSLSocket) {
        return sSLSocket.getEnabledCipherSuites();
    }
}

