/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Parcelable;
import android.text.TextUtils;
import com.huawei.hms.adapter.BaseAdapter;
import com.huawei.hms.common.internal.AnyClient;
import com.huawei.hms.common.internal.BaseHmsClient;
import com.huawei.hms.common.internal.ClientSettings;
import com.huawei.hms.common.internal.RequestHeader;
import com.huawei.hms.common.internal.ResponseHeader;
import com.huawei.hms.common.internal.ResponseWrap;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.support.log.HMSLog;
import java.lang.ref.WeakReference;
import org.json.JSONObject;

public abstract class HmsClient
extends BaseHmsClient
implements AnyClient {
    private static final String TAG = "HmsClient";

    public HmsClient(Context context, ClientSettings clientSettings, BaseHmsClient.OnConnectionFailedListener onConnectionFailedListener, BaseHmsClient.ConnectionCallbacks connectionCallbacks) {
        super(context, clientSettings, onConnectionFailedListener, connectionCallbacks);
    }

    @Override
    public void post(IMessageEntity iMessageEntity, String string, AnyClient.CallBack callBack) {
        if (callBack == null) {
            HMSLog.e((String)TAG, (String)"callback is invalid, discard.");
            return;
        }
        if (iMessageEntity instanceof RequestHeader && string != null) {
            BaseAdapter baseAdapter;
            if (!this.isConnected()) {
                HMSLog.i((String)TAG, (String)("No connection now, the connection status:" + this.getConnectionStatus()));
                if (this.getConnectionStatus() != 6) {
                    HMSLog.e((String)TAG, (String)"post failed for not connected.");
                    callBack.onCallback(new ResponseHeader(1, 907135001, "Not Connected"), new JSONObject().toString());
                    return;
                }
                HMSLog.i((String)TAG, (String)"in timeout-disconnect status, need to bind again.");
                this.bindCoreService();
            }
            iMessageEntity = (RequestHeader)iMessageEntity;
            HMSLog.i((String)TAG, (String)("post msg " + iMessageEntity));
            Object object = this.getClientSettings().getCpActivity();
            boolean bl = object == null;
            if (bl) {
                HMSLog.i((String)TAG, (String)("Activity is null for " + this.getClientSettings().getAppID()));
            }
            if (bl) {
                BaseAdapter baseAdapter2;
                object = baseAdapter2;
                baseAdapter2 = new BaseAdapter(this);
                baseAdapter = object;
            } else {
                BaseAdapter baseAdapter3;
                baseAdapter = baseAdapter3;
                baseAdapter3 = new BaseAdapter(this, (Activity)object);
            }
            baseAdapter.baseRequest(((RequestHeader)iMessageEntity).toJson(), string, ((RequestHeader)iMessageEntity).getParcelable(), new BaseAdapterCallBack(this, callBack));
            return;
        }
        HMSLog.e((String)TAG, (String)"arguments is invalid.");
        callBack.onCallback(new ResponseHeader(1, 907135000, "Args is invalid"), new JSONObject().toString());
    }

    public void updateSessionId(String string) {
        if (TextUtils.isEmpty((CharSequence)this.sessionId)) {
            this.sessionId = string;
        }
    }

    private static class BaseAdapterCallBack
    implements BaseAdapter.BaseCallBack {
        private final AnyClient.CallBack callback;
        private final WeakReference<HmsClient> hmsClient;

        BaseAdapterCallBack(HmsClient hmsClient, AnyClient.CallBack callBack) {
            BaseAdapterCallBack baseAdapterCallBack = this;
            baseAdapterCallBack.callback = callBack;
            baseAdapterCallBack.hmsClient = new WeakReference<HmsClient>(hmsClient);
        }

        private void updateSessionId(String string) {
            HmsClient hmsClient = (HmsClient)((BaseAdapterCallBack)((Object)hmsClient)).hmsClient.get();
            if (hmsClient != null) {
                hmsClient.updateSessionId(string);
            }
        }

        private void doCallback(String string, String string2) {
            ResponseHeader responseHeader;
            ResponseHeader responseHeader2 = responseHeader;
            responseHeader2();
            if (responseHeader.fromJson(string)) {
                BaseAdapterCallBack baseAdapterCallBack = this;
                HMSLog.i((String)HmsClient.TAG, (String)("receive msg " + responseHeader2));
                baseAdapterCallBack.updateSessionId(responseHeader2.getSessionId());
                baseAdapterCallBack.callback.onCallback(responseHeader2, string2);
            } else {
                this.callback.onCallback(new ResponseHeader(1, 907135000, "response header json error"), new JSONObject().toString());
            }
        }

        private void doCallback(String string, String string2, Parcelable parcelable) {
            ResponseHeader responseHeader;
            ResponseHeader responseHeader2 = responseHeader;
            responseHeader2();
            if (responseHeader.fromJson(string)) {
                BaseAdapterCallBack baseAdapterCallBack = this;
                ResponseHeader responseHeader3 = responseHeader2;
                responseHeader3.setParcelable(parcelable);
                HMSLog.i((String)HmsClient.TAG, (String)("receive msg " + responseHeader2));
                baseAdapterCallBack.updateSessionId(responseHeader3.getSessionId());
                baseAdapterCallBack.callback.onCallback(responseHeader2, string2);
            } else {
                this.callback.onCallback(new ResponseHeader(1, 907135000, "response header json error"), new JSONObject().toString());
            }
        }

        @Override
        public void onComplete(String string, String string2, Parcelable parcelable) {
            if (parcelable == null) {
                this.doCallback(string, string2);
            } else {
                this.doCallback(string, string2, parcelable);
            }
        }

        @Override
        public void onError(String string) {
            ResponseWrap responseWrap;
            ResponseWrap responseWrap2 = responseWrap;
            responseWrap2(new ResponseHeader());
            if (responseWrap.fromJson(string)) {
                BaseAdapterCallBack baseAdapterCallBack = responseHeader;
                HMSLog.i((String)HmsClient.TAG, (String)("receive msg " + responseWrap2));
                ResponseHeader responseHeader = responseWrap2.getResponseHeader();
                baseAdapterCallBack.updateSessionId(responseHeader.getSessionId());
                baseAdapterCallBack.callback.onCallback(responseHeader, responseWrap2.getBody());
            } else {
                ((BaseAdapterCallBack)((Object)responseHeader)).callback.onCallback(new ResponseHeader(1, 907135000, "response header json error"), new JSONObject().toString());
            }
        }
    }
}

