/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.oth.sound.business;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SoundMessageJson {
    public static final int PLAY = 1;
    private String body;
    private int nIsSpeech;
    private String nLan;
    private List<String> nSpeechOrder;

    public static SoundMessageJson fromJson(String message) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)message)) {
            message = "{}";
        }
        SoundMessageJson soundMessageJson = new SoundMessageJson();
        soundMessageJson.setBody(message);
        JSONObject messageJson = new JSONObject(message);
        JSONObject contentJson = messageJson.optJSONObject("m_content");
        if (contentJson == null) {
            return null;
        }
        int n_is_speech = contentJson.optInt("n_is_speech", 0);
        soundMessageJson.setnIsSpeech(n_is_speech);
        if (1 == n_is_speech) {
            String n_lan = contentJson.optString("n_lan", "");
            soundMessageJson.setnLan(n_lan);
            JSONArray n_speech_order = contentJson.optJSONArray("n_speech_order");
            if (null != n_speech_order) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < n_speech_order.length(); ++i) {
                    list.add(n_speech_order.getString(i));
                }
                soundMessageJson.setnSpeechOrder(list);
            }
        }
        return soundMessageJson;
    }

    public boolean valid() {
        if (1 != this.nIsSpeech) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.nLan)) {
            return false;
        }
        return null != this.nSpeechOrder && this.nSpeechOrder.size() != 0;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public int getnIsSpeech() {
        return this.nIsSpeech;
    }

    public void setnIsSpeech(int nIsSpeech) {
        this.nIsSpeech = nIsSpeech;
    }

    public String getnLan() {
        return this.nLan;
    }

    public void setnLan(String nLan) {
        this.nLan = nLan;
    }

    public List<String> getnSpeechOrder() {
        return this.nSpeechOrder;
    }

    public void setnSpeechOrder(List<String> nSpeechOrder) {
        this.nSpeechOrder = nSpeechOrder;
    }

    public String toString() {
        return "SoundMessageJson{nIsSpeech=" + this.nIsSpeech + ", nLan='" + this.nLan + '\'' + ", nSpeechOrder=" + this.nSpeechOrder + ", body='" + this.body + '\'' + '}';
    }
}

