/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.time;

import com.google.android.datatransport.runtime.time.Clock;
import java.util.concurrent.atomic.AtomicLong;

public class TestClock
implements Clock {
    private final AtomicLong timestamp;

    public TestClock(long initialTimestamp) {
        this.timestamp = new AtomicLong(initialTimestamp);
    }

    @Override
    public long getTime() {
        return this.timestamp.get();
    }

    public void tick() {
        this.advance(1L);
    }

    public void advance(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("cannot advance time backwards.");
        }
        this.timestamp.addAndGet(value);
    }
}

