/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.data;

import android.os.Bundle;
import com.huawei.hms.common.data.DataBuffer;
import com.huawei.hms.common.data.Freezable;
import java.util.ArrayList;
import java.util.Iterator;

public final class DataBufferUtils {
    public static final String NEXT_PAGE = "next_page";
    public static final String PREV_PAGE = "prev_page";
    public static final int ARGS_COLUMN = 1;
    public static final int ARGS_CURSOR = 2;
    public static final int ARGS_STATUS = 3;
    public static final int ARGS_BUNDLE = 4;
    public static final int ARGS_VERSION = 1000;

    private DataBufferUtils() {
    }

    public static <T, E extends Freezable<T>> ArrayList<T> freezeAndClose(DataBuffer<E> dataBuffer) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList(dataBuffer.getCount());
        Iterator<E> iterator = dataBuffer.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(((Freezable)iterator.next()).freeze());
        }
        dataBuffer.release();
        return arrayList2;
    }

    public static boolean hasNextPage(DataBuffer<?> dataBuffer) {
        return DataBufferUtils.containKey(dataBuffer.getMetadata(), NEXT_PAGE);
    }

    public static boolean hasPrevPage(DataBuffer<?> dataBuffer) {
        return DataBufferUtils.containKey(dataBuffer.getMetadata(), PREV_PAGE);
    }

    public static boolean hasData(DataBuffer<?> dataBuffer) {
        if (dataBuffer == null) {
            return false;
        }
        return dataBuffer.getCount() > 0;
    }

    private static boolean containKey(Bundle bundle, String string) {
        if (bundle == null) {
            return false;
        }
        return bundle.getString(string) != null;
    }
}

