/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.support.api.core;

import android.text.TextUtils;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.support.api.PendingResultImpl;
import com.huawei.hms.support.api.ResolvePendingResult;
import com.huawei.hms.support.api.ResolveResult;
import com.huawei.hms.support.api.client.ApiClient;
import com.huawei.hms.support.api.client.InnerPendingResult;
import com.huawei.hms.support.api.client.PendingResult;
import com.huawei.hms.support.api.client.Status;
import com.huawei.hms.support.api.entity.core.CheckConnectInfo;
import com.huawei.hms.support.api.entity.core.CheckConnectResp;
import com.huawei.hms.support.api.entity.core.ConnectInfo;
import com.huawei.hms.support.api.entity.core.ConnectResp;
import com.huawei.hms.support.api.entity.core.DisconnectInfo;
import com.huawei.hms.support.api.entity.core.DisconnectResp;
import com.huawei.hms.support.api.entity.core.JosGetNoticeReq;
import com.huawei.hms.support.api.entity.core.JosGetNoticeResp;
import com.huawei.hms.support.log.HMSLog;

public final class ConnectService {
    private ConnectService() {
    }

    public static PendingResult<ResolveResult<ConnectResp>> connect(ApiClient apiClient, ConnectInfo connectInfo) {
        return new PendingResultImpl<ResolveResult<ConnectResp>, ConnectResp>(apiClient, "core.connect", (IMessageEntity)connectInfo){

            public ResolveResult<ConnectResp> a(ConnectResp connectResp) {
                ResolveResult resolveResult = new ResolveResult((Object)connectResp);
                resolveResult.setStatus(Status.SUCCESS);
                HMSLog.d((String)"connectservice", (String)"connect - onComplete: success");
                return resolveResult;
            }

            protected boolean checkApiClient(ApiClient apiClient) {
                return apiClient != null;
            }
        };
    }

    public static PendingResult<ResolveResult<ConnectResp>> forceConnect(ApiClient apiClient, ConnectInfo connectInfo) {
        return new PendingResultImpl<ResolveResult<ConnectResp>, ConnectResp>(apiClient, "core.foreconnect", (IMessageEntity)connectInfo){

            public ResolveResult<ConnectResp> a(ConnectResp connectResp) {
                ResolveResult resolveResult = new ResolveResult((Object)connectResp);
                resolveResult.setStatus(Status.SUCCESS);
                HMSLog.d((String)"connectservice", (String)"forceConnect - onComplete: success");
                return resolveResult;
            }

            protected boolean checkApiClient(ApiClient apiClient) {
                return apiClient != null;
            }
        };
    }

    public static ResolvePendingResult<DisconnectResp> disconnect(ApiClient apiClient, DisconnectInfo disconnectInfo) {
        return ResolvePendingResult.build(apiClient, "core.disconnect", disconnectInfo, DisconnectResp.class);
    }

    public static InnerPendingResult<ResolveResult<CheckConnectResp>> checkconnect(ApiClient apiClient, CheckConnectInfo checkConnectInfo) {
        return ResolvePendingResult.build(apiClient, "core.checkconnect", checkConnectInfo, CheckConnectResp.class);
    }

    public static PendingResult<ResolveResult<JosGetNoticeResp>> getNotice(ApiClient apiClient, int n, String string) {
        JosGetNoticeReq josGetNoticeReq;
        JosGetNoticeReq josGetNoticeReq2 = josGetNoticeReq;
        josGetNoticeReq2();
        josGetNoticeReq2.setNoticeType(n);
        josGetNoticeReq.setHmsSdkVersionName(string);
        if (!TextUtils.isEmpty((CharSequence)apiClient.getCpID())) {
            josGetNoticeReq2.setCpID(apiClient.getCpID());
        }
        return new PendingResultImpl<ResolveResult<JosGetNoticeResp>, JosGetNoticeResp>(apiClient, "core.getNoticeIntent", (IMessageEntity)josGetNoticeReq2){

            public ResolveResult<JosGetNoticeResp> a(JosGetNoticeResp josGetNoticeResp) {
                if (josGetNoticeResp == null) {
                    HMSLog.e((String)"connectservice", (String)"JosNoticeResp is null");
                    return null;
                }
                HMSLog.i((String)"connectservice", (String)("josNoticeResp status code :" + josGetNoticeResp.getStatusCode()));
                ResolveResult resolveResult = new ResolveResult((Object)josGetNoticeResp);
                resolveResult.setStatus(Status.SUCCESS);
                return resolveResult;
            }
        };
    }
}

