/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.installations.local.PersistedInstallationEntry;
import com.google.firebase.installations.time.Clock;
import com.google.firebase.installations.time.SystemClock;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class Utils {
    public static final long AUTH_TOKEN_EXPIRATION_BUFFER_IN_SECS = TimeUnit.HOURS.toSeconds(1L);
    private static final String APP_ID_IDENTIFICATION_SUBSTRING = ":";
    private static final Pattern API_KEY_FORMAT = Pattern.compile("\\AA[\\w-]{38}\\z");
    private static Utils singleton;
    private final Clock clock;

    private Utils(Clock clock) {
        this.clock = clock;
    }

    public static Utils getInstance() {
        return Utils.getInstance(SystemClock.getInstance());
    }

    public static Utils getInstance(Clock clock) {
        if (singleton == null) {
            singleton = new Utils(clock);
        }
        return singleton;
    }

    public boolean isAuthTokenExpired(@NonNull PersistedInstallationEntry entry) {
        if (TextUtils.isEmpty((CharSequence)entry.getAuthToken())) {
            return true;
        }
        return entry.getTokenCreationEpochInSecs() + entry.getExpiresInSecs() < this.currentTimeInSecs() + AUTH_TOKEN_EXPIRATION_BUFFER_IN_SECS;
    }

    public long currentTimeInSecs() {
        return TimeUnit.MILLISECONDS.toSeconds(this.currentTimeInMillis());
    }

    public long currentTimeInMillis() {
        return this.clock.currentTimeMillis();
    }

    static boolean isValidAppIdFormat(@Nullable String appId) {
        return appId.contains(APP_ID_IDENTIFICATION_SUBSTRING);
    }

    static boolean isValidApiKeyFormat(@Nullable String apiKey) {
        return API_KEY_FORMAT.matcher(apiKey).matches();
    }

    public long getRandomDelayForSyncPrevention() {
        return (long)(Math.random() * 1000.0);
    }
}

