/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.common.log;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.engagelab.privates.common.constants.MTCommonConstants;
import com.engagelab.privates.common.global.MTGlobal;
import com.engagelab.privates.common.log.MTLogCache;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class MTCommonLog {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    /*
     * WARNING - void declaration
     */
    public static void i(String tag, String message) {
        void var1_1;
        String string;
        Log.i((String)MTCommonLog.getTag(), (String)("[" + string + "] " + (String)var1_1));
        MTLogCache.getInstance().i(string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void d(String tag, String message) {
        void var1_1;
        String string;
        MTLogCache.getInstance().d(string, (String)var1_1);
        if (!MTGlobal.getDebugMode()) {
            return;
        }
        Log.d((String)MTCommonLog.getTag(), (String)("[" + string + "] " + (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void debug(String tag, String message) {
        void var1_1;
        String string;
        MTLogCache.getInstance().debug(string, (String)var1_1);
        if (!MTGlobal.getDebugMode()) {
            return;
        }
        Log.d((String)MTCommonLog.getTag(), (String)("d-[" + string + "] " + (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void debugOnly(String tag, String message) {
        void var1_1;
        String string;
        if (!MTGlobal.getDebugMode()) {
            return;
        }
        Log.d((String)MTCommonLog.getTag(), (String)("o-[" + string + "] " + (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void w(String tag, String message) {
        void var1_1;
        String string;
        MTLogCache.getInstance().w(string, (String)var1_1);
        if (!MTGlobal.getDebugMode()) {
            return;
        }
        Log.w((String)MTCommonLog.getTag(), (String)("[" + string + "] " + (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void e(String tag, String message) {
        void var1_1;
        String string;
        Log.e((String)MTCommonLog.getTag(), (String)("[" + string + "] " + (String)var1_1));
        MTLogCache.getInstance().e(string, (String)var1_1);
    }

    public static void initLogCache(Context context) {
        Context context2;
        if (context == null) {
            Log.e((String)MTCommonLog.getTag(), (String)"initLogCache: context is null");
            return;
        }
        MTLogCache.getInstance().init(context2);
    }

    public static void setProcessType(boolean isMainProcess) {
        boolean bl;
        MTLogCache.getInstance().setProcessType(bl);
    }

    public static boolean isProcessTypeSet() {
        return MTLogCache.getInstance().isProcessTypeSet();
    }

    public static void setLogCacheEnabled(boolean enabled) {
        boolean bl;
        MTLogCache.getInstance().setEnabled(bl);
    }

    public static void setLogCacheEnabledAll(boolean enabled) {
        boolean bl;
        MTLogCache.getInstance().setEnabledAll(bl);
    }

    public static void setReuseActiveFile(boolean enabled) {
        boolean bl;
        MTLogCache.getInstance().setReuseActiveFile(bl);
    }

    public static List<File> getAllClosedLogFiles() {
        return MTLogCache.getInstance().getAllClosedLogFiles();
    }

    public static boolean isLogCacheEnabled() {
        return MTLogCache.getInstance().isEnabled();
    }

    public static void setMaxTotalSize(long maxTotalSize) {
        long l2;
        MTLogCache.getInstance().setMaxTotalSize(l2);
    }

    private static String getTag() {
        return MTCommonLog.getLogTag() + "-E";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getLogTag() {
        String string;
        try {
            string = Thread.currentThread().getName();
        }
        catch (Throwable throwable) {
            return MTCommonConstants.getLogTag() + "SDK";
        }
        {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return MTCommonConstants.getLogTag() + "SDK";
            }
            if (TextUtils.equals((CharSequence)string, (CharSequence)Looper.getMainLooper().getThread().getName())) {
                return MTCommonConstants.getLogTag() + "MAIN";
            }
            if (string.startsWith(MTCommonConstants.getLogTag())) {
                return string;
            }
            return MTCommonConstants.getLogTag() + string;
        }
    }

    public static String toLogString(Bundle bundle) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        Bundle bundle2;
        if (bundle == null) {
            return "null";
        }
        Bundle bundle3 = bundle2;
        StringBuilder stringBuilder3 = stringBuilder2;
        new StringBuilder().append("{ ");
        Iterator iterator = bundle3.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            StringBuilder stringBuilder4 = stringBuilder3;
            Bundle bundle4 = bundle2;
            StringBuilder stringBuilder5 = stringBuilder3;
            String string = (String)iterator.next();
            stringBuilder5.append(string).append(":");
            stringBuilder4.append(bundle4.get(string)).append(" ");
        }
        try {
            StringBuilder stringBuilder6 = stringBuilder3;
            stringBuilder = stringBuilder6;
            stringBuilder6.append("}");
        }
        catch (Throwable throwable) {
            return bundle2.toString();
        }
        return stringBuilder.toString();
    }

    public static String toLogString(JSONObject json) {
        JSONObject jSONObject;
        if (json == null) {
            return "null";
        }
        try {
            return LINE_SEPARATOR + jSONObject.toString(2);
        }
        catch (Throwable throwable) {
            return jSONObject.toString();
        }
    }
}

