/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.platform.honor.callback;

import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.engagelab.privates.common.api.MTCommonPrivatesApi;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.common.utils.SM4Util;
import com.engagelab.privates.push.api.CustomMessage;
import com.engagelab.privates.push.api.MTPushPrivatesApi;
import com.engagelab.privates.push.platform.honor.business.MTHonorBusiness;
import com.engagelab.privates.push.utils.NotificationUtil;
import com.hihonor.push.sdk.HonorMessageService;
import com.hihonor.push.sdk.HonorPushDataMsg;
import org.json.JSONObject;

public class MTHonorCallbackImp
extends HonorMessageService {
    private static final String TAG = "MTHonorCallbackImp";
    private Context mContext;

    public MTHonorCallbackImp(Service service) {
        this.mContext = service.getApplicationContext();
    }

    public void onNewToken(String token) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            MTCommonLog.d((String)TAG, (String)"onTokenFailed:onNewToken token is empty");
            MTHonorBusiness.getInstance().onNode(this.mContext, 3004, 0, 3900, 2);
            return;
        }
        MTCommonLog.d((String)TAG, (String)("onTokenSuccess:onNewToken token is " + token));
        MTHonorBusiness.getInstance().onToken(this.mContext, token, 2);
    }

    public void onMessageReceived(HonorPushDataMsg honorPushDataMsg) {
        MTCommonLog.d((String)TAG, (String)("onMessageReceived:" + honorPushDataMsg));
        if (honorPushDataMsg == null) {
            MTCommonLog.d((String)TAG, (String)"honorPushDataMsg was null");
            return;
        }
        try {
            String platformMessageId = String.valueOf(honorPushDataMsg.getMsgId());
            String content = honorPushDataMsg.getData();
            if (content == null) {
                return;
            }
            JSONObject jsonObject = new JSONObject(content);
            String message = null;
            message = jsonObject.has("JMessageExtra") ? jsonObject.getString("JMessageExtra") : jsonObject.getString("MTMessageExtra");
            if (message == null) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)(message = SM4Util.decodeMessage((String)message)))) {
                return;
            }
            MTPushPrivatesApi.init((Context)this.mContext);
            JSONObject messageJson = new JSONObject(message);
            MTCommonLog.d((String)TAG, (String)("onMessage:" + MTCommonLog.toLogString((JSONObject)messageJson)));
            String messageId = NotificationUtil.getMessageId((JSONObject)messageJson);
            MTCommonLog.d((String)TAG, (String)"is data");
            String customTitle = messageJson.optString("title");
            String customContent = messageJson.optString("message");
            String customContentType = messageJson.optString("content_type");
            Bundle extras = NotificationUtil.convertJsonToBundle((JSONObject)messageJson.optJSONObject("extras"));
            CustomMessage customMessage = new CustomMessage().setMessageId(messageId).setPlatform((byte)7).setPlatformMessageId(platformMessageId).setTitle(customTitle).setContent(customContent).setContentType(customContentType).setExtras(extras);
            Bundle bundle = new Bundle();
            bundle.putParcelable("message", (Parcelable)customMessage);
            MTCommonPrivatesApi.sendMessageToMainProcess((Context)this.mContext, (int)3001, (Bundle)bundle);
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("onMessage failed " + throwable.getMessage()));
        }
    }
}

