/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.oth.sound.cache;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.engagelab.privates.common.global.MTGlobal;
import java.util.HashMap;
import java.util.Map;

public class OTHSoundConfig {
    private static final String NAME = "com.engagelab.privates.oth.sound";
    private static Map<String, SharedPreferences> mapSharedPreferences = new HashMap<String, SharedPreferences>();
    private static final String LAST_SIGN_SOUND = "lss";
    private static final String RESPONSE_BODY = "rb";
    private static final String ENABLE_SOUND = "es";
    private static final String LAST_TIME = "lt";

    private static SharedPreferences getSharedPreferences(Context context) {
        String name = "com.engagelab.privates.oth.sound." + MTGlobal.getAppKey((Context)context);
        SharedPreferences sharedPreferences = mapSharedPreferences.get(name);
        if (sharedPreferences == null) {
            sharedPreferences = context.getSharedPreferences(name, 0);
            mapSharedPreferences.put(name, sharedPreferences);
        }
        return sharedPreferences;
    }

    public static String getLastSignSound(Context context) {
        return OTHSoundConfig.getSharedPreferences(context).getString(LAST_SIGN_SOUND, "");
    }

    public static void setLastSignSound(Context context, String value) {
        OTHSoundConfig.getSharedPreferences(context).edit().putString(LAST_SIGN_SOUND, value).commit();
    }

    public static String getResponseBody(Context context, String lan) {
        return OTHSoundConfig.getSharedPreferences(context).getString("rb_" + OTHSoundConfig.getNoNull(lan), "");
    }

    public static void setResponseBody(Context context, String lan, String value) {
        OTHSoundConfig.getSharedPreferences(context).edit().putString("rb_" + OTHSoundConfig.getNoNull(lan), value).commit();
    }

    public static boolean getEnablePushTextToSpeech(Context context) {
        return OTHSoundConfig.getSharedPreferences(context).getBoolean(ENABLE_SOUND, false);
    }

    public static void setEnablePushTextToSpeech(Context context, boolean value) {
        OTHSoundConfig.getSharedPreferences(context).edit().putBoolean(ENABLE_SOUND, value).commit();
    }

    public static long getLastTime(Context context, String lan) {
        return OTHSoundConfig.getSharedPreferences(context).getLong("lt_" + OTHSoundConfig.getNoNull(lan), 0L);
    }

    public static void setLastTime(Context context, String lan, long value) {
        OTHSoundConfig.getSharedPreferences(context).edit().putLong("lt_" + OTHSoundConfig.getNoNull(lan), value).commit();
    }

    private static String getNoNull(String data) {
        if (TextUtils.isEmpty((CharSequence)data)) {
            return data;
        }
        return data.replace(" ", "");
    }
}

