/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.text.TextUtils;
import com.huawei.hms.framework.common.StringUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;

public class ExceptionCode {
    public static final int CRASH_EXCEPTION = 10000000;
    public static final int CANCEL = 10000100;
    public static final int NETWORK_TIMEOUT = 10000101;
    public static final int NETWORK_UNSUPPORTED = 10000102;
    public static final int NETWORK_UNREACHABLE = 10000200;
    public static final int NETWORK_CHANGED = 10000201;
    public static final int SHUTDOWN_EXCEPTION = 10000202;
    public static final int UNABLE_TO_RESOLVE_HOST = 10000300;
    public static final int ROUTE_FAILED = 10000301;
    public static final int SOCKET_CONNECT_TIMEOUT = 10000400;
    public static final int CONNECTION_RESET = 0x989811;
    public static final int CONNECTION_ABORT = 10000402;
    public static final int CONNECT_FAILED = 10000403;
    public static final int CONNECTION_REFUSED = 10000404;
    public static final int INTERRUPT_CONNECT_CLOSE = 10000405;
    public static final int SOCKET_CLOSE = 10000406;
    public static final int SSL_PROTOCOL_EXCEPTION = 10000500;
    public static final int SSL_HANDSHAKE_EXCEPTION = 10000501;
    public static final int SSL_PEERUNVERIFIED_EXCEPTION = 10000502;
    public static final int SOCKET_READ_TIMEOUT = 0x9898D8;
    public static final int READ_ERROR = 0x9898D9;
    public static final int SOCKET_WRITE_TIMEOUT = 10000700;
    public static final int UNEXPECTED_EOF = 10000800;
    public static final int PROTOCOL_ERROR = 10000801;
    public static final int NETWORK_IO_EXCEPTION = 10000802;
    public static final int SOCKET_TIMEOUT = 10000803;
    public static final int INTERRUPT_EXCEPTION = 10000804;
    private static final String CONNECT = "connect";
    private static final String READ = "read";
    private static final String WRITE = "write";

    public static int getErrorCodeFromException(Exception e) {
        if (e == null) {
            return 10000802;
        }
        if (!(e instanceof IOException)) {
            return 10000000;
        }
        String errorMessage = e.getMessage();
        if (errorMessage == null) {
            return 10000802;
        }
        int code = ExceptionCode.getErrorCodeFromMsg(errorMessage = StringUtils.toLowerCase(errorMessage));
        if (code != 10000802) {
            return code;
        }
        if (e instanceof SocketTimeoutException) {
            return ExceptionCode.getErrorCodeSocketTimeout(e);
        }
        if (e instanceof ConnectException) {
            return 10000403;
        }
        if (e instanceof NoRouteToHostException) {
            return 10000301;
        }
        if (e instanceof SSLProtocolException) {
            return 10000500;
        }
        if (e instanceof SSLHandshakeException) {
            return 10000501;
        }
        if (e instanceof SSLPeerUnverifiedException) {
            return 10000502;
        }
        if (e instanceof UnknownHostException) {
            return 10000300;
        }
        if (e instanceof InterruptedIOException) {
            if (errorMessage.contains("connection has been shut down")) {
                return 10000405;
            }
            return 10000804;
        }
        if (e instanceof ProtocolException) {
            return 10000801;
        }
        return code;
    }

    private static int getErrorCodeSocketTimeout(Exception e) {
        String result;
        switch (result = ExceptionCode.checkExceptionContainsKey(e, CONNECT, READ, WRITE)) {
            case "connect": {
                return 10000400;
            }
            case "read": {
                return 0x9898D8;
            }
            case "write": {
                return 10000700;
            }
        }
        return 10000803;
    }

    private static int getErrorCodeFromMsg(String errorMessage) {
        int result;
        if (errorMessage.contains("unexpected end of stream")) {
            result = 10000800;
        } else if (errorMessage.contains("unable to resolve host")) {
            result = 10000300;
        } else if (errorMessage.contains("read error")) {
            result = 0x9898D9;
        } else if (errorMessage.contains("connection reset")) {
            result = 0x989811;
        } else if (errorMessage.contains("software caused connection abort")) {
            result = 10000402;
        } else if (errorMessage.contains("failed to connect to")) {
            result = 10000403;
        } else if (errorMessage.contains("connection refused")) {
            result = 10000404;
        } else {
            if (errorMessage.contains("connection timed out")) {
                return 10000400;
            }
            result = errorMessage.contains("no route to host") ? 10000301 : (errorMessage.contains("network is unreachable") ? 10000200 : (errorMessage.contains("socket closed") ? 10000406 : 10000802));
        }
        return result;
    }

    private static String checkExceptionContainsKey(Exception e, String ... keys) {
        String msg = StringUtils.toLowerCase(e.getMessage());
        return ExceptionCode.checkStrContainsKey(msg, keys);
    }

    private static String checkStrContainsKey(String str, String ... keys) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        for (String key : keys) {
            if (!str.contains(key)) continue;
            return key;
        }
        return "";
    }
}

