/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.tasks.zza;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzaa;
import com.google.android.gms.tasks.zzab;
import com.google.android.gms.tasks.zzad;
import com.google.android.gms.tasks.zzae;
import com.google.android.gms.tasks.zzaf;
import com.google.android.gms.tasks.zzb;
import com.google.android.gms.tasks.zzw;
import com.google.android.gms.tasks.zzx;
import com.google.android.gms.tasks.zzy;
import com.google.android.gms.tasks.zzz;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    @Deprecated
    @NonNull
    public static <TResult> Task<TResult> call(@NonNull Callable<TResult> callable) {
        Callable<TResult> callable2;
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public static <TResult> Task<TResult> call(@NonNull Executor executor, @NonNull Callable<TResult> callable) {
        Executor executor2;
        void var1_1;
        Preconditions.checkNotNull((Object)executor, (Object)"Executor must not be null");
        Preconditions.checkNotNull((Object)var1_1, (Object)"Callback must not be null");
        zzw zzw2 = new zzw();
        zzz zzz2 = new zzz(zzw2, (Callable)var1_1);
        executor2.execute(zzz2);
        return zzw2;
    }

    @NonNull
    public static <TResult> Task<TResult> forCanceled() {
        zzw zzw2 = new zzw();
        zzw2.zzc();
        return zzw2;
    }

    @NonNull
    public static <TResult> Task<TResult> forException(@NonNull Exception e) {
        Exception exception;
        zzw zzw2 = new zzw();
        zzw2.zza(exception);
        return zzw2;
    }

    @NonNull
    public static <TResult> Task<TResult> forResult(TResult result) {
        TResult TResult;
        zzw<TResult> zzw2 = new zzw<TResult>();
        zzw2.zzb(TResult);
        return zzw2;
    }

    @NonNull
    public static Task<Void> whenAll(@Nullable Collection<? extends Task<?>> tasks) {
        Iterator iterator;
        if (tasks == null || iterator.isEmpty()) {
            return Tasks.forResult(null);
        }
        zzw<Void> zzw2 = iterator.iterator();
        while (zzw2.hasNext()) {
            if (zzw2.next() != null) continue;
            iterator = new Iterator("null tasks are not accepted");
            throw iterator;
        }
        zzw2 = new zzw<Void>();
        zzaf zzaf2 = new zzaf(iterator.size(), zzw2);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Tasks.zzb((Task)iterator.next(), zzaf2);
        }
        return zzw2;
    }

    @NonNull
    public static Task<Void> whenAll(Task<?> ... tasks) {
        Task<?>[] taskArray;
        if (tasks == null || taskArray.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(taskArray));
    }

    @NonNull
    public static Task<List<Task<?>>> whenAllComplete(@Nullable Collection<? extends Task<?>> tasks) {
        Collection<Task<?>> collection;
        if (tasks == null || collection.isEmpty()) {
            return Tasks.forResult(Collections.emptyList());
        }
        Task<Void> task = Tasks.whenAll(collection);
        zzab zzab2 = new zzab(collection);
        return task.continueWithTask(TaskExecutors.MAIN_THREAD, zzab2);
    }

    @NonNull
    public static Task<List<Task<?>>> whenAllComplete(Task<?> ... tasks) {
        Task<?>[] taskArray;
        if (tasks == null || taskArray.length == 0) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAllComplete(Arrays.asList(taskArray));
    }

    @NonNull
    public static <TResult> Task<List<TResult>> whenAllSuccess(@Nullable Collection<? extends Task> tasks) {
        Collection<? extends Task> collection;
        if (tasks == null || collection.isEmpty()) {
            return Tasks.forResult(Collections.emptyList());
        }
        Task<Void> task = Tasks.whenAll(collection);
        zzaa zzaa2 = new zzaa(collection);
        return task.continueWith(TaskExecutors.MAIN_THREAD, zzaa2);
    }

    @NonNull
    public static <TResult> Task<List<TResult>> whenAllSuccess(Task ... tasks) {
        Task[] taskArray;
        if (tasks == null || taskArray.length == 0) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAllSuccess(Arrays.asList(taskArray));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public static <T> Task<T> withTimeout(@NonNull Task<T> task, long timeout, @NonNull TimeUnit unit) {
        Task<T> task2;
        zzx zzx2;
        void var1_1;
        Preconditions.checkNotNull(task, (Object)"Task must not be null");
        boolean bl = var1_1 > 0L;
        Preconditions.checkArgument((boolean)bl, (Object)"Timeout must be positive");
        Preconditions.checkNotNull((Object)zzx2, (Object)"TimeUnit must not be null");
        zzb zzb2 = new zzb();
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource(zzb2);
        zza zza2 = new zza(Looper.getMainLooper());
        zzy zzy2 = new zzy(taskCompletionSource);
        zza2.postDelayed(zzy2, ((TimeUnit)((Object)zzx2)).toMillis((long)var1_1));
        zzx2 = new zzx(zza2, taskCompletionSource, zzb2);
        task2.addOnCompleteListener(zzx2);
        return taskCompletionSource.getTask();
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        Task<TResult> task2;
        Preconditions.checkNotMainThread();
        Preconditions.checkNotNull(task2, (Object)"Task must not be null");
        if (task2.isComplete()) {
            return Tasks.zza(task2);
        }
        zzad zzad2 = new zzad(null);
        Tasks.zzb(task2, zzad2);
        zzad2.zza();
        return Tasks.zza(task2);
    }

    /*
     * WARNING - void declaration
     */
    public static <TResult> TResult await(@NonNull Task<TResult> task, long timeout, @NonNull TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        void var1_1;
        void var3_2;
        Object object;
        Preconditions.checkNotMainThread();
        Preconditions.checkNotNull(object, (Object)"Task must not be null");
        Preconditions.checkNotNull((Object)var3_2, (Object)"TimeUnit must not be null");
        if (((Task)object).isComplete()) {
            return Tasks.zza(object);
        }
        zzad zzad2 = new zzad(null);
        Tasks.zzb(object, zzad2);
        if (!zzad2.zzb((long)var1_1, (TimeUnit)var3_2)) {
            object = new TimeoutException("Timed out waiting for Task");
            throw object;
        }
        return Tasks.zza(object);
    }

    private Tasks() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private static <TResult> TResult zza(@NonNull Task<TResult> object) throws ExecutionException {
        if (((Task)object).isSuccessful()) {
            return ((Task)object).getResult();
        }
        if (!((Task)object).isCanceled()) {
            ExecutionException executionException = new ExecutionException(((Task)object).getException());
            throw executionException;
        }
        object = new CancellationException("Task is already canceled");
        throw object;
    }

    private static <T> void zzb(Task<T> task, zzae<? super T> zzae2) {
        task.addOnSuccessListener(TaskExecutors.zza, zzae2);
        task.addOnFailureListener(TaskExecutors.zza, zzae2);
        task.addOnCanceledListener(TaskExecutors.zza, zzae2);
    }
}

