/*
 * Decompiled with CFR 0.152.
 */
package cn.engagelab.uniplugin_mtpush.helper;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import cn.engagelab.uniplugin_mtpush.common.MTLogger;
import com.alibaba.fastjson.JSONObject;
import com.engagelab.privates.push.api.CustomMessage;
import com.engagelab.privates.push.api.InAppMessage;
import com.engagelab.privates.push.api.NotificationMessage;
import com.taobao.weex.bridge.JSCallback;
import java.util.HashMap;

public class MTPushHelper {
    public static HashMap<String, JSCallback> eventCallback = new HashMap();
    public static JSONObject OPEN_NOTIFICATION_DATA = null;
    public static int OPEN_NOTIFICATION_TYPE = 0;
    public static boolean IS_DESTROY = true;

    public static void sendNotifactionEvent(JSONObject params, int notificationType) {
        if (notificationType != 1) {
            MTPushHelper.sendEvent("NotificationEvent", params);
        } else {
            MTPushHelper.sendEvent("LocalNotificationEvent", params);
        }
    }

    public static void sendEvent(String eventName, JSONObject params) {
        try {
            if (!TextUtils.isEmpty((CharSequence)eventName) && params != null) {
                MTLogger.d("sendEvent :" + eventName + " params:" + params);
                JSCallback jsCallback = eventCallback.get(eventName);
                if (jsCallback != null) {
                    jsCallback.invokeAndKeepAlive((Object)params);
                    MTLogger.e("sendEvent :" + eventName + " success");
                    return;
                }
                MTLogger.e("sendEvent :" + eventName + " failed");
            }
        }
        catch (Throwable throwable) {
            MTLogger.e("sendEvent error:" + throwable.getMessage());
        }
    }

    public static JSONObject convertNotificationToMap(String eventType, NotificationMessage message) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("notificationEventType", (Object)eventType);
        jsonObject.put("messageID", (Object)message.getMessageId());
        jsonObject.put("title", (Object)message.getTitle());
        jsonObject.put("content", (Object)message.getContent());
        jsonObject.put("android", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)message)));
        String extras = MTPushHelper.getJson(message.getExtras());
        MTPushHelper.convertExtras(extras, jsonObject);
        return jsonObject;
    }

    public static JSONObject convertCustomMessage(CustomMessage customMessage) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("messageID", (Object)customMessage.getMessageId());
        jsonObject.put("title", (Object)customMessage.getTitle());
        jsonObject.put("content", (Object)customMessage.getContent());
        String extras = MTPushHelper.getJson(customMessage.getExtras());
        MTPushHelper.convertExtras(extras, jsonObject);
        jsonObject.put("android", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)customMessage)));
        return jsonObject;
    }

    public static JSONObject convertInappMessage(String exentType, InAppMessage inAppMessage) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("messageID", (Object)inAppMessage.getMessageId());
        jsonObject.put("content", (Object)inAppMessage.getContent());
        jsonObject.put("click", (Object)inAppMessage.getClick());
        jsonObject.put("target", (Object)inAppMessage.getTarget());
        jsonObject.put("extras", (Object)inAppMessage.getExtras());
        jsonObject.put("eventType", (Object)exentType);
        return jsonObject;
    }

    public static void convertExtras(String extras, JSONObject jsonObject) {
        if (TextUtils.isEmpty((CharSequence)extras) || extras.equals("{}")) {
            return;
        }
        try {
            jsonObject.put("extras", (Object)JSONObject.parseObject((String)extras));
        }
        catch (Throwable throwable) {
            MTLogger.w("convertExtras error:" + throwable.getMessage());
        }
    }

    public static void launchApp(Context context) {
        try {
            Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            intent.setFlags(0x34000000);
            context.startActivity(intent);
        }
        catch (Throwable throwable) {
            MTLogger.e("");
        }
    }

    public static void saveOpenNotifiData(JSONObject jsonObject, int type) {
        if (IS_DESTROY) {
            MTLogger.d("saveOpenNotifiData:" + jsonObject);
            OPEN_NOTIFICATION_DATA = jsonObject;
            OPEN_NOTIFICATION_TYPE = type;
        }
    }

    public static void sendCacheOpenNotifiToUser(int type) {
        if (type == 0 && OPEN_NOTIFICATION_TYPE == 1) {
            return;
        }
        if (!IS_DESTROY && OPEN_NOTIFICATION_DATA != null) {
            MTLogger.d("sendCacheOpenNotifiToUser:" + OPEN_NOTIFICATION_DATA);
            MTPushHelper.sendNotifactionEvent(OPEN_NOTIFICATION_DATA, OPEN_NOTIFICATION_TYPE);
            OPEN_NOTIFICATION_DATA = null;
        }
    }

    public static String getJson(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        for (String key : bundle.keySet()) {
            Object obj = bundle.get(key);
            try {
                jsonObject.put(key, bundle.get(key));
            }
            catch (Throwable throwable) {
                MTLogger.e("getJson error:" + throwable.getMessage());
            }
        }
        return jsonObject.toString();
    }
}

