/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.huawei.hms.activity.BridgeActivity;
import com.huawei.hms.activity.ForegroundBusDelegate;
import com.huawei.hms.activity.internal.BusResponseCallback;
import com.huawei.hms.activity.internal.ForegroundBusResponseMgr;
import com.huawei.hms.activity.internal.ForegroundInnerHeader;
import com.huawei.hms.common.internal.RequestHeader;
import com.huawei.hms.common.internal.TransactionIdCreater;
import com.huawei.hms.utils.Util;

public class ForegroundIntentBuilder {
    private Activity activity;
    private RequestHeader foregroundHeader;
    private String foregroundBody;
    private ForegroundInnerHeader innerHeader;
    private String innerPkgName;
    private Context mHostContext;

    public ForegroundIntentBuilder(Activity activity) throws IllegalArgumentException {
        if (activity != null) {
            ForegroundIntentBuilder foregroundIntentBuilder = this;
            foregroundIntentBuilder.activity = activity;
            foregroundIntentBuilder.foregroundHeader = new RequestHeader();
            foregroundIntentBuilder.foregroundHeader.setSdkVersion(60500300);
            foregroundIntentBuilder.foregroundBody = "";
            foregroundIntentBuilder.innerHeader = new ForegroundInnerHeader();
            foregroundIntentBuilder.innerHeader.setApkVersion(30000000);
            return;
        }
        throw new IllegalArgumentException("listener must not be null.");
    }

    public static void registerResponseCallback(String string, BusResponseCallback busResponseCallback) {
        ForegroundBusResponseMgr.getInstance().registerObserver(string, busResponseCallback);
    }

    public static void unregisterResponseCallback(String string) {
        ForegroundBusResponseMgr.getInstance().unRegisterObserver(string);
    }

    public Intent build() {
        String string;
        ForegroundIntentBuilder foregroundIntentBuilder = this;
        Intent intent = BridgeActivity.getIntentStartBridgeActivity((Activity)foregroundIntentBuilder.activity, (String)ForegroundBusDelegate.class.getName());
        Object object = foregroundIntentBuilder.mHostContext;
        if (object != null) {
            object = object.getPackageName();
            string = Util.getAppId(this.mHostContext);
        } else {
            ForegroundIntentBuilder foregroundIntentBuilder2 = this;
            object = foregroundIntentBuilder2.activity.getPackageName();
            string = Util.getAppId((Context)foregroundIntentBuilder2.activity);
        }
        if (this.foregroundHeader.getAppID() == null) {
            this.foregroundHeader.setAppID(string + "|");
        } else {
            this.foregroundHeader.setAppID(string + "|" + this.foregroundHeader.getAppID());
        }
        if (TextUtils.isEmpty((CharSequence)this.foregroundHeader.getTransactionId())) {
            RequestHeader requestHeader = this.foregroundHeader;
            requestHeader.setTransactionId(TransactionIdCreater.getId(requestHeader.getAppID(), "hub.request"));
        }
        ForegroundIntentBuilder foregroundIntentBuilder3 = this;
        foregroundIntentBuilder3.foregroundHeader.setPkgName((String)object);
        intent.putExtra("HMS_FOREGROUND_REQ_HEADER", foregroundIntentBuilder3.foregroundHeader.toJson());
        intent.putExtra("HMS_FOREGROUND_REQ_BODY", this.foregroundBody);
        intent.putExtra("HMS_FOREGROUND_REQ_INNER", this.innerHeader.toJson());
        if (!TextUtils.isEmpty((CharSequence)this.innerPkgName)) {
            intent.putExtra("INNER_PACKAGE_NAME", this.innerPkgName);
        }
        return intent;
    }

    public ForegroundIntentBuilder setApplicationContext(Context context) {
        this.mHostContext = context;
        return this;
    }

    public ForegroundIntentBuilder setInnerHms() {
        ForegroundIntentBuilder foregroundIntentBuilder = this;
        foregroundIntentBuilder.innerPkgName = foregroundIntentBuilder.activity.getPackageName();
        return foregroundIntentBuilder;
    }

    public ForegroundIntentBuilder setSubAppId(String string) {
        ForegroundIntentBuilder foregroundIntentBuilder = this;
        foregroundIntentBuilder.foregroundHeader.setAppID(string);
        return foregroundIntentBuilder;
    }

    public ForegroundIntentBuilder setRequestBody(String string) {
        this.foregroundBody = string;
        return this;
    }

    public ForegroundIntentBuilder setMinApkVersion(int n) {
        ForegroundIntentBuilder foregroundIntentBuilder = this;
        foregroundIntentBuilder.innerHeader.setApkVersion(n);
        return foregroundIntentBuilder;
    }

    public ForegroundIntentBuilder setResponseCallback(String string, BusResponseCallback busResponseCallback) {
        ForegroundIntentBuilder foregroundIntentBuilder = this;
        foregroundIntentBuilder.innerHeader.setResponseCallbackKey(string);
        ForegroundBusResponseMgr.getInstance().registerObserver(string, busResponseCallback);
        return foregroundIntentBuilder;
    }

    public ForegroundIntentBuilder setResponseCallback(String string) {
        ForegroundIntentBuilder foregroundIntentBuilder = this;
        foregroundIntentBuilder.innerHeader.setResponseCallbackKey(string);
        return foregroundIntentBuilder;
    }

    public ForegroundIntentBuilder setAction(String string) {
        ForegroundIntentBuilder foregroundIntentBuilder = this;
        foregroundIntentBuilder.foregroundHeader.setApiName(string);
        return foregroundIntentBuilder;
    }

    public ForegroundIntentBuilder setServiceName(String string) {
        ForegroundIntentBuilder foregroundIntentBuilder = this;
        foregroundIntentBuilder.foregroundHeader.setSrvName(string);
        return foregroundIntentBuilder;
    }

    public ForegroundIntentBuilder setTransactionId(String string) {
        ForegroundIntentBuilder foregroundIntentBuilder = this;
        foregroundIntentBuilder.foregroundHeader.setTransactionId(string);
        return foregroundIntentBuilder;
    }

    public ForegroundIntentBuilder setKitSdkVersion(int n) {
        ForegroundIntentBuilder foregroundIntentBuilder = this;
        foregroundIntentBuilder.foregroundHeader.setKitSdkVersion(n);
        return foregroundIntentBuilder;
    }

    public ForegroundIntentBuilder setApiLevel(int n) {
        ForegroundIntentBuilder foregroundIntentBuilder = this;
        foregroundIntentBuilder.foregroundHeader.setApiLevel(n);
        return foregroundIntentBuilder;
    }
}

