/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.adapter;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.huawei.hms.api.BindingFailedResolution;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.Util;

public class BinderAdapter
implements ServiceConnection {
    private static final String TAG = "BinderAdapter";
    private static final int DELAY_MILLIS = 1800000;
    private static final int BINDER_SYSTEM_ERROR = -1;
    private Context mContext;
    private final String mAction;
    private final String mService;
    private BinderCallBack callback;
    private IBinder serviceBinder;
    private final Object LOCK_CONNECT_TIMEOUT_HANDLER = new Object();
    private boolean bindFail = false;
    private Handler mBinderTimeoutHandler = null;
    private Handler delayDisconnectHandler = null;

    public BinderAdapter(Context context, String string, String string2) {
        this.mContext = context;
        this.mAction = string;
        this.mService = string2;
    }

    private void postConnDelayHandle() {
        Handler handler = this.mBinderTimeoutHandler;
        if (handler != null) {
            handler.removeMessages(this.getConnTimeOut());
        } else {
            this.mBinderTimeoutHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

                public boolean handleMessage(Message message) {
                    if (message != null && message.what == BinderAdapter.this.getConnTimeOut()) {
                        HMSLog.e((String)BinderAdapter.TAG, (String)"In connect, bind core service time out");
                        BinderAdapter.this.binderServiceFailed();
                        return true;
                    }
                    return false;
                }
            });
        }
        this.mBinderTimeoutHandler.sendEmptyMessageDelayed(this.getConnTimeOut(), 10000L);
    }

    private void binderServiceFailed() {
        if ((this = ((BinderAdapter)this).getCallBack()) != null) {
            this.onBinderFailed(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void bindCoreService() {
        Intent intent;
        if (TextUtils.isEmpty((CharSequence)this.mAction) || TextUtils.isEmpty((CharSequence)this.mService)) {
            this.getBindFailPendingIntent();
        }
        BinderAdapter binderAdapter = this;
        Intent intent2 = intent;
        intent2(this.mAction);
        intent.setPackage(this.mService);
        Object object = binderAdapter.LOCK_CONNECT_TIMEOUT_HANDLER;
        synchronized (object) {
            if (binderAdapter.mContext.bindService(intent2, (ServiceConnection)this, 1)) {
                this.postConnDelayHandle();
                return;
            }
            this.bindFail = true;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
            this.getBindFailPendingIntent();
            return;
        }
    }

    private void getBindFailPendingIntent() {
        Intent intent;
        ComponentName componentName;
        BinderAdapter binderAdapter = object;
        HMSLog.e((String)TAG, (String)"In connect, bind core service fail");
        Object object = binderAdapter.mContext.getApplicationInfo().packageName;
        Object object2 = componentName;
        componentName = new ComponentName((String)object, "com.huawei.hms.activity.BridgeActivity");
        object = intent;
        object();
        intent.setComponent((ComponentName)object2);
        intent.putExtra("intent.extra.DELEGATE_CLASS_OBJECT", BindingFailedResolution.class.getName());
        object2 = binderAdapter.getCallBack();
        if (object2 != null) {
            object2.onBinderFailed(-1, (Intent)object);
        }
    }

    private void delayedUnbind() {
        this.delayDisconnectHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(Message message) {
                if (message != null && message.what == binderCallBack.BinderAdapter.this.getMsgDelayDisconnect()) {
                    2 v0 = binderCallBack;
                    HMSLog.i((String)BinderAdapter.TAG, (String)"The serviceConnection has been bind for 60s, need to unbind.");
                    v0.BinderAdapter.this.unBind();
                    BinderCallBack binderCallBack = v0.BinderAdapter.this.getCallBack();
                    if (binderCallBack != null) {
                        binderCallBack.onTimedDisconnected();
                    }
                    return true;
                }
                return false;
            }
        });
        this.delayDisconnectHandler.sendEmptyMessageDelayed(this.getMsgDelayDisconnect(), 1800000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeDelayDisconnectTask() {
        HMSLog.d((String)TAG, (String)"removeDelayDisconnectTask.");
        Class<BinderAdapter> clazz = BinderAdapter.class;
        synchronized (BinderAdapter.class) {
            if (this.delayDisconnectHandler != null) {
                this.delayDisconnectHandler.removeMessages(this.getMsgDelayDisconnect());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancelConnDelayHandle() {
        BinderAdapter binderAdapter = this;
        Object object = binderAdapter.LOCK_CONNECT_TIMEOUT_HANDLER;
        synchronized (object) {
            if (binderAdapter.mBinderTimeoutHandler != null) {
                this.mBinderTimeoutHandler.removeMessages(this.getConnTimeOut());
                this.mBinderTimeoutHandler = null;
            }
            return;
        }
    }

    private BinderCallBack getCallBack() {
        return this.callback;
    }

    public IBinder getServiceBinder() {
        return this.serviceBinder;
    }

    public void unBind() {
        Util.unBindServiceCatchException(this.mContext, this);
    }

    public void binder(BinderCallBack binderCallBack) {
        if (binderCallBack == null) {
            return;
        }
        this.callback = binderCallBack;
        this.bindCoreService();
    }

    protected int getConnTimeOut() {
        return 0;
    }

    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        BinderAdapter binderAdapter = this;
        HMSLog.i((String)TAG, (String)"BinderAdapter Enter onServiceConnected.");
        binderAdapter.serviceBinder = iBinder;
        binderAdapter.cancelConnDelayHandle();
        BinderCallBack binderCallBack = binderAdapter.getCallBack();
        if (binderCallBack != null) {
            binderCallBack.onServiceConnected(componentName, iBinder);
        }
        this.delayedUnbind();
    }

    protected int getMsgDelayDisconnect() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDelayTask() {
        HMSLog.d((String)TAG, (String)"updateDelayTask.");
        Class<BinderAdapter> clazz = BinderAdapter.class;
        synchronized (BinderAdapter.class) {
            block5: {
                if (this.delayDisconnectHandler == null) break block5;
                BinderAdapter binderAdapter = this;
                binderAdapter.delayDisconnectHandler.removeMessages(this.getMsgDelayDisconnect());
                binderAdapter.delayDisconnectHandler.sendEmptyMessageDelayed(this.getMsgDelayDisconnect(), 1800000L);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        HMSLog.i((String)TAG, (String)"Enter onServiceDisconnected.");
        BinderCallBack binderCallBack = this.getCallBack();
        if (binderCallBack != null) {
            binderCallBack.onServiceDisconnected(componentName);
        }
        this.removeDelayDisconnectTask();
    }

    public void onNullBinding(ComponentName componentName) {
        HMSLog.e((String)TAG, (String)"Enter onNullBinding, than unBind.");
        if (((BinderAdapter)((Object)binderCallBack)).bindFail) {
            ((BinderAdapter)((Object)binderCallBack)).bindFail = false;
            return;
        }
        BinderAdapter binderAdapter = binderCallBack;
        binderAdapter.unBind();
        binderAdapter.cancelConnDelayHandle();
        BinderCallBack binderCallBack = binderAdapter.getCallBack();
        if (binderCallBack != null) {
            binderCallBack.onNullBinding(componentName);
        }
    }

    public static interface BinderCallBack {
        public void onServiceConnected(ComponentName var1, IBinder var2);

        public void onBinderFailed(int var1);

        public void onBinderFailed(int var1, Intent var2);

        public void onServiceDisconnected(ComponentName var1);

        public void onNullBinding(ComponentName var1);

        public void onTimedDisconnected();
    }
}

