/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.firebase.inject.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class LazySet<T>
implements Provider<Set<T>> {
    private volatile Set<Provider<T>> providers = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile Set<T> actualSet = null;

    LazySet(Collection<Provider<T>> providers) {
        this.providers.addAll(providers);
    }

    static LazySet<?> fromCollection(Collection<Provider<?>> providers) {
        Set casted = (Set)providers;
        return new LazySet(casted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<T> get() {
        if (this.actualSet == null) {
            LazySet lazySet = this;
            synchronized (lazySet) {
                if (this.actualSet == null) {
                    this.actualSet = Collections.newSetFromMap(new ConcurrentHashMap());
                    this.updateSet();
                }
            }
        }
        return Collections.unmodifiableSet(this.actualSet);
    }

    synchronized void add(Provider<T> newProvider) {
        if (this.actualSet == null) {
            this.providers.add(newProvider);
        } else {
            this.actualSet.add(newProvider.get());
        }
    }

    private synchronized void updateSet() {
        for (Provider<T> provider : this.providers) {
            this.actualSet.add(provider.get());
        }
        this.providers = null;
    }
}

