/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.common.utils;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.Reader;
import java.time.ZoneId;
import java.util.Locale;
import java.util.TimeZone;

public class DeviceUtil {
    private static final String TAG = "DeviceUtil";
    private static String CPU_INFO = "";
    private static String CPU_HARDWARE = "";
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            if (string.startsWith("cpu")) {
                for (int i2 = 3; i2 < string.length(); ++i2) {
                    if (string.charAt(i2) >= '0' && string.charAt(i2) <= '9') {
                        continue;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
    };
    public static String ANDROID_ID;

    public static String getCpuInfo() {
        if (!TextUtils.isEmpty((CharSequence)CPU_INFO)) {
            return CPU_INFO;
        }
        DeviceUtil.matchCpuInfo();
        return CPU_INFO;
    }

    public static String getCpuHardwareInfo() {
        if (!TextUtils.isEmpty((CharSequence)CPU_HARDWARE)) {
            return CPU_HARDWARE;
        }
        DeviceUtil.matchCpuInfo();
        return CPU_HARDWARE;
    }

    /*
     * Unable to fully structure code
     */
    private static void matchCpuInfo() {
        block22: {
            block20: {
                var0 = null;
                var1_1 = v0;
                if (new File("/proc/cpuinfo").exists()) break block20;
                return;
            }
            var2_2 = v1;
            v1 = new FileReader((File)var1_1);
            var1_1 = v2;
            try {
                v2 = new BufferedReader((Reader)var2_2);
            }
            catch (Throwable v10) {
                var1_1 = var0;
            }
            while (true) {
                block21: {
                    var0 = var1_1.readLine();
                    if (var0 == null) break;
                    if (!var0.contains("Processor")) ** GOTO lbl34
                    v3 = var0;
                    var2_2 = v4;
                    v4 = new StringBuilder();
                    var3_3 = v3.indexOf(":");
                    if (var3_3 < 0) break block21;
                    if (var3_3 >= var0.length() - 1) break block21;
                    var2_2.append(var0.substring(var3_3 + 1).trim());
                }
                DeviceUtil.CPU_INFO = var2_2.toString();
lbl34:
                // 2 sources

                if (!var0.contains("Hardware")) continue;
                v5 = var0;
                v6 = v5;
                v7 = v5.indexOf(":");
                DeviceUtil.CPU_HARDWARE = v6.substring(v7 + 1).trim();
                continue;
                break;
            }
lbl42:
            // 2 sources

            while (true) {
                try {
                    var1_1.close();
                }
                catch (Throwable v8) {}
                break block22;
                break;
            }
            catch (Throwable v9) {
            }
            ** while (var1_1 != null)
        }
    }

    public static String getResolution(Context context) {
        Context context2;
        block7: {
            block6: {
                try {
                    if (context.getResources() != null) break block6;
                    return "0*0";
                }
                catch (Throwable throwable) {
                    return "0*0";
                }
            }
            context2 = context2.getResources().getDisplayMetrics();
            if (context2 != null) break block7;
            return "0*0";
        }
        Context context3 = context2;
        Context context4 = context3;
        int n2 = context3.widthPixels;
        int n3 = context4.heightPixels;
        return n2 + "*" + n3;
    }

    public static double getScreenSize(Context context) {
        Context context2;
        try {
            context2 = context.getResources().getDisplayMetrics();
        }
        catch (Throwable throwable) {
            return 0.0;
        }
        float f2 = context2.widthPixels;
        double d2 = f2 / context2.xdpi;
        double d3 = Math.pow(d2, 2.0);
        float f3 = context2.heightPixels;
        double d4 = f3 / context2.ydpi;
        double d5 = d3 + Math.pow(d4, 2.0);
        return Math.sqrt(d5);
    }

    public static long getRamSize(Context context) {
        block5: {
            ActivityManager.MemoryInfo memoryInfo;
            Context context2;
            try {
                if (Build.VERSION.SDK_INT < 16) break block5;
            }
            catch (Throwable throwable) {
                return -1L;
            }
            ActivityManager activityManager = (ActivityManager)context2.getSystemService("activity");
            ActivityManager activityManager2 = activityManager;
            activityManager.getProcessMemoryInfo(new int[]{0});
            context2 = memoryInfo;
            activityManager2.getMemoryInfo(new ActivityManager.MemoryInfo());
            return context2.totalMem / 1024L;
        }
        return -1L;
    }

    public static long getRomSize(Context context) {
        Object object;
        try {
            object = Environment.getDataDirectory().getPath();
        }
        catch (Throwable throwable) {
            return -1L;
        }
        StatFs statFs = new StatFs((String)object);
        StatFs statFs2 = statFs;
        long l2 = statFs.getBlockSize();
        long l3 = statFs2.getBlockCount();
        return l3 * l2 / 1024L;
    }

    public static int getCpuCoreCount() {
        block9: {
            File[] fileArray;
            block8: {
                File[] fileArray2;
                block7: {
                    try {
                        if (Build.VERSION.SDK_INT > 10) break block7;
                        return 1;
                    }
                    catch (Throwable throwable) {
                        return -1;
                    }
                }
                fileArray = fileArray2;
                if (new File("/sys/devices/system/cpu/").exists()) break block8;
                return -1;
            }
            fileArray = fileArray.listFiles(CPU_FILTER);
            if (fileArray == null) break block9;
            if (fileArray.length == 0) break block9;
            return fileArray.length;
        }
        return -1;
    }

    /*
     * Loose catch block
     */
    public static int getCPUMaxFreqKHz() {
        Object object;
        block39: {
            FileInputStream fileInputStream;
            FileInputStream fileInputStream2;
            block37: {
                Object object2;
                block40: {
                    block38: {
                        FileInputStream fileInputStream3;
                        File file;
                        fileInputStream2 = null;
                        int n2 = 0;
                        while (true) {
                            File file2;
                            if (n2 >= DeviceUtil.getCpuCoreCount()) break block37;
                            object = "/sys/devices/system/cpu/cpu" + n2 + "/cpufreq/cpuinfo_max_freq";
                            file = file2;
                            if (new File((String)object).exists()) break;
                            ++n2;
                            continue;
                            break;
                        }
                        object2 = new byte[128];
                        object = fileInputStream3;
                        byte[] byArray = object2;
                        ((FileInputStream)object)(file);
                        if (-1 != fileInputStream3.read(byArray)) break block38;
                        int n3 = -1;
                        try {
                            ((FileInputStream)object).close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            ((FileInputStream)object).close();
                        }
                        catch (Throwable throwable) {}
                        return n3;
                    }
                    int n4 = 0;
                    while (true) {
                        if (object2[n4] < 48) break;
                        if (object2[n4] > 57) break;
                        ++n4;
                        continue;
                        break;
                    }
                    Object object3 = object;
                    n4 = Integer.parseInt(new String((byte[])object2, 0, n4));
                    try {
                        ((FileInputStream)object3).close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (Throwable throwable) {}
                    return n4;
                    catch (Throwable throwable) {
                        object2 = throwable;
                    }
                    break block40;
                    catch (Throwable throwable) {
                        object = fileInputStream2;
                    }
                }
                if (object != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (Throwable throwable) {}
                }
                try {
                    throw object2;
                }
                catch (Throwable throwable) {
                    break block39;
                }
            }
            object = fileInputStream;
            fileInputStream = new FileInputStream("/proc/cpuinfo");
            int n5 = DeviceUtil.parseFileForValue("cpu MHz", (FileInputStream)object) * 1000;
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable) {}
            return n5;
            catch (Throwable throwable) {
                object = fileInputStream2;
            }
        }
        int n6 = -1;
        if (object != null) {
            try {
                ((FileInputStream)object).close();
            }
            catch (Throwable throwable) {}
        }
        return n6;
    }

    private static int parseFileForValue(String textToMatch, FileInputStream stream) {
        int n2;
        FileInputStream fileInputStream = stream;
        byte[] byArray = new byte[1024];
        try {
            n2 = fileInputStream.read(byArray);
        }
        catch (Throwable throwable) {
            return -1;
        }
        block8: for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] != 10 && i2 != 0) continue;
            if (byArray[i2] == 10) {
                // empty if block
            }
            int n3 = ++i2;
            while (n3 < n2) {
                String string;
                int n4 = n3++;
                int n5 = n4 - i2;
                if (byArray[n4] != string.charAt(n5)) continue block8;
                if (n5 != string.length() - 1) continue;
                return DeviceUtil.extractValue(byArray, n3);
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int extractValue(byte[] buffer, int index) {
        void var2_3;
        void var1_2;
        byte[] byArray;
        try {
            block7: {
                while (index < byArray.length && byArray[var1_2] != 10) {
                    if (byArray[var1_2] >= 48 && byArray[var1_2] <= 57) {
                        break block7;
                    }
                    ++var1_2;
                }
                return -1;
            }
            for (var2_3 = var1_2 + true; var2_3 < byArray.length && byArray[var2_3] >= 48 && byArray[var2_3] <= 57; ++var2_3) {
            }
        }
        catch (Throwable throwable) {
            return -1;
        }
        void var0_1 = var2_3 - var1_2;
        return Integer.parseInt(new String(byArray, 0, (int)var1_2, (int)var0_1));
    }

    public static String getCarrier(Context context) {
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static String getNetworkOperator(Context context) {
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperator();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static String getTimeZone() {
        long l2 = TimeZone.getDefault().getRawOffset() / 3600000;
        long l3 = l2 - 0L;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        return (l4 > 0 ? "+" + l2 : (l4 < 0 ? "-" + l2 : "" + l2)).replace("--", "-");
    }

    public static String getTimeZoneId() {
        if (Build.VERSION.SDK_INT >= 26) {
            return ZoneId.systemDefault().getId();
        }
        return TimeZone.getDefault().getID();
    }

    public static String getSystemVersionRelease() {
        return String.format(Locale.ENGLISH, Build.VERSION.RELEASE, new Object[0]);
    }

    public static int getSystemVersionSdkInt() {
        return Build.VERSION.SDK_INT;
    }

    public static String getSystemDevice() {
        return Build.DEVICE.toLowerCase();
    }

    public static String getModel() {
        return String.format(Locale.ENGLISH, Build.MODEL, new Object[0]);
    }

    public static String getBrand() {
        return String.format(Locale.ENGLISH, Build.BRAND, new Object[0]);
    }

    public static String getProduct() {
        return String.format(Locale.ENGLISH, Build.PRODUCT, new Object[0]);
    }

    public static String getManufacturer() {
        return String.format(Locale.ENGLISH, Build.MANUFACTURER, new Object[0]);
    }

    public static String getLanguage(Context context) {
        return context.getResources().getConfiguration().locale.toString();
    }

    public static String getCountryCodeByLocale() {
        return Locale.getDefault().getCountry();
    }

    public static String getAndroidId(Context context) {
        Context context2;
        String string = ANDROID_ID;
        if (string != null) {
            return string;
        }
        ANDROID_ID = Settings.Secure.getString((ContentResolver)context2.getContentResolver(), (String)"android_id");
        return ANDROID_ID;
    }
}

