/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.platform.honor.business;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.engagelab.privates.common.api.MTCommonPrivatesApi;
import com.engagelab.privates.common.global.MTGlobal;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.push.api.MTPushPrivatesApi;
import com.engagelab.privates.push.api.PlatformTokenMessage;
import com.hihonor.push.sdk.HonorPushCallback;
import com.hihonor.push.sdk.HonorPushClient;

public class MTHonorBusiness {
    private static final String TAG = "MTHonorBusiness";
    private static final String HONOR_APPID = "com.hihonor.push.app_id";
    private boolean isSupport;
    private static volatile MTHonorBusiness instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MTHonorBusiness getInstance() {
        if (instance != null) return instance;
        Class<MTHonorBusiness> clazz = MTHonorBusiness.class;
        synchronized (MTHonorBusiness.class) {
            instance = new MTHonorBusiness();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(final Context context) {
        try {
            this.isSupport = this.isSupportHonorPush(context);
            if (!this.isSupport) {
                MTCommonLog.e((String)TAG, (String)"not support honor push");
                this.onNode(context, 3002, 0, 3900, 1);
                return;
            }
            MTCommonLog.d((String)TAG, (String)"support honor push");
            HonorPushClient.getInstance().init(context, false);
            HonorPushClient.getInstance().getPushToken((HonorPushCallback)new HonorPushCallback<String>(){

                public void onSuccess(String pushToken) {
                    if (!TextUtils.isEmpty((CharSequence)pushToken)) {
                        MTCommonLog.d((String)MTHonorBusiness.TAG, (String)("onTokenSuccess:get token is " + pushToken));
                        MTHonorBusiness.this.onToken(context, pushToken, 1);
                    } else {
                        MTCommonLog.d((String)MTHonorBusiness.TAG, (String)"onTokenFailed:get token is empty");
                        MTHonorBusiness.this.onNode(context, 3003, 0, 3900, 1);
                    }
                }

                public void onFailure(int errorCode, String errorString) {
                    MTCommonLog.d((String)MTHonorBusiness.TAG, (String)("onTokenFailed:get token fail code: " + errorCode));
                    MTHonorBusiness.this.onNode(context, 3003, 0, 3900, 1);
                }
            });
        }
        catch (Throwable throwable) {
            this.isSupport = false;
            MTCommonLog.e((String)TAG, (String)("init failed " + throwable.getMessage()));
        }
    }

    private boolean isSupportHonorPush(Context context) {
        try {
            String appId = MTGlobal.getMetaData((Context)context, (String)HONOR_APPID);
            if (TextUtils.isEmpty((CharSequence)appId)) {
                MTCommonLog.e((String)TAG, (String)"not support honor push, honor appId is empty");
                return false;
            }
            boolean isSupport = HonorPushClient.getInstance().checkSupportHonorPush(context.getApplicationContext());
            MTCommonLog.d((String)TAG, (String)("honor available :" + isSupport));
            return isSupport;
        }
        catch (Throwable throwable) {
            MTCommonLog.d((String)TAG, (String)("isSupportHonorPush error:" + throwable));
            return false;
        }
    }

    public void onToken(Context context, String token, int from) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            MTCommonLog.d((String)TAG, (String)"onToken:token is empty");
            return;
        }
        PlatformTokenMessage platformTokenMessage = new PlatformTokenMessage().setPlatform((byte)7).setToken(token);
        Bundle bundle = new Bundle();
        bundle.putParcelable("message", (Parcelable)platformTokenMessage);
        MTPushPrivatesApi.init((Context)context);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context.getApplicationContext(), (int)3021, (Bundle)bundle);
        this.onNode(context, 3008, 0, 3901, from);
    }

    public void onNode(Context context, int code, int mCode, int type, int from) {
        Bundle bundle = new Bundle();
        bundle.putByte("platform", (byte)7);
        bundle.putInt("code", code);
        bundle.putInt("mCode", mCode);
        bundle.putInt("type", type);
        bundle.putInt("from", from);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context, (int)3022, (Bundle)bundle);
    }
}

