/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.platform.meizu.business;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.engagelab.privates.common.api.MTCommonPrivatesApi;
import com.engagelab.privates.common.global.MTGlobal;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.common.utils.SM4Util;
import com.engagelab.privates.push.api.MTPushPrivatesApi;
import com.engagelab.privates.push.api.NotificationMessage;
import com.engagelab.privates.push.api.PlatformTokenMessage;
import com.engagelab.privates.push.utils.NotificationUtil;
import com.meizu.cloud.pushsdk.PushManager;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import org.json.JSONObject;

public class MTMeizuBusiness {
    private static final String TAG = "MTMeizuBusiness";
    private static final String MEIZU_APPID = "MEIZU_APPID";
    private static final String MEIZU_APPKEY = "MEIZU_APPKEY";
    private boolean isSupport;
    private String appId;
    private String appKey;
    private String token;
    private static volatile MTMeizuBusiness instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MTMeizuBusiness getInstance() {
        if (instance != null) return instance;
        Class<MTMeizuBusiness> clazz = MTMeizuBusiness.class;
        synchronized (MTMeizuBusiness.class) {
            instance = new MTMeizuBusiness();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context, Bundle bundle) {
        try {
            this.appId = this.getAppId(context, bundle);
            if (TextUtils.isEmpty((CharSequence)this.appId)) {
                this.isSupport = false;
                MTCommonLog.e((String)TAG, (String)"not support meizu push, meizu appId is empty");
                return;
            }
            this.appKey = this.getAppKey(context, bundle);
            if (TextUtils.isEmpty((CharSequence)this.appKey)) {
                this.isSupport = false;
                MTCommonLog.e((String)TAG, (String)"not support meizu push, meizu appKey is empty");
                return;
            }
            this.isSupport = true;
            MTCommonLog.d((String)TAG, (String)"support meizu push");
            PushManager.register((Context)context, (String)this.appId, (String)this.appKey);
            String token = PushManager.getPushId((Context)context);
            if (TextUtils.isEmpty((CharSequence)token)) {
                MTCommonLog.d((String)TAG, (String)"onTokenFailed:get token is empty");
                this.onNode(context, 3003, 0, 3900, 1);
                return;
            }
            this.onToken(context, token, 1);
        }
        catch (Throwable throwable) {
            this.isSupport = false;
            MTCommonLog.e((String)TAG, (String)("init failed " + throwable.getMessage()));
        }
    }

    private String getAppId(Context context, Bundle bundle) {
        String appId = null;
        try {
            String metaData;
            if (null != bundle && bundle.containsKey(MEIZU_APPID)) {
                String bundleString = bundle.getString(MEIZU_APPID);
                if (TextUtils.isEmpty((CharSequence)bundleString)) {
                    MTCommonLog.w((String)TAG, (String)"api config : MEIZU_APPID - not empty !");
                } else {
                    appId = bundleString.substring(3);
                }
            }
            if (TextUtils.isEmpty(appId) && !TextUtils.isEmpty((CharSequence)(metaData = MTGlobal.getMetaData((Context)context, (String)MEIZU_APPID)))) {
                appId = metaData.substring(3);
            }
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)(" config info error: MEIZU_APPID - " + e));
        }
        return appId;
    }

    private String getAppKey(Context context, Bundle bundle) {
        String appKey = null;
        try {
            String metaData;
            if (null != bundle && bundle.containsKey(MEIZU_APPKEY)) {
                String bundleString = bundle.getString(MEIZU_APPKEY);
                if (TextUtils.isEmpty((CharSequence)bundleString)) {
                    MTCommonLog.w((String)TAG, (String)"api config : MEIZU_APPKEY - not empty !");
                } else {
                    appKey = bundleString.substring(3);
                }
            }
            if (TextUtils.isEmpty(appKey) && !TextUtils.isEmpty((CharSequence)(metaData = MTGlobal.getMetaData((Context)context, (String)MEIZU_APPKEY)))) {
                appKey = metaData.substring(3);
            }
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)(" config info error: MEIZU_APPKEY - " + e));
        }
        return appKey;
    }

    public void onToken(Context context, String token, int from) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            MTCommonLog.d((String)TAG, (String)"onToken:token is empty");
            return;
        }
        this.token = token;
        PlatformTokenMessage platformTokenMessage = new PlatformTokenMessage().setPlatform((byte)3).setToken(token);
        Bundle bundle = new Bundle();
        bundle.putParcelable("message", (Parcelable)platformTokenMessage);
        MTPushPrivatesApi.init((Context)context);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context.getApplicationContext(), (int)3021, (Bundle)bundle);
        this.onNode(context, 3008, 0, 3901, from);
    }

    public void onNode(Context context, int code, int mCode, int type, int from) {
        Bundle bundle = new Bundle();
        bundle.putByte("platform", (byte)3);
        bundle.putInt("code", code);
        bundle.putInt("mCode", mCode);
        bundle.putInt("type", type);
        bundle.putInt("from", from);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context, (int)3022, (Bundle)bundle);
    }

    public void onNotificationMessage(Context context, int what, MzPushMessage message) {
        try {
            boolean notificationState;
            String defineContent = message.getSelfDefineContentString();
            if (TextUtils.isEmpty((CharSequence)defineContent)) {
                MTCommonLog.d((String)TAG, (String)"onNotificationMessage failed, defineContent is empty");
                return;
            }
            JSONObject defineContentJson = new JSONObject(defineContent);
            switch (what) {
                case 3002: {
                    MTCommonLog.d((String)TAG, (String)("onNotificationMessageArrived:" + MTCommonLog.toLogString((JSONObject)defineContentJson)));
                    break;
                }
                case 3003: {
                    MTCommonLog.d((String)TAG, (String)("onNotificationMessageClicked:" + MTCommonLog.toLogString((JSONObject)defineContentJson)));
                    break;
                }
                case 3004: {
                    MTCommonLog.d((String)TAG, (String)("onNotificationMessageDeleted:" + MTCommonLog.toLogString((JSONObject)defineContentJson)));
                    break;
                }
                default: {
                    MTCommonLog.d((String)TAG, (String)("onNotificationMessage:" + MTCommonLog.toLogString((JSONObject)defineContentJson)));
                }
            }
            String messageExtraKey = "MTMessageExtra";
            if (defineContentJson.has("MTMessageExtra")) {
                messageExtraKey = "MTMessageExtra";
            } else if (defineContentJson.has("JMessageExtra")) {
                messageExtraKey = "JMessageExtra";
            }
            String messageString = defineContentJson.optString(messageExtraKey);
            messageString = SM4Util.decodeMessage((String)messageString);
            if (TextUtils.isEmpty((CharSequence)messageString)) {
                return;
            }
            JSONObject messageJson = new JSONObject(messageString);
            String messageId = NotificationUtil.getMessageId((JSONObject)messageJson);
            if (TextUtils.isEmpty((CharSequence)messageId)) {
                return;
            }
            JSONObject contentJson = messageJson;
            if (messageJson.has("m_content")) {
                contentJson = messageJson.optJSONObject("m_content");
            }
            if (contentJson == null) {
                return;
            }
            String title = contentJson.optString("n_title");
            String content = contentJson.optString("n_content");
            String intentUri = contentJson.optString("n_intent_url");
            Bundle extras = NotificationUtil.convertJsonToBundle((JSONObject)contentJson.optJSONObject("n_extras"));
            NotificationMessage notificationMessage = new NotificationMessage().setMessageId(messageId).setPlatform((byte)3).setPlatformMessageId(message.getTaskId()).setNotificationId(message.getNotifyId()).setTitle(title).setContent(content).setExtras(extras).setIntentUri(intentUri);
            Bundle bundle = new Bundle();
            bundle.putParcelable("message", (Parcelable)notificationMessage);
            MTPushPrivatesApi.init((Context)context);
            MTCommonPrivatesApi.sendMessageToMainProcess((Context)context.getApplicationContext(), (int)what, (Bundle)bundle);
            if (what == 3002 && (notificationState = NotificationUtil.getNotificationState((Context)context))) {
                Bundle messageBundle = new Bundle();
                messageBundle.putParcelable("message", (Parcelable)notificationMessage);
                MTCommonPrivatesApi.sendMessageToRemoteProcess((Context)context, (int)3500, (Bundle)messageBundle);
            }
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("onNotificationMessage failed " + throwable.getMessage()));
        }
    }

    public void turnOnPush(Context context) {
        try {
            if (!this.isSupport) {
                return;
            }
            PushManager.switchPush((Context)context, (String)this.appId, (String)this.appKey, (String)this.token, (boolean)true);
            this.onNode(context, 3101, 0, 3902, 0);
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("turnOnPush failed " + throwable.getMessage()));
        }
    }

    public void turnOffPush(Context context) {
        try {
            if (!this.isSupport) {
                return;
            }
            PushManager.switchPush((Context)context, (String)this.appId, (String)this.appKey, (String)this.token, (boolean)false);
            this.onNode(context, 3102, 0, 3903, 0);
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("turnOffPush failed " + throwable.getMessage()));
        }
    }

    public void clearNotification(Context context, Bundle bundle) {
        try {
            if (!this.isSupport) {
                return;
            }
            int notifyId = bundle.getInt("notification_id");
            PushManager.clearNotification((Context)context, (int[])new int[]{notifyId});
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("clearNotification failed " + throwable.getMessage()));
        }
    }
}

