/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.utils;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.engagelab.privates.common.log.MTCommonLog;
import java.lang.ref.WeakReference;

public class ActivityUtil {
    private static final String TAG = "AcrivityUtil";
    private static WeakReference<Activity> currentActivityRef;
    private static boolean isCallbackRegistered = false;
    private static final Application.ActivityLifecycleCallbacks activityLifecycleCallbacks;

    public static void registerActivityLifecycleCallbacks(Context context) {
        Context context2;
        if (!isCallbackRegistered && context2 != null) {
            try {
                ((Application)context2.getApplicationContext()).registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
                isCallbackRegistered = true;
                MTCommonLog.d(TAG, "Activity lifecycle callbacks registered successfully");
            }
            catch (Throwable throwable) {
                MTCommonLog.w(TAG, "Failed to register activity lifecycle callbacks: " + throwable.getMessage());
            }
        }
    }

    public static Activity getCurrentActivity() {
        WeakReference<Activity> weakReference = currentActivityRef;
        return weakReference != null ? (Activity)weakReference.get() : null;
    }

    static {
        activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle bundle) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                currentActivityRef = new WeakReference<Activity>(activity);
                MTCommonLog.d(ActivityUtil.TAG, "Current activity updated: " + activity.getClass().getName());
            }

            public void onActivityPaused(Activity activity) {
                if (currentActivityRef != null && currentActivityRef.get() == activity) {
                    currentActivityRef = null;
                    MTCommonLog.d(ActivityUtil.TAG, "Current activity cleared: " + activity.getClass().getName());
                }
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            }

            public void onActivityDestroyed(Activity activity) {
                if (currentActivityRef != null && currentActivityRef.get() == activity) {
                    currentActivityRef = null;
                    MTCommonLog.d(ActivityUtil.TAG, "Current activity destroyed: " + activity.getClass().getName());
                }
            }
        };
    }
}

