/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.api;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.view.View;
import com.huawei.hms.api.Api;
import com.huawei.hms.api.CheckUpdatelistener;
import com.huawei.hms.api.ConnectionResult;
import com.huawei.hms.api.HuaweiApiClientImpl;
import com.huawei.hms.common.internal.AutoLifecycleFragment;
import com.huawei.hms.common.internal.Preconditions;
import com.huawei.hms.support.api.client.AidlApiClient;
import com.huawei.hms.support.api.client.PendingResult;
import com.huawei.hms.support.api.client.Status;
import com.huawei.hms.support.api.client.SubAppInfo;
import com.huawei.hms.support.api.entity.auth.PermissionInfo;
import com.huawei.hms.support.api.entity.auth.Scope;
import com.huawei.hms.support.hianalytics.HiAnalyticsUtil;
import com.huawei.hms.utils.Checker;
import com.huawei.hms.utils.HMSBIInitializer;
import com.huawei.hms.utils.ResourceLoaderUtil;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class HuaweiApiClient
implements AidlApiClient {
    public abstract void connect(Activity var1);

    public abstract void connectForeground();

    public abstract void disconnect();

    public abstract List<Scope> getScopes();

    public abstract List<PermissionInfo> getPermissionInfos();

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void setConnectionCallbacks(ConnectionCallbacks var1);

    public abstract void setConnectionFailedListener(OnConnectionFailedListener var1);

    public abstract boolean setSubAppInfo(SubAppInfo var1);

    public abstract void checkUpdate(Activity var1, CheckUpdatelistener var2);

    public abstract void onResume(Activity var1);

    public abstract void onPause(Activity var1);

    public abstract Activity getTopActivity();

    public abstract Map<Api<?>, Api.ApiOptions> getApiMap();

    public abstract boolean hasConnectionSuccessListener(ConnectionCallbacks var1);

    public abstract boolean hasConnectionFailureListener(OnConnectionFailedListener var1);

    public abstract void removeConnectionSuccessListener(ConnectionCallbacks var1);

    public abstract void removeConnectionFailureListener(OnConnectionFailedListener var1);

    public abstract ConnectionResult holdUpConnect();

    public abstract ConnectionResult holdUpConnect(long var1, TimeUnit var3);

    public abstract PendingResult<Status> discardAndReconnect();

    public abstract void print(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public abstract ConnectionResult getConnectionResult(Api<?> var1);

    public abstract void reconnect();

    public abstract boolean hasConnectedApi(Api<?> var1);

    public void connect(int n) {
        throw new UnsupportedOperationException();
    }

    public abstract void disableLifeCycleManagement(Activity var1);

    public static final class Builder {
        private final Context a;
        private final List<Scope> b;
        private final List<PermissionInfo> c;
        private final Map<Api<?>, Api.ApiOptions> d;
        private OnConnectionFailedListener e;
        private ConnectionCallbacks f;
        private int g;
        private Activity h;

        public Builder(Context context) throws NullPointerException {
            Context context2 = context;
            this.b = new ArrayList<Scope>();
            this.c = new ArrayList<PermissionInfo>();
            this.d = new HashMap();
            Checker.checkNonNull((Object)context2, (String)"context must not be null.");
            this.a = context2.getApplicationContext();
            this.g = -1;
            ResourceLoaderUtil.setmContext((Context)this.a);
            this.a(context);
        }

        private void a(Context context) {
            HMSBIInitializer.getInstance((Context)context).initBI();
        }

        private void a(HuaweiApiClient huaweiApiClient) {
            AutoLifecycleFragment.getInstance(this.h).startAutoMange(this.g, huaweiApiClient);
        }

        public HuaweiApiClient build() {
            HuaweiApiClientImpl huaweiApiClientImpl;
            Builder builder = this;
            builder.addApi((Api<? extends Api.ApiOptions.NotRequiredOptions>)new Api("Core.API"));
            HuaweiApiClientImpl huaweiApiClientImpl2 = huaweiApiClientImpl;
            huaweiApiClientImpl2(this.a);
            huaweiApiClientImpl2.setScopes(this.b);
            huaweiApiClientImpl2.setPermissionInfos(this.c);
            huaweiApiClientImpl2.setApiMap(this.d);
            huaweiApiClientImpl2.setConnectionCallbacks(this.f);
            huaweiApiClientImpl2.setConnectionFailedListener(this.e);
            huaweiApiClientImpl.setAutoLifecycleClientId(this.g);
            if (builder.g >= 0) {
                this.a(huaweiApiClientImpl2);
            }
            return huaweiApiClientImpl2;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks connectionCallbacks) {
            ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
            Checker.checkNonNull((Object)connectionCallbacks2, (String)"listener must not be null.");
            this.f = connectionCallbacks2;
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener onConnectionFailedListener) {
            OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
            Checker.checkNonNull((Object)onConnectionFailedListener2, (String)"listener must not be null.");
            this.e = onConnectionFailedListener2;
            return this;
        }

        public Builder addScope(Scope scope) {
            Builder builder = this;
            Checker.checkNonNull((Object)scope, (String)"scope must not be null.");
            builder.b.add(scope);
            return builder;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.d.put(api, null);
            if ("HuaweiGame.API".equals(api.getApiName())) {
                HiAnalyticsUtil.getInstance().onEvent(this.a.getApplicationContext(), "15060106", "|" + System.currentTimeMillis());
            }
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> object, O o) {
            Checker.checkNonNull(object, (String)"Api must not be null");
            Checker.checkNonNull(o, (String)"Null options are not permitted for this Api");
            this.d.put((Api<?>)object, (Api.ApiOptions)o);
            if (object.getOptions() != null) {
                Api<O> api = object;
                object = object.getOptions().getScopeList(o);
                this.b.addAll((Collection<Scope>)object);
                object = api.getOptions().getPermissionInfoList(o);
                this.c.addAll((Collection<PermissionInfo>)object);
            }
            return this;
        }

        public Builder setAccountName(String string) {
            return this;
        }

        public Builder setPopupsGravity(int n) {
            return this;
        }

        public Builder setHandler(Handler handler) {
            return this;
        }

        public Builder setViewForPopups(View view) {
            return this;
        }

        public Builder applyDefaultAccount() {
            return this;
        }

        public Builder addApiWithScope(Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopeArray) {
            ArrayList<Scope> arrayList;
            Builder builder = arrayList2;
            Checker.checkNonNull(api, (String)"Api must not be null");
            Checker.checkNonNull((Object)scopeArray, (String)"Scopes must not be null");
            builder.d.put(api, null);
            ArrayList<Scope> arrayList2 = arrayList;
            arrayList = new ArrayList<Scope>(Arrays.asList(scopeArray));
            builder.b.addAll((Collection<Scope>)arrayList2);
            return builder;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApiWithScope(Api<O> object, O o, Scope ... scopeArray) {
            ArrayList<Scope> arrayList;
            Checker.checkNonNull(object, (String)"Api must not be null");
            Checker.checkNonNull(o, (String)"Null options are not permitted for this Api");
            Checker.checkNonNull((Object)scopeArray, (String)"Scopes must not be null");
            ((Builder)((Object)arrayList2)).d.put((Api<?>)object, (Api.ApiOptions)o);
            if (object.getOptions() != null) {
                Api<O> api = object;
                object = object.getOptions().getScopeList(o);
                ((Builder)((Object)arrayList2)).b.addAll((Collection<Scope>)object);
                object = api.getOptions().getPermissionInfoList(o);
                ((Builder)((Object)arrayList2)).c.addAll((Collection<PermissionInfo>)object);
            }
            Builder builder = arrayList2;
            ArrayList<Scope> arrayList2 = arrayList;
            arrayList = new ArrayList<Scope>(Arrays.asList(scopeArray));
            builder.b.addAll((Collection<Scope>)arrayList2);
            return builder;
        }

        public Builder allowLifeCycleManagement(Activity activity, int n, OnConnectionFailedListener onConnectionFailedListener) {
            if (n >= 0) {
                this.g = n;
                this.h = (Activity)Preconditions.checkNotNull((Object)activity, (Object)"activity must not be Null.");
                return this;
            }
            throw new IllegalArgumentException("allowLifeCycleManagement id should be positive");
        }

        public Builder allowLifeCycleManagement(Activity activity, OnConnectionFailedListener onConnectionFailedListener) {
            return this.allowLifeCycleManagement(activity, 0, onConnectionFailedListener);
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;
        public static final int CAUSE_API_CLIENT_EXPIRED = 3;

        public void onConnected();

        public void onConnectionSuspended(int var1);
    }
}

