/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.push;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.huawei.hms.push.b;
import com.huawei.hms.push.s;
import com.huawei.hms.push.utils.DateUtil;
import com.huawei.hms.push.utils.JsonUtil;
import com.huawei.hms.push.w;
import com.huawei.hms.push.x;
import com.huawei.hms.support.api.push.PushException;
import com.huawei.hms.support.log.HMSLog;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteMessage
implements Parcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    public static final String[] a = new String[0];
    public static final int[] b = new int[0];
    public static final long[] c = new long[0];
    public static final HashMap<String, Object> d = new HashMap(8);
    public static final HashMap<String, Object> e;
    public static final HashMap<String, Object> f;
    public static final HashMap<String, Object> g;
    public static final HashMap<String, Object> h;
    public static final Parcelable.Creator<RemoteMessage> CREATOR;
    public Bundle i;
    public Notification j;

    public RemoteMessage(Bundle bundle) {
        this.i = this.a(bundle);
    }

    public RemoteMessage(Parcel parcel) {
        this.i = parcel.readBundle();
        this.j = (Notification)parcel.readSerializable();
    }

    public static JSONObject b(Bundle object) {
        try {
            object = w.a(object.getByteArray("message_body"));
            return new JSONObject((String)object);
        }
        catch (JSONException jSONException) {
            HMSLog.w((String)"RemoteMessage", (String)"JSONException:parse message body failed.");
            return null;
        }
    }

    public static JSONObject a(JSONObject jSONObject) {
        if (jSONObject != null) {
            return jSONObject.optJSONObject("msgContent");
        }
        return null;
    }

    public static JSONObject d(JSONObject jSONObject) {
        if (jSONObject != null) {
            return jSONObject.optJSONObject("psContent");
        }
        return null;
    }

    public static JSONObject b(JSONObject jSONObject) {
        if (jSONObject != null) {
            return jSONObject.optJSONObject("notifyDetail");
        }
        return null;
    }

    public static JSONObject c(JSONObject jSONObject) {
        if (jSONObject != null) {
            return jSONObject.optJSONObject("param");
        }
        return null;
    }

    static {
        d.put("from", "");
        d.put("collapseKey", "");
        d.put("sendTime", "");
        d.put("ttl", 86400);
        d.put("urgency", 2);
        d.put("oriUrgency", 2);
        d.put("sendMode", 0);
        d.put("receiptMode", 0);
        e = new HashMap(8);
        e.put("title_loc_key", "");
        e.put("body_loc_key", "");
        e.put("notifyIcon", "");
        e.put("title_loc_args", a);
        e.put("body_loc_args", a);
        e.put("ticker", "");
        e.put("notifyTitle", "");
        e.put("content", "");
        f = new HashMap(8);
        f.put("icon", "");
        f.put("color", "");
        f.put("sound", "");
        f.put("defaultLightSettings", 1);
        f.put("lightSettings", b);
        f.put("defaultSound", 1);
        f.put("defaultVibrateTimings", 1);
        f.put("vibrateTimings", c);
        g = new HashMap(8);
        g.put("tag", "");
        g.put("when", "");
        g.put("localOnly", 1);
        g.put("badgeSetNum", "");
        g.put("priority", "");
        g.put("autoCancel", 1);
        g.put("visibility", "");
        g.put("channelId", "");
        h = new HashMap(3);
        h.put("acn", "");
        h.put("intentUri", "");
        h.put("url", "");
        CREATOR = new b();
    }

    public String getFrom() {
        return this.i.getString("from");
    }

    public String getTo() {
        return this.i.getString("to");
    }

    public String getAnalyticInfo() {
        return this.i.getString("analyticInfo");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> getAnalyticInfoMap() {
        HashMap hashMap;
        RemoteMessage remoteMessage = hashMap2;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        Object object = remoteMessage.i.getString("analyticInfo");
        if (object == null || ((String)object).trim().isEmpty()) return hashMap2;
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject;
            object = new JSONObject((String)object).keys();
            while (object.hasNext()) {
                String string = String.valueOf(object.next());
                hashMap2.put(string, String.valueOf(jSONObject2.get(string)));
            }
            return hashMap2;
        }
        catch (JSONException jSONException) {
            HMSLog.w((String)"RemoteMessage", (String)"JSONException: get analyticInfo from map failed.");
        }
        return hashMap2;
    }

    public String getData() {
        return this.i.getString("data");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> getDataOfMap() {
        HashMap hashMap;
        RemoteMessage remoteMessage = hashMap2;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        Object object = remoteMessage.i.getString("data");
        if (object == null || ((String)object).trim().isEmpty()) return hashMap2;
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject;
            object = new JSONObject((String)object).keys();
            while (object.hasNext()) {
                String string = String.valueOf(object.next());
                hashMap2.put(string, String.valueOf(jSONObject2.get(string)));
            }
            return hashMap2;
        }
        catch (JSONException jSONException) {
            HMSLog.w((String)"RemoteMessage", (String)"JSONException: get data from map failed");
        }
        return hashMap2;
    }

    public String getCollapseKey() {
        return this.i.getString("collapseKey");
    }

    public String getMessageId() {
        return this.i.getString("msgId");
    }

    public String getMessageType() {
        return this.i.getString("message_type");
    }

    public long getSentTime() {
        long l2;
        block5: {
            long l3;
            block4: {
                Bundle bundle;
                l3 = 0L;
                try {
                    bundle = ((RemoteMessage)((Object)string)).i;
                }
                catch (NumberFormatException numberFormatException) {
                    HMSLog.w((String)"RemoteMessage", (String)"NumberFormatException: get sendTime error.");
                    return l3;
                }
                String string = bundle.getString("sendTime");
                if (TextUtils.isEmpty((CharSequence)string)) break block4;
                l2 = Long.parseLong(string);
                break block5;
            }
            l2 = l3;
        }
        return l2;
    }

    public int getTtl() {
        return this.i.getInt("ttl");
    }

    public int getSendMode() {
        return this.i.getInt("sendMode");
    }

    public int getReceiptMode() {
        return this.i.getInt("receiptMode");
    }

    public int getOriginalUrgency() {
        int n2 = this.i.getInt("oriUrgency");
        if (n2 != 1 && n2 != 2) {
            return 0;
        }
        return n2;
    }

    public int getUrgency() {
        int n2 = this.i.getInt("urgency");
        if (n2 != 1 && n2 != 2) {
            return 0;
        }
        return n2;
    }

    public String getToken() {
        return this.i.getString("device_token");
    }

    public Notification getNotification() {
        RemoteMessage remoteMessage = this;
        Bundle bundle = remoteMessage.i.getBundle("notification");
        if (remoteMessage.j == null && bundle != null) {
            this.j = new Notification(bundle, null);
        }
        if (this.j == null) {
            this.j = new Notification(new Bundle(), null);
        }
        return this.j;
    }

    public final int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeBundle(this.i);
        parcel.writeSerializable((Serializable)this.j);
    }

    public final Bundle a(Bundle object) {
        JSONObject jSONObject;
        Bundle bundle;
        Bundle bundle2 = object;
        Object object2 = bundle;
        bundle = new Bundle();
        JSONObject jSONObject2 = RemoteMessage.b(bundle2);
        JSONObject jSONObject3 = jSONObject = RemoteMessage.a(jSONObject2);
        String string = JsonUtil.getString(jSONObject3, "data", null);
        object2.putString("analyticInfo", JsonUtil.getString(jSONObject3, "analyticInfo", null));
        object2.putString("device_token", object.getString("device_token"));
        JSONObject jSONObject4 = RemoteMessage.d(jSONObject);
        JSONObject jSONObject5 = RemoteMessage.b(jSONObject4);
        JSONObject jSONObject6 = RemoteMessage.c(jSONObject4);
        if (bundle2.getInt("inputType") == 1 && s.a(jSONObject, jSONObject4, string)) {
            Bundle bundle3 = object2;
            bundle3.putString("data", w.a(object.getByteArray("message_body")));
            return bundle3;
        }
        Bundle bundle4 = object2;
        RemoteMessage remoteMessage = string2;
        Bundle bundle5 = object2;
        Bundle bundle6 = object;
        String string2 = bundle6.getString("to");
        object = bundle6.getString("message_type");
        object2 = JsonUtil.getString(jSONObject, "msgId", null);
        bundle5.putString("to", string2);
        bundle5.putString("data", string);
        bundle5.putString("msgId", (String)object2);
        bundle5.putString("message_type", (String)object);
        JsonUtil.transferJsonObjectToBundle(jSONObject2, bundle5, d);
        bundle4.putBundle("notification", remoteMessage.a(jSONObject2, jSONObject, jSONObject4, jSONObject5, jSONObject6));
        return bundle4;
    }

    public final Bundle a(JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4, JSONObject jSONObject5) {
        Bundle bundle;
        RemoteMessage remoteMessage = this = bundle;
        remoteMessage();
        JsonUtil.transferJsonObjectToBundle(jSONObject3, (Bundle)remoteMessage, e);
        JsonUtil.transferJsonObjectToBundle(jSONObject4, (Bundle)this, f);
        JsonUtil.transferJsonObjectToBundle(jSONObject, (Bundle)this, g);
        JsonUtil.transferJsonObjectToBundle(jSONObject5, (Bundle)this, h);
        bundle.putInt("notifyId", JsonUtil.getInt(jSONObject2, "notifyId", 0));
        return bundle;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessagePriority {
    }

    public static class Builder {
        public final Bundle a;
        public final Map<String, String> b;

        public Builder(String string) {
            Builder builder = this;
            builder.a = new Bundle();
            builder.b = new HashMap<String, String>();
            builder.a.putString("to", string);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RemoteMessage build() {
            JSONObject jSONObject;
            Bundle bundle;
            Bundle bundle2 = bundle;
            bundle = new Bundle();
            JSONObject jSONObject2 = jSONObject;
            jSONObject = new JSONObject();
            try {
                for (JSONObject jSONObject3 : this.b.entrySet()) {
                    jSONObject2.put(jSONObject3.getKey(), (Object)jSONObject3.getValue());
                }
            }
            catch (JSONException jSONException) {
                HMSLog.w((String)"RemoteMessage", (String)"JSONException: parse data to json failed.");
                throw new PushException("send message failed");
            }
            try {
                JSONObject jSONObject4;
                JSONObject jSONObject5;
                JSONObject jSONObject3;
                JSONObject jSONObject6 = jSONObject2;
                String string = jSONObject6.toString();
                JSONObject jSONObject7 = jSONObject5;
                new JSONObject().put("collapseKey", (Object)this.a.getString("collapseKey"));
                jSONObject7.put("ttl", this.a.getInt("ttl"));
                jSONObject7.put("sendMode", this.a.getInt("sendMode"));
                jSONObject7.put("receiptMode", this.a.getInt("receiptMode"));
                jSONObject3 = jSONObject4;
                jSONObject4 = new JSONObject();
                if (jSONObject6.length() != 0) {
                    jSONObject3.put("data", (Object)string);
                }
                JSONObject jSONObject8 = jSONObject7;
                jSONObject3.put("msgId", (Object)this.a.getString("msgId"));
                jSONObject8.put("msgContent", (Object)jSONObject3);
                bundle2.putByteArray("message_body", jSONObject8.toString().getBytes(x.a));
                bundle2.putString("to", this.a.getString("to"));
                bundle2.putString("message_type", this.a.getString("message_type"));
                return new RemoteMessage(bundle2);
            }
            catch (JSONException jSONException) {
                HMSLog.w((String)"RemoteMessage", (String)"JSONException: parse message body failed.");
                throw new PushException("send message failed");
            }
        }

        public Builder addData(String string, String string2) {
            if (string != null) {
                Builder builder = this;
                builder.b.put(string, string2);
                return builder;
            }
            throw new IllegalArgumentException("add data failed, key is null.");
        }

        public Builder setData(Map<String, String> object) {
            this.b.clear();
            for (Map.Entry entry : object.entrySet()) {
                this.b.put((String)entry.getKey(), (String)entry.getValue());
            }
            return this;
        }

        public Builder clearData() {
            Builder builder = this;
            builder.b.clear();
            return builder;
        }

        public Builder setMessageId(String string) {
            Builder builder = this;
            builder.a.putString("msgId", string);
            return builder;
        }

        public Builder setMessageType(String string) {
            Builder builder = this;
            builder.a.putString("message_type", string);
            return builder;
        }

        public Builder setTtl(int n2) {
            if (n2 >= 1 && n2 <= 1296000) {
                Builder builder = this;
                builder.a.putInt("ttl", n2);
                return builder;
            }
            throw new IllegalArgumentException("ttl must be greater than or equal to 1 and less than or equal to 1296000");
        }

        public Builder setCollapseKey(String string) {
            Builder builder = this;
            builder.a.putString("collapseKey", string);
            return builder;
        }

        public Builder setSendMode(int n2) {
            if (n2 != 0 && n2 != 1) {
                throw new IllegalArgumentException("send mode can only be 0 or 1.");
            }
            Builder builder = this;
            builder.a.putInt("sendMode", n2);
            return builder;
        }

        public Builder setReceiptMode(int n2) {
            if (n2 != 1 && n2 != 0) {
                throw new IllegalArgumentException("receipt mode can only be 0 or 1.");
            }
            Builder builder = this;
            builder.a.putInt("receiptMode", n2);
            return builder;
        }
    }

    public static class Notification
    implements Serializable {
        public final String a;
        public final String b;
        public final String[] c;
        public final String d;
        public final String e;
        public final String[] f;
        public final String g;
        public final String h;
        public final String i;
        public final String j;
        public final String k;
        public final String l;
        public final String m;
        public final Uri n;
        public final int o;
        public final String p;
        public final int q;
        public final int r;
        public final int s;
        public final int[] t;
        public final String u;
        public final int v;
        public final String w;
        public final int x;
        public final String y;
        public final String z;
        public final long[] A;
        public final String B;

        public Notification(Bundle bundle) {
            this.a = bundle.getString("notifyTitle");
            this.d = bundle.getString("content");
            this.b = bundle.getString("title_loc_key");
            this.e = bundle.getString("body_loc_key");
            this.c = bundle.getStringArray("title_loc_args");
            this.f = bundle.getStringArray("body_loc_args");
            this.g = bundle.getString("icon");
            this.j = bundle.getString("color");
            this.h = bundle.getString("sound");
            this.i = bundle.getString("tag");
            this.m = bundle.getString("channelId");
            this.k = bundle.getString("acn");
            this.l = bundle.getString("intentUri");
            this.o = bundle.getInt("notifyId");
            String string = bundle.getString("url");
            string = !TextUtils.isEmpty((CharSequence)string) ? Uri.parse((String)string) : null;
            this.n = string;
            this.p = bundle.getString("notifyIcon");
            this.q = bundle.getInt("defaultLightSettings");
            this.r = bundle.getInt("defaultSound");
            this.s = bundle.getInt("defaultVibrateTimings");
            this.t = bundle.getIntArray("lightSettings");
            this.u = bundle.getString("when");
            this.v = bundle.getInt("localOnly");
            this.w = bundle.getString("badgeSetNum", null);
            this.x = bundle.getInt("autoCancel");
            this.y = bundle.getString("priority", null);
            this.z = bundle.getString("ticker");
            this.A = bundle.getLongArray("vibrateTimings");
            this.B = bundle.getString("visibility", null);
        }

        public /* synthetic */ Notification(Bundle bundle, b b2) {
            this(bundle);
        }

        public String getTitle() {
            return this.a;
        }

        public String getTitleLocalizationKey() {
            return this.b;
        }

        public String[] getTitleLocalizationArgs() {
            String[] stringArray = stringArray.c;
            return stringArray.c == null ? new String[]{} : (String[])stringArray.clone();
        }

        public String getBody() {
            return this.d;
        }

        public String getBodyLocalizationKey() {
            return this.e;
        }

        public String[] getBodyLocalizationArgs() {
            String[] stringArray = stringArray.f;
            return stringArray.f == null ? new String[]{} : (String[])stringArray.clone();
        }

        public String getIcon() {
            return this.g;
        }

        public Uri getImageUrl() {
            String string = ((Notification)((Object)string)).p;
            return string == null ? null : Uri.parse((String)string);
        }

        public String getSound() {
            return this.h;
        }

        public String getTag() {
            return this.i;
        }

        public String getColor() {
            return this.j;
        }

        public String getClickAction() {
            return this.k;
        }

        public String getIntentUri() {
            return this.l;
        }

        public String getChannelId() {
            return this.m;
        }

        public Uri getLink() {
            return this.n;
        }

        public int getNotifyId() {
            return this.o;
        }

        public boolean isDefaultLight() {
            return this.q == 1;
        }

        public boolean isDefaultSound() {
            return this.r == 1;
        }

        public boolean isDefaultVibrate() {
            return this.s == 1;
        }

        public Long getWhen() {
            block4: {
                Serializable serializable;
                Object var1_1 = null;
                if (!TextUtils.isEmpty((CharSequence)serializable.u)) {
                    try {
                        serializable = Long.valueOf(DateUtil.parseUtcToMillisecond(serializable.u));
                        break block4;
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        HMSLog.w((String)"RemoteMessage", (String)"StringIndexOutOfBoundsException: parse when failed.");
                    }
                    catch (ParseException parseException) {
                        HMSLog.w((String)"RemoteMessage", (String)"ParseException: parse when failed.");
                    }
                }
                serializable = var1_1;
            }
            return serializable;
        }

        public int[] getLightSettings() {
            Object object = ((Notification)object).t;
            return ((Notification)object).t == null ? new int[]{} : (int[])object.clone();
        }

        public boolean isLocalOnly() {
            return this.v == 1;
        }

        public Integer getBadgeNumber() {
            Notification notification = this;
            return notification.a(notification.w);
        }

        public boolean isAutoCancel() {
            return this.x == 1;
        }

        public Integer getImportance() {
            Notification notification = this;
            return notification.a(notification.y);
        }

        public String getTicker() {
            return this.z;
        }

        public long[] getVibrateConfig() {
            Object object = ((Notification)object).A;
            return ((Notification)object).A == null ? new long[]{} : (long[])object.clone();
        }

        public Integer getVisibility() {
            Notification notification = this;
            return notification.a(notification.B);
        }

        public final Integer a(String string) {
            Serializable serializable;
            block3: {
                Notification notification = null;
                if (string != null) {
                    try {
                        serializable = Integer.valueOf(string);
                        break block3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        HMSLog.w((String)"RemoteMessage", (String)("NumberFormatException: get " + string + " failed."));
                    }
                }
                serializable = notification;
            }
            return serializable;
        }
    }
}

