/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import com.huawei.hms.support.common.ActivityMgr;
import com.huawei.hms.support.log.HMSLog;

public class UIUtil {
    public static boolean isActivityFullscreen(Activity activity) {
        return (activity.getWindow().getAttributes().flags & 0x400) == 1024;
    }

    public static Activity getActiveActivity(Activity activity, Context context) {
        if (UIUtil.isBackground(context)) {
            HMSLog.i((String)"UIUtil", (String)("isBackground" + UIUtil.isBackground(context)));
            return null;
        }
        if (activity == null) {
            HMSLog.i((String)"UIUtil", (String)"activity is null");
            return ActivityMgr.INST.getCurrentActivity();
        }
        if (activity.isFinishing()) {
            HMSLog.i((String)"UIUtil", (String)("activity isFinishing is " + activity.isFinishing()));
            return ActivityMgr.INST.getCurrentActivity();
        }
        return activity;
    }

    public static boolean isBackground(Context object) {
        if (object == null) {
            return true;
        }
        Object object2 = (ActivityManager)object.getSystemService("activity");
        KeyguardManager keyguardManager = (KeyguardManager)object.getSystemService("keyguard");
        if (object2 != null && keyguardManager != null) {
            if ((object2 = object2.getRunningAppProcesses()) == null) {
                return true;
            }
            object = UIUtil.getProcessName(object, Process.myPid());
            object2 = object2.iterator();
            while (object2.hasNext()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object2.next();
                if (!TextUtils.equals((CharSequence)runningAppProcessInfo.processName, (CharSequence)object)) continue;
                HMSLog.i((String)"UIUtil", (String)("appProcess.importance is " + runningAppProcessInfo.importance));
                boolean bl = runningAppProcessInfo.importance == 100;
                boolean bl2 = keyguardManager.isKeyguardLocked();
                HMSLog.i((String)"UIUtil", (String)("isForground is " + bl + "***  isLockedState is " + bl2));
                return !bl || bl2;
            }
            return true;
        }
        return true;
    }

    public static String getProcessName(Context object, int n) {
        if (object == null) {
            return "";
        }
        if ((object = (ActivityManager)object.getSystemService("activity")) != null && (object = object.getRunningAppProcesses()) != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                if (runningAppProcessInfo.pid != n) continue;
                return runningAppProcessInfo.processName;
            }
        }
        return "";
    }
}

