/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.parser;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.heytap.mcssdk.parser.MessageParser;
import com.heytap.mcssdk.statis.McsStatisticUtils;
import com.heytap.mcssdk.utils.CryptoUtil;
import com.heytap.mcssdk.utils.LogUtil;
import com.heytap.msp.push.mode.BaseMode;
import com.heytap.msp.push.mode.DataMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class DataMessageParser
extends MessageParser {
    @Override
    public BaseMode parse(Context context, int type, Intent intent) {
        if (4103 == type || 4098 == type || 4108 == type) {
            BaseMode baseMode = this.parseMessageByIntent(intent, type);
            McsStatisticUtils.statisticEvent(context, "push_transmit", (DataMessage)baseMode);
            return baseMode;
        }
        return null;
    }

    @Override
    public BaseMode parseMessageByIntent(Intent intent, int type) {
        try {
            DataMessage message = new DataMessage();
            message.setMessageID(CryptoUtil.sdkDecrypt(intent.getStringExtra("messageID")));
            message.setTaskID(CryptoUtil.sdkDecrypt(intent.getStringExtra("taskID")));
            message.setGlobalId(CryptoUtil.sdkDecrypt(intent.getStringExtra("globalID")));
            message.setAppPackage(CryptoUtil.sdkDecrypt(intent.getStringExtra("appPackage")));
            message.setTitle(CryptoUtil.sdkDecrypt(intent.getStringExtra("title")));
            message.setContent(CryptoUtil.sdkDecrypt(intent.getStringExtra("content")));
            message.setDescription(CryptoUtil.sdkDecrypt(intent.getStringExtra("description")));
            String notifyId = CryptoUtil.sdkDecrypt(intent.getStringExtra("notifyID"));
            message.setNotifyID(TextUtils.isEmpty((CharSequence)notifyId) ? 0 : Integer.parseInt(notifyId));
            message.setMiniProgramPkg(CryptoUtil.sdkDecrypt(intent.getStringExtra("miniProgramPkg")));
            message.setMessageType(type);
            message.setEventId(CryptoUtil.sdkDecrypt(intent.getStringExtra("eventId")));
            message.setStatisticsExtra(CryptoUtil.sdkDecrypt(intent.getStringExtra("statistics_extra")));
            String dataExtra = CryptoUtil.sdkDecrypt(intent.getStringExtra("data_extra"));
            message.setDataExtra(dataExtra);
            String msgCommand = this.getMsgCommand(dataExtra);
            message.setMsgCommand(TextUtils.isEmpty((CharSequence)msgCommand) ? 0 : Integer.parseInt(msgCommand));
            message.setBalanceTime(CryptoUtil.sdkDecrypt(intent.getStringExtra("balanceTime")));
            message.setStartDate(CryptoUtil.sdkDecrypt(intent.getStringExtra("startDate")));
            message.setEndDate(CryptoUtil.sdkDecrypt(intent.getStringExtra("endDate")));
            message.setTimeRanges(CryptoUtil.sdkDecrypt(intent.getStringExtra("timeRanges")));
            message.setRule(CryptoUtil.sdkDecrypt(intent.getStringExtra("rule")));
            message.setForcedDelivery(CryptoUtil.sdkDecrypt(intent.getStringExtra("forcedDelivery")));
            message.setDistinctContent(CryptoUtil.sdkDecrypt(intent.getStringExtra("distinctBycontent")));
            message.setAppId(CryptoUtil.sdkDecrypt(intent.getStringExtra("appID")));
            return message;
        }
        catch (Exception e) {
            LogUtil.d("OnHandleIntent--" + e.getMessage());
            return null;
        }
    }

    public String getMsgCommand(String extra) {
        String msgCommand = "";
        if (TextUtils.isEmpty((CharSequence)extra)) {
            return msgCommand;
        }
        try {
            JSONObject jsonObject = new JSONObject(extra);
            msgCommand = jsonObject.optString("msg_command");
        }
        catch (JSONException e) {
            LogUtil.d(e.getMessage());
        }
        return msgCommand;
    }
}

